<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Collections;
use App\Models\DimCollectionModel;
// Import Excel Package
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Csv;
use App\Libraries\CSVReader;
class ActiveCollectorsDimSheet extends BaseController
{


    /**
     * Returns the amount of weeks into the month a date is
     * @param $date a YYYY-MM-DD formatted date
     * @param $rollover The day on which the week rolls over
     */
   
function workingDays($year,$month){

	$days = cal_days_in_month(CAL_GREGORIAN, $month, $year); // 31
	$j = 1;
		$countWorkingDays = 0;
		for($i =0;$i<$days;$i++){
			$newDate = date('Y-m-d', strtotime(date('Y-m-d'). ' + '.$j.' days'));
			if(date("D", strtotime($newDate)) !='Sat' && date("D", strtotime($newDate)) !='Sat'){
					$countWorkingDays+=1;
			}
			$j++;
		}
		return $countWorkingDays;
}

public function all_record(){
	$result = $this->db->table('date_table')->select('*')->get()->getResult();
    $data['result'] = $result;
    return $data;
}

public function lastID(){
    $result =   $this->db->query('select * from date_table order by id desc limit 1')->getResult();
    if(!$result){
        echo 1;
    }else{
    echo $result[0]->id+1;    
    }
    
}


public function index()
{
    // $data = $this->all_record();
 
		
	$result= $this->db->table('date_table')->select('*')->get()->getResult();
    // $model = new DailyQualityWorkModel();
    // $data = [
    //     'record' => $model->paginate(100),
    //     'pager' => $model->pager
    // ];
          $data['result'] = $result;
  	return view('collectors_dim_sheet/index',$data);
}

    public function update($table){
        

	    if ($this->request->getMethod() == 'post') {
	    		$post = $this->request->getPost();
                $result = $this->db->table('date_table')->select('*')->where('id',$post['id'])->get()->getResult();
                $model = new DimCollectionModel();
                if($result){
                    $update = $model->update($post['id'], $post);        
                }else{
                    $this->db->transStart();
				    // $update = $this->db->table('Daily_Quality_Workbook_ML_CR')->insertBatch($post);
				    $update = $model->insert($post);
				    $this->db->transComplete();
				            
                }
                
                if($update){
                    echo 1;
                }else{
                    echo 0;
                }
        }    
    }

    public function delete($table){
         if ($this->request->getMethod() == 'post') {
            	$post = $this->request->getPost();
 
                $model = new DimCollectionModel();   
                $this->db->query('delete from date_table where id = '.$post['id'])->getResult();
                // if($update == 1){
                //     echo 1;
                // }else{
                //     echo 0;
                // }
             
         }
    }
    
    public function importSheet(){
    		$post = $this->request->getPost();
    		$session = session();
    	if ($this->request->getMethod() == "post") {
					
					$file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
					$arr_file = explode('.', $_FILES['upload_file']['name']);
					$extension = end($arr_file);
								
					if($extension !='xlsx' && $extension !='csv'){
                        $session->setFlashdata('error', 'Only Xlsx and Csv File You Can Import');
                        return redirect()->to(base_url('active_collectors_mlm_dim_sheet/'));
                    }
                    
					if('csv' == $extension){
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					} else {
						$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					}
					$spreadsheet = $reader->load($_FILES['upload_file']['tmp_name']);
					$sheetData = $spreadsheet->getActiveSheet()->toArray();
					if($sheetData){
						$total_array = [];
                        $table_descriptions = $this->db->query('describe date_table')->getResult();
                    
                        if($table_descriptions){
                            $table_fields = count($table_descriptions)-1;
                            $sheet_columns = count($sheetData[0]);
                            if($sheet_columns > $table_fields || $sheet_columns < $table_fields){
                                $session->setFlashdata('error', 'Something Went Wrong Sheet Not Imported Successfully Check The Fields Carefully');
                                return redirect()->to(base_url('active_collectors_mlm_dim_sheet/'));
                            }
                        }
                
						foreach($sheetData as $key=>$value){
							if($key>0){
                                $mult_array['Date'] = trim($value[0]);
			    				$mult_array['Weekday'] = $value[1];
			    				$mult_array['Working_day'] = $value[2];
			    			
			    				$total_array[] = $mult_array;
							}
						}

						if($total_array){
						    $this->db->query('delete from date_table')->getResult();
				            $this->db->transStart();
				            // $collection = new Collections;
				            $this->db->table('date_table')->insertBatch($total_array);
				            $this->db->transComplete();
				            
				            $session->setFlashdata('success', 'Data Imported Successfully');
				            return redirect()->to(base_url('active_collectors_mlm_dim_sheet/'));
						}else{
						    $session->setFlashdata('error', 'Something went wrong');
				            return redirect()->to(base_url('active_collectors_mlm_dim_sheet/'));
						}
							
					}else{

					}
					}

   			
        }

	
	public function downloadExcelReport()
	{
		$result = $this->all_record();
		$fileName = 'active_colletion_sheet_'.date('Y-m-d').'.csv'; // File is to create
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$spreadsheet = new Spreadsheet();
		$sheet = $spreadsheet->getActiveSheet();
		$sheet->setCellValue('A1', 'Date');
		$sheet->setCellValue('B1', 'Weekday');
		$sheet->setCellValue('C1', 'Working Day');
		$rows = 2;
		$rows2 = 2;
		$j = 1; 
		$k = 1;
		foreach ($result['result'] as $key=>$value) {
			$start = 0;
			$days_increment = 5; 
			$end = 3; 
			$weeks = intval(date("t")/5);
				$sheet->setCellValue('A' . $rows, $value->Date);
				$sheet->setCellValue('B' . $rows, $value->Weekday); 
				$sheet->setCellValue('C' . $rows, $value->Working_Day); 
			$k++;
			$rows++;
		}


		$writer = new Csv($spreadsheet);

		// file inside /public folder
		$filepath = $fileName;

		$writer->save($filepath);

		header("Content-Type: application/vnd.ms-excel");
		header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');

		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($filepath));
		flush(); // Flush system output buffer
		readfile($filepath);

		exit;
	}




}
