<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
// $routes->get('/', 'Home::index');
// $routes->group("collections", function ($routes) {

    // $routes->post("register", "User::register");




$routes->get('/', 'User::login', ['filter' => 'noauth']);
$routes->match(['get', 'post'], 'login', 'User::login', ['filter' => 'noauth']);
$routes->get('dashboard', 'Dashboard::index', ['filter' => 'auth']);
$routes->post('rest_password', 'User::rest_password', ['filter' => 'auth']);
$routes->get('profile', 'User::profile', ['filter' => 'auth']);
$routes->get('logout', 'User::logout');
$routes->get("/settings", "Settings::index", ['filter' => 'auth']);

$routes->match(['get', 'post'], 'register', 'User::register', ['filter' => 'auth']);
$routes->match(['get'], 'users', 'User::users', ['filter' => 'auth']);
$routes->match(['get'], 'users/last_id', 'User::last_id', ['filter' => 'auth']);
$routes->match(['get'], 'users/get_roles', 'User::get_roles', ['filter' => 'auth']);
$routes->post('/users/update', 'User::update', ['filter' => 'auth']);
$routes->post('/users/delete', 'User::delete', ['filter' => 'auth']);


$routes->match(['get'], 'users/permissions', 'User::permissions', ['filter' => 'auth']);
$routes->match(['get'], 'users/roles', 'User::roles', ['filter' => 'auth']);
$routes->post('/users/permission_update', 'User::permission_update', ['filter' => 'auth']);
$routes->post('/users/role_delete', 'User::role_delete', ['filter' => 'auth']);

$routes->get("/users/get_all_modules/(:any)","User::get_all_modules/$1",['filter'=>'auth']);
$routes->post("/users/update_modules_permission","User::update_modules_permission",['filter'=>'auth']);


// update_role_permission
$routes->get("/collections", "Collection::index", ['filter' => 'auth']);
$routes->post("/collections/update/(:any)", "Collection::update/$1", ['filter' => 'auth']);
$routes->get("/collections/get_records", "Collection::get_records", ['filter' => 'auth']);
$routes->get("/collections/manager_list", "Collection::manager_list", ['filter' => 'auth']);
$routes->get("/collections/downloadExcelReportManagerList", "Collection::downloadExcelReportManagerList", ['filter' => 'auth']);
$routes->post("/collections/importSheetManagerList", "Collection::importSheetManagerList", ['filter' => 'auth']);
$routes->post("/collections/importSheetAliasList", "Collection::importSheetAliasList", ['filter' => 'auth']);
$routes->get("/collections/primary_alias_list", "Collection::alias_list", ['filter' => 'auth']);
$routes->get("/collections/downloadExcelReport", "Collection::downloadExcelReport", ['filter' => 'auth']);
$routes->get("/collections/manager_list_get", "Collection::manager_list_get", ['filter' => 'auth']);
$routes->post("/collections/importSheet", "Collection::importSheet", ['filter' => 'auth']);

$routes->get("/collections/downloadExcelReportAliasList", "Collection::downloadExcelReportAliasList", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns", "Activeagenttargetdetailscampaign::index", ['filter' => 'auth']);

$routes->post("/active_agent_target_details_campaigns/update/(:any)", "Activeagenttargetdetailscampaign::update/$1", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/get_records", "Activeagenttargetdetailscampaign::get_records", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/manager_list", "Activeagenttargetdetailscampaign::manager_list", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/downloadExcelReportManagerList", "Activeagenttargetdetailscampaign::downloadExcelReportManagerList", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/downloadExcelReportAliasList", "Activeagenttargetdetailscampaign::downloadExcelReportAliasList", ['filter' => 'auth']);

$routes->post("/active_agent_target_details_campaigns/importSheetManagerList", "Activeagenttargetdetailscampaign::importSheetManagerList", ['filter' => 'auth']);

$routes->post("/active_agent_target_details_campaigns/importSheetAliasList", "Activeagenttargetdetailscampaign::importSheetAliasList", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/primary_alias_list", "Activeagenttargetdetailscampaign::alias_list", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/downloadExcelReport", "Activeagenttargetdetailscampaign::downloadExcelReport", ['filter' => 'auth']);

$routes->get("/active_agent_target_details_campaigns/manager_list_get", "Activeagenttargetdetailscampaign::manager_list_get", ['filter' => 'auth']);

$routes->post("/active_agent_target_details_campaigns/importSheet", "Activeagenttargetdetailscampaign::importSheet", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections", "Activecollectorstargetdetailspicollections::index", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_pi_collections/update/(:any)", "Activecollectorstargetdetailspicollections::update/$1", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/get_records", "Activecollectorstargetdetailspicollections::get_records", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/manager_list", "Activecollectorstargetdetailspicollections::manager_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/downloadExcelReportManagerList", "Activecollectorstargetdetailspicollections::downloadExcelReportManagerList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/downloadExcelReportAliasList", "Activecollectorstargetdetailspicollections::downloadExcelReportAliasList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_pi_collections/importSheetManagerList", "Activecollectorstargetdetailspicollections::importSheetManagerList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_pi_collections/importSheetAliasList", "Activecollectorstargetdetailspicollections::importSheetAliasList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/primary_alias_list", "Activecollectorstargetdetailspicollections::alias_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/downloadExcelReport", "Activecollectorstargetdetailspicollections::downloadExcelReport", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_pi_collections/manager_list_get", "Activecollectorstargetdetailspicollections::manager_list_get", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_pi_collections/importSheet", "Activecollectorstargetdetailspicollections::importSheet", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification", "Activecollectorstargetdetailsverification::index", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_verification/update/(:any)", "Activecollectorstargetdetailsverification::update/$1", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/get_records", "Activecollectorstargetdetailsverification::get_records", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/manager_list", "Activecollectorstargetdetailsverification::manager_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/downloadExcelReportManagerList", "Activecollectorstargetdetailsverification::downloadExcelReportManagerList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/downloadExcelReportAliasList", "Activecollectorstargetdetailsverification::downloadExcelReportAliasList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_verification/importSheetManagerList", "Activecollectorstargetdetailsverification::importSheetManagerList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_verification/importSheetAliasList", "Activecollectorstargetdetailsverification::importSheetAliasList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/primary_alias_list", "Activecollectorstargetdetailsverification::alias_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/downloadExcelReport", "Activecollectorstargetdetailsverification::downloadExcelReport", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_verification/manager_list_get", "Activecollectorstargetdetailsverification::manager_list_get", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_verification/importSheet", "Activecollectorstargetdetailsverification::importSheet", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections", "Activecollectorstargetdetailsmlcrcollections::index", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_collections/update/(:any)", "Activecollectorstargetdetailsmlcrcollections::update/$1", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/get_records", "Activecollectorstargetdetailsmlcrcollections::get_records", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/manager_list", "Activecollectorstargetdetailsmlcrcollections::manager_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/downloadExcelReportManagerList", "Activecollectorstargetdetailsmlcrcollections::downloadExcelReportManagerList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/downloadExcelReportAliasList", "Activecollectorstargetdetailsmlcrcollections::downloadExcelReportAliasList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_collections/importSheetManagerList", "Activecollectorstargetdetailsmlcrcollections::importSheetManagerList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_collections/importSheetAliasList", "Activecollectorstargetdetailsmlcrcollections::importSheetAliasList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/primary_alias_list", "Activecollectorstargetdetailsmlcrcollections::alias_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/downloadExcelReport", "Activecollectorstargetdetailsmlcrcollections::downloadExcelReport", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_collections/manager_list_get", "Activecollectorstargetdetailsmlcrcollections::manager_list_get", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_collections/importSheet", "Activecollectorstargetdetailsmlcrcollections::importSheet", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support", "Activecollectorstargetdetailmlrcsupport::index", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_support/update/(:any)", "Activecollectorstargetdetailmlrcsupport::update/$1", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/get_records", "Activecollectorstargetdetailmlrcsupport::get_records", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/manager_list", "Activecollectorstargetdetailmlrcsupport::manager_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/downloadExcelReportManagerList", "Activecollectorstargetdetailmlrcsupport::downloadExcelReportManagerList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/downloadExcelReportAliasList", "Activecollectorstargetdetailmlrcsupport::downloadExcelReportAliasList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_support/importSheetManagerList", "Activecollectorstargetdetailmlrcsupport::importSheetManagerList", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_support/importSheetAliasList", "Activecollectorstargetdetailmlrcsupport::importSheetAliasList", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/primary_alias_list", "Activecollectorstargetdetailmlrcsupport::alias_list", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/downloadExcelReport", "Activecollectorstargetdetailmlrcsupport::downloadExcelReport", ['filter' => 'auth']);

$routes->get("/active_collectors_target_details_mlcr_support/manager_list_get", "Activecollectorstargetdetailmlrcsupport::manager_list_get", ['filter' => 'auth']);

$routes->post("/active_collectors_target_details_mlcr_support/importSheet", "Activecollectorstargetdetailmlrcsupport::importSheet", ['filter' => 'auth']);


$routes->get("/active_collectors_daily_quality_work_book_mlcr", "Activecollectorsdailyqualityworkbook::index", ['filter' => 'auth']);

$routes->get("/active_collectors_daily_quality_work_book_mlcr/last_id", "Activecollectorsdailyqualityworkbook::lastID", ['filter' => 'auth']);

$routes->post("/active_collectors_daily_quality_work_book_mlcr/update/(:any)", "Activecollectorsdailyqualityworkbook::update/$1", ['filter' => 'auth']);

$routes->post("/active_collectors_daily_quality_work_book_mlcr/delete/(:any)", "Activecollectorsdailyqualityworkbook::delete/$1", ['filter' => 'auth']);

// $routes->get("/active_collectors_target_details_mlcr_support/get_records", "Activecollectorstargetdetailmlrcsupport::get_records", ['filter' => 'auth']);

// $routes->get("/active_collectors_target_details_mlcr_support/manager_list", "Activecollectorstargetdetailmlrcsupport::manager_list", ['filter' => 'auth']);

// $routes->get("/active_collectors_target_details_mlcr_support/downloadExcelReportManagerList", "Activecollectorstargetdetailmlrcsupport::downloadExcelReportManagerList", ['filter' => 'auth']);

// $routes->get("/active_collectors_target_details_mlcr_support/downloadExcelReportAliasList", "Activecollectorstargetdetailmlrcsupport::downloadExcelReportAliasList", ['filter' => 'auth']);

// $routes->post("/active_collectors_target_details_mlcr_support/importSheetManagerList", "Activecollectorstargetdetailmlrcsupport::importSheetManagerList", ['filter' => 'auth']);

// $routes->post("/active_collectors_target_details_mlcr_support/importSheetAliasList", "Activecollectorstargetdetailmlrcsupport::importSheetAliasList", ['filter' => 'auth']);

// $routes->get("/active_collectors_target_details_mlcr_support/primary_alias_list", "Activecollectorstargetdetailmlrcsupport::alias_list", ['filter' => 'auth']);

$routes->get("/active_collectors_daily_quality_work_book_mlcr/downloadExcelReport", "Activecollectorsdailyqualityworkbook::downloadExcelReport", ['filter' => 'auth']);

// $routes->get("/active_collectors_target_details_mlcr_support/manager_list_get", "Activecollectorstargetdetailmlrcsupport::manager_list_get", ['filter' => 'auth']);

$routes->post("/active_collectors_daily_quality_work_book_mlcr/importSheet", "Activecollectorsdailyqualityworkbook::importSheet", ['filter' => 'auth']);

$routes->get("/active_collectors_mlm_dim_sheet", "ActiveCollectorsDimSheet::index", ['filter' => 'auth']);
$routes->get("/active_collectors_mlm_dim_sheet/last_id", "ActiveCollectorsDimSheet::lastID", ['filter' => 'auth']);
$routes->post("/active_collectors_mlm_dim_sheet/update/(:any)", "ActiveCollectorsDimSheet::update/$1", ['filter' => 'auth']);
$routes->post("/active_collectors_mlm_dim_sheet/delete/(:any)", "ActiveCollectorsDimSheet::delete/$1", ['filter' => 'auth']);
$routes->get("/active_collectors_mlm_dim_sheet/downloadExcelReport", "ActiveCollectorsDimSheet::downloadExcelReport", ['filter' => 'auth']);
$routes->post("/active_collectors_mlm_dim_sheet/importSheet", "ActiveCollectorsDimSheet::importSheet", ['filter' => 'auth']);

$routes->get("/active_collectors_provider_list", "ActiveCollectorsProviderList::index", ['filter' => 'auth']);
$routes->get("/active_collectors_provider_list/last_id", "ActiveCollectorsProviderList::lastID", ['filter' => 'auth']);
$routes->post("/active_collectors_provider_list/update/(:any)", "ActiveCollectorsProviderList::update/$1", ['filter' => 'auth']);
$routes->post("/active_collectors_provider_list/delete/(:any)", "ActiveCollectorsProviderList::delete/$1", ['filter' => 'auth']);
$routes->get("/active_collectors_provider_list/downloadExcelReport", "ActiveCollectorsProviderList::downloadExcelReport", ['filter' => 'auth']);
$routes->post("/active_collectors_provider_list/importSheet", "ActiveCollectorsProviderList::importSheet", ['filter' => 'auth']);

$routes->get("/incentive_tracker_sample", "IncentiveTrackerSample::index", ['filter' => 'auth']);
$routes->get("/incentive_tracker_sample/last_id", "IncentiveTrackerSample::lastID", ['filter' => 'auth']);
$routes->post("/incentive_tracker_sample/update", "IncentiveTrackerSample::update", ['filter' => 'auth']);
$routes->post("/incentive_tracker_sample/delete/(:any)", "IncentiveTrackerSample::delete/$1", ['filter' => 'auth']);
$routes->get("/incentive_tracker_sample/downloadExcelReport", "IncentiveTrackerSample::downloadExcelReport", ['filter' => 'auth']);
$routes->post("/incentive_tracker_sample/importSheet", "IncentiveTrackerSample::importSheet", ['filter' => 'auth']);



// pi settlement
$routes->get("/active_collectors_pi_settlement_data", "Activecollectorspisettlement::index", ['filter' => 'auth']);
$routes->get("/active_collectors_pi_settlement_data/last_id", "Activecollectorspisettlement::lastID", ['filter' => 'auth']);
$routes->post("/active_collectors_pi_settlement_data/update/(:any)", "Activecollectorspisettlement::update/$1", ['filter' => 'auth']);
$routes->post("/active_collectors_pi_settlement_data/delete/(:any)", "Activecollectorspisettlement::delete/$1", ['filter' => 'auth']);
$routes->get("/active_collectors_pi_settlement_data/downloadExcelReport", "Activecollectorspisettlement::downloadExcelReport", ['filter' => 'auth']);
$routes->post("/active_collectors_pi_settlement_data/importSheet", "Activecollectorspisettlement::importSheet", ['filter' => 'auth']);



// mlm_settlement_delta_running
$routes->get("/active_collectors_mlm_settlement_delta_running", "Activecollectorsmlmsettlementdeltarunning::index", ['filter' => 'auth']);
$routes->get("/active_collectors_mlm_settlement_delta_running/last_id", "Activecollectorsmlmsettlementdeltarunning::lastID", ['filter' => 'auth']);
$routes->post("/active_collectors_mlm_settlement_delta_running/update/(:any)", "Activecollectorsmlmsettlementdeltarunning::update/$1", ['filter' => 'auth']);
$routes->post("/active_collectors_mlm_settlement_delta_running/delete/(:any)", "Activecollectorsmlmsettlementdeltarunning::delete/$1", ['filter' => 'auth']);
$routes->get("/active_collectors_mlm_settlement_delta_running/downloadExcelReport", "Activecollectorsmlmsettlementdeltarunning::downloadExcelReport", ['filter' => 'auth']);
$routes->post("/active_collectors_mlm_settlement_delta_running/importSheet", "Activecollectorsmlmsettlementdeltarunning::importSheet", ['filter' => 'auth']);










// target allotment departments routs

$routes->get("/target_allotments", "TargetAllotments::index", ['filter' => 'auth']);
$routes->post("/target_allotments/importSheet", "TargetAllotments::importSheet", ['filter' => 'auth']);
$routes->post("/target_allotments/show_target_form", "TargetAllotments::showTargetForm", ['filter' => 'auth']);
$routes->post("/target_allotments/approved_and_send", "TargetAllotments::approvedAndSend", ['filter' => 'auth']);
$routes->post("/target_allotments/check_emails_exists", "TargetAllotments::checkEmailExists", ['filter' => 'auth']);
$routes->post("/target_allotments/send_bulk_email", "TargetAllotments::sendBulkEmail", ['filter' => 'auth']);
$routes->post("/target_allotments/show_document", "TargetAllotments::convertPDF", ['filter' => 'auth']);
$routes->post("/target_allotments/add_table_example", "TargetAllotments::add_table_example", ['filter' => 'auth']);
$routes->post("/target_allotments/download_example", "TargetAllotments::download_example", ['filter' => 'auth']);
$routes->post("/target_allotments/delete_targets", "TargetAllotments::delete_targets", ['filter' => 'auth']);

$routes->get("/target_allotments/file_verification", "TargetAllotments::file_verification", ['filter' => 'auth']);
$routes->get("/target_allotments/gsb", "TargetAllotments::gsb", ['filter' => 'auth']);
$routes->get("/target_allotments/mlcr_collection", "TargetAllotments::mlcr_collection", ['filter' => 'auth']);
$routes->get("/target_allotments/mlcr_support", "TargetAllotments::mlcr_support", ['filter' => 'auth']);
$routes->get("/target_allotments/wc_collection", "TargetAllotments::wc_collection", ['filter' => 'auth']);



//without authentication employee
$routes->get("/employee_target_form", "TargetAllotments::employee_target_form");

$routes->post("/target_allotments/target_assigned_employee", "TargetAllotments::target_assigned_employee");

$routes->cli('/check_collectors_target_status', 'CollectionJobs::check_collectors_target_status');
// $routes->get('/check_collectors_target_status', 'CollectionJobs::check_collectors_target_status');

// });
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
