class Rating_chart {
    id = null;
    parent_div = null
    _div = 1;
    max = 100;
    points = [];
    labels = [];
    _dev = []
    constructor(id, labels) {
        this.id = id;
        this.labels = labels;
        this.parent_div = document.getElementById(this.id);
        this.max = labels.length;
        this._div = 100 / labels.length

        this.__make();
        return this;
    }
    add(name, label, color) {
        if (!this.parent_div) {
            return
        }
        for (const key in this._dev) {
            this._dev[key] += 3
        }
        this._dev[name] = 0;
        let point = document.createElement('div');
        this.points[name] = point.id = `point-${name}-${this.makeid(4)}`;
        point.className = 'point-dot';
        point.setAttribute('data-label', label)
        point.style.backgroundColor = color
        this.parent_div.getElementsByClassName('rating-chart')[0].insertBefore(point, this.parent_div.getElementsByClassName('rating-chart')[0].firstChild)
        return this;
    }
    set(name, x, y) {
        if (!this.parent_div) {
            return
        }
        let elem = document.getElementById(this.points[name])
        x = ((x / this.max) * 98) - this._dev[name];
        y = 98 - ((y / this.max) * 98);
        if (x > 98 - this._dev[name]) {
            x = 98 - this._dev[name]
        }
        if (y > 98) {
            y = 98
        }
        elem.style.left = `${x}%`
        elem.style.top = `${y}%`;
        return this;
    }
    __make() {
        if (!this.parent_div) {
            return
        }
        let html = '';
        html += `<div class="rating-chart">
                    <table class="table fixed">`;
        let current_count = this.labels.length;
        for (let row = 0; row < this.labels.length; row++) {
            current_count--;
            html += `<tr data-label="${this.labels[row]}">`;
            for (let col = 0; col < this.labels.length; col++) {
                html += `<td class="b-${col <= current_count ? 'left' : ''} b-${col >= current_count ? 'down' : ''}"></td>`;
            }
            html += '</tr>'
        }
        html += '</table></div>';
        this.parent_div.innerHTML = html
    }
    makeid(length) {
        var result = '';
        var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
        var charactersLength = characters.length;
        for (var i = 0; i < length; i++) {
            result += characters.charAt(Math.floor(Math.random() *
                charactersLength));
        }
        return result;
    }
}