var hrmApp = angular.module("hrmApp", ['ngCookies', 'chart.js', 'ngSanitize', 'ui.select', 'ui.bootstrap']);
hrmApp.filter('slug_to_readable', function() {
    return function(str) {
        if(!str) {
            return '';
        }
        return str.replace(/[\_\-]+/gi, '_').split('_').map((s) => {return s.charAt(0).toUpperCase() + s.substr(1)}).join(' ');
    }
});
hrmApp.filter('formatTimer', function() {
    return function(seconds) {
        if(seconds < 1) {
            return '00:00:00'
        }
        function z(n) { return (n < 10 ? '0' : '') + n; }
        let _seconds = seconds % 60;
        let _minutes = Math.floor(seconds % 3600 / 60);
        let _hours = Math.floor(seconds / 3600);
        return (z(_hours) + ':' + z(_minutes) + ':' + z(_seconds));
    }
});