<?php 
function _generate_sidebar($module, $item, &$ci = null, $level = 1, $item_label = '')
{
    if(in_array($module['module'], ['developer']) && $ci->session->userdata('isAdmin')) {
        return;
    }
    if($item['permission'] == 'all') {
    } elseif($level == 1 && $module['module'] == 'dashboard' && (
        $ci->permission->module('user')->access() ||
        $ci->permission->module('role_permission')->access() ||
        $ci->permission->module('application_setting')->access() ||
        $ci->permission->module('email_settings')->access() ||
        $ci->permission->module('language')->access() ||
        $ci->permission->module('document_templates_head')->access()
    )) {
    } elseif (!$ci->permission->module($level == 1 ? $module['module'] : $item_label)->access()) {
        return;
    }
    if($item['controller']) {
        $_match = [];
        $_uri = $module['module'] . '/';
        if(strtolower($module['module']) != strtolower($item['controller'])) {
            $_uri .= $item['controller'] . '/';
        }
        if($item['method']) {
            $_uri .= $item['method'];
        } else {
            $_match[] = strtolower($_uri) . '/' . 'index';
        }
        $_match[] = strtolower($_uri);
        echo '<li class="treeview' . (in_array(strtolower(uri_string()), $_match) ? ' active' : null) . '">
                <a href="' . base_url($_uri) . '">' .
                    ($level == 1 ? $module['icon'] : null) .
                    '<span>' . display($level == 1 ? $module['label'] : $item_label) . '</span>
                </a>
            </li>';
    } else {
        echo '<li class="treeview';
        if($level == 1) {
            echo ' sdbr-' . $module['module'];
        }
        if($ci->uri->total_segments() == 3) {
            if(
                $ci->uri->segment(1) == $module['module']
                && $ci->uri->segment(2)
                && ($ci->uri->segment(3)
                && in_array($ci->uri->segment(2), array_column(flatten_sidebar($item), 'controller')))
                && in_array($ci->uri->segment(3), array_column(flatten_sidebar($item), 'method'))
            ) {
                echo ' active';
            }
        } else {
            if(
                $ci->uri->segment(1) == $module['module']
                && $ci->uri->segment(2)
                && in_array($ci->uri->segment(2), array_column(flatten_sidebar($item), 'method'))
            ) {
                echo ' active';
            }
        }
        echo '">
        <a href="javascript:void(0)">' .
            ($level == 1 ? $module['icon'] : null) .
            '<span>' . display($level == 1 ? $module['label'] : $item_label) . '</span>
            <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
            </span>
        </a> 
        <ul class="treeview-menu">';
        foreach ($item as $item_label => $itm) {
            _generate_sidebar($module, $itm, $ci, ++$level, $item_label);
        }
        echo '</ul>';
    }
}
?>
<style>
    .user-panel .info p {
        white-space: break-spaces;
    }
    .user-panel .info small {
        color: #888;
        white-space: break-spaces;
    }
</style>
<div class="sidebar">
    <div class="user-panel text-center">
        <div class="image">
            <?php $image = $this->session->userdata('image') ?>
            <img src="<?= base_url((!empty($image)?$image:'assets/img/icons/default.jpg')) ?>?id=<?= $this->session->userdata('id') ?>" class="img-circle"
                alt="User Image">
        </div>
        <div class="info">
            <p><?= $this->session->userdata('fullname') ?></p>
            <div><small><?= $this->session->userdata('designation') ?></small></div>
            <a href="#"><i class="fa fa-circle text-success"></i> <?= $this->session->userdata('user_level') ?></a>
        </div>
    </div>
    <!-- sidebar menu -->
    <ul class="sidebar-menu">
        <?php foreach ($this->_side__bar as $module) {
            _generate_sidebar(
                ['label' => $module['label'] ?? $module['module'], 'module' => $module['module'], 'icon' => $module['icon']],
                $module['items'],
                get_instance()
            );
        }?>
        <li>
            <div id="big_notif_panel">
                <?php if($this->permission->method('noticeboard', 'read')->access()): ?>
                <div class="">
                    <button class="btn btn-noti"><a href="<?= base_url() ?>noticeboard/Notice_controller/create_notice"
                            class="notif-txt">Notice Board <span class="count">0</span></a></button>
                </div>
                <?php endif?>
                <?php if($this->permission->method('notification', 'read')->access()) :?>
                <div class="">
                    <button class="btn btn-notificat"><a href="<?= base_url() ?>notification/Notification/index"
                            class="notificat-txt">Notification <span class="count">0</span></a></button>
                </div>
                <?php endif?>
            </div>
        </li>
        <li>
            <div id="small_notif_panel" style="display:none">
                <?php if($this->permission->method('noticeboard', 'read')->access()): ?>
                <div class="">
                    <button class="btn btn-noti"><a href="<?= base_url() ?>noticeboard/Notice_controller/create_notice"
                            class="notif-txt"><i class="fa fa-clipboard" aria-hidden="true"></i> <span
                                class="count">0</span></a></button>
                </div>
                <?php endif?>
                <?php if($this->permission->method('notification', 'read')->access()) :?>
                <div class="">
                    <button class="btn btn-notificat"><a href="<?= base_url() ?>notification/Notification/index"
                            class="notificat-txt"><i class="fa fa-bell-o notified" aria-hidden="true"></i> <span
                                class="count">0</span></a></button>
                </div>
                <?php endif?>
            </div>
        </li>
    </ul>
</div> <!-- /.sidebar -->
<script type="text/javascript">
var toastrOpts = {
    "closeButton": false,
    "debug": false,
    "newestOnTop": true,
    "progressBar": true,
    "positionClass": "toast-top-center",
    "preventDuplicates": false,
    "showDuration": "300",
    "hideDuration": "1000",
    "timeOut": "5000",
    "extendedTimeOut": "1000",
    "showEasing": "swing",
    "hideEasing": "linear",
    "showMethod": "fadeIn",
    "hideMethod": "fadeOut"
}
$('.btn-noti, .btn-noti>a').on('click', function(e) {
    e.preventDefault()
    location.href = '<?= base_url() ?>noticeboard/Notice_controller/create_notice'
})
$('.btn-notificat, .btn-notificat>a').on('click', function(e) {
    e.preventDefault()
    location.href = '<?= base_url() ?>notification/Notification/index'
})
$(document).ready(function() {
    $.ajax({
        type: "POST",
        url: "<?= base_url();?>notification/Notification/countNotification",
        beforeSend: () => {},
        success: function(data) {
            <?php if($this->session->flashdata('show_notifications_toaster')): ?>
            if (data > 0) {
                toastr.info(`You have ${data} new notification${data > 1 ? 's' : ''}!`, null, $
                    .extend({}, toastrOpts, {
                        onclick: () => {
                            location.href =
                                '<?= base_url('notification/Notification/index') ?>'
                        }
                    }))
            }
            <?php endif ?>
            $('.btn-notificat .count').text(data)
        }
    });
    $.ajax({
        type: "POST",
        url: "<?= base_url();?>noticeboard/Notice_controller/unread_count",
        beforeSend: () => {},
        success: function(data) {
            if (data.count) {
                <?php if($this->session->flashdata('show_notifications_toaster')): ?>
                if (data.count > 0) {
                    toastr.warning(`You have ${data.count} new notice${data.count > 1 ? 's' : ''}!`,
                        null, $.extend({}, toastrOpts, {
                            timeOut: 7000,
                            onclick: () => {
                                location.href =
                                    '<?= base_url('noticeboard/Notice_controller/create_notice') ?>'
                            }
                        }))
                }
                <?php endif ?>
                $('.btn-noti .count').text(data.count)
            }
        }
    });
});
</script>