<div class="container-fluid">
    <div class="row">
        <div class="col-lg-4">
            <div class="form-group">
              <label for="selStatus">Status</label>
              <select class="form-control dont-select-me" id="selStatus" multiple>
                <?php foreach ($statuses as $key => $value) : ?>
                <option value="<?= $key ?>" <?= in_array($key, ['active', 'on-hold', 'resignation-received']) ? 'selected' : null ?>><?= $value ?></option>
                <?php endforeach?>
              </select>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="form-group">
              <label for="selDivision">Division</label>
              <select class="form-control dont-select-me" id="selDivision">
                <option value=""> </option>
                <?php foreach ($divisions as $division) : ?>
                <option value="<?= $division->id ?>"><?= $division->title ?></option>
                <?php endforeach?>
              </select>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="form-group">
              <label for="selDepartment">Department</label>
              <select class="form-control dont-select-me" id="selDepartment" multiple>
                <?php foreach ($departments as $department) : ?>
                <option value="<?= $department->id ?>"><?= $department->title ?></option>
                <?php endforeach?>
              </select>
            </div>
        </div>
        <div class="col-xs-12">
            <button type="button" class="btn btn-primary btn-filter pull-right">Filter</button>
        </div>
    </div>
    <br>
    <table width="100%" class="table table-hover">
        <thead>
            <tr>
                <th>Employee ID</th>
                <th>Employee Name</th>
                <th>Missing Documents</th>
                <th>Division</th>
                <th>Department</th>
                <th>Manager Name</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        $('.dont-select-me').selectize({
            plugins: ["remove_button"]
        });
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    beforeSend: function(){},
                    data: function(d) {
                        if($('#selStatus').val()) {
                            d.status = $('#selStatus').val()
                        }
                        if($('#selDivision').val()) {
                            d.division = $('#selDivision').val()
                        }
                        if($('#selDepartment').val()) {
                            d.department = $('#selDepartment').val()
                        }
                    }
                },
                columns: [
                    {
                        'data': 'hrm_id',
                    }, {
                        'data': 'full_name',
                    }, {
                        'data': 'title',
                        'sortable': false
                    }, {
                        'data': 'division',
                    },
                    {
                        'data': 'department'
                    },
                    {
                        'data': 'direct_manager_name',
                    },
                ],
            }
        ))
        $('.btn-filter').on('click', function() {
            $('.se-pre-con').show();
            window.dtable.ajax.reload()
        })
    });
</script>