<?php $this->load->view('dashboard/partials/angular') ?>
<style>
    label {
        margin-bottom: initial;
    }
    form#download-form {
        display: inline;
    }
    .export_btn {
        background-color: white !important;
        width: 220px;
        height: 40px;
        border: 0px;
    }
    .export_btn:hover {
        background-color: #e1e3e9 !important;
        color: #333;
    }
</style>
<div class="row" ng-controller="adhoc_reportCtrl">
    <div class="container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#home">Tables</a></li>
            <li><a data-toggle="tab" href="#menu1">Fields</a></li>
            <li><a data-toggle="tab" href="#menu2">Summary</a></li>
        </ul>
        <div class="tab-content">
            <div id="home" class="tab-pane fade in active">
                <div class="row">
                    <div class="col-sm-12 col-md-11">
                        <div class="panel">
                            <div class="panel-body">
                                <div class="row checkBoxFields">
                                    <div class="cFieldBox">
                                        <?php foreach ($tables as $tb_key => $table) :
                                            if(in_array($tb_key, ['employee_increments'])){
                                                continue;
                                            }?>
                                            <div class="d-flex align-items-center">
                                                <input id="tb_<?= $tb_key ?>" name="tables[]" ng-model="isChecked['<?= $tb_key ?>']" ng-change="tables_changed('<?= $tb_key ?>')" type="checkbox" class="ckb" value="<?= $tb_key ?>">
                                                <label for="tb_<?= $tb_key ?>"><?= $table['label'] ?></label>
                                            </div>
                                        <?php endforeach ?>
                                        <?php if($this->permission->method('employee_salary_permission', 'read')->access()) : ?>
                                        <div class="d-flex align-items-center">
                                            <input id="tb_employee_increments" name="tables[]" ng-disabled="!isChecked['employee_history']" ng-model="isChecked['employee_increments']" ng-change="tables_changed('employee_increments')" type="checkbox" class="ckb" value="employee_increments">
                                            <label for="tb_employee_increments">Employee Increments</label>
                                        </div>
                                        <div class="d-flex align-items-center">
                                            <small ng-show="!isChecked['employee_history']">Select "Employees" table first</small>
                                        </div>
                                        <?php endif?>
                                    </div>
                                </div>
                                <div class="form-group text-right">
                                    <input type="button" class="btn theme_btn_1 btnNext" ng-click="checktable()" value="NEXT">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="menu1" class="tab-pane fade in">
                <div class="row">
                    <div class="col-sm-12 col-md-11">
                        <div class="panel">
                            <div class="panel-body">
                                <div id="fields" class="checkBoxFields"></div>
                                <div class="form-group text-right">
                                    <input type="button" class="btn theme_btn_2 btnPrevious" value="Previous">
                                    <input type="button" class="btn theme_btn_1 btnNext" ng-click="checkedfield()" value="NEXT">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="menu2" class="tab-pane fade in">
                <div class="row">
                    <div class="col-sm-12 col-md-11">
                        <div class="panel">
                            <div class="panel-body">
                                <form action="" id="criteria-form" method="post">
                                    <table class="table table-bordered table-hover" id="equipment_table">
                                        <thead>
                                            <tr>
                                                <th>Field</th>
                                                <th>Operator</th>
                                                <th>Value</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="equipmnet_info">
                                            <tr>
                                                <td>
                                                    <div>
                                                        <select name="criteria[1][field]" id="ssf1"
                                                            class="form-control selectbox">
                                                        </select>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div>
                                                        <select class="form-control selectbox" name="criteria[1][operator]"
                                                            id="operator1">
                                                            <option value="">Select Operator</option>
                                                            <option value="=">=</option>
                                                            <option value=">">></option>
                                                            <option value="<">
                                                                <</option> <option value="<=">
                                                                    <=</option> <option value=">=">>=
                                                            </option>
                                                            <option value="!=">!=</option>
                                                        </select>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div>
                                                        <input name="criteria[1][value]" class="form-control selectbox" type="text"
                                                            placeholder="Value" id="q1" value="">
                                                    </div>
                                                </td>
                                                <td> <input type="button" name="sdfsd" id="add_invoice_item"
                                                        class="btn btn-primary btn_rounded"
                                                        onclick="addasset('equipmnet_info');" value="+" />
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </form>
                                <div class="form-group text-right">
                                    <input type="button" class="btn theme_btn_2 btnPrevious" value="Previous">
                                    <button type="button" class="btn theme_btn_1 btnNext" ng-click="results()"><i
                                            class='fa fa-search' aria-hidden='true'></i>
                                        <?php echo display('search')?></button>
                                    <form id="download-form" method="POST" action="<?= base_url('reports/Adhoc/download') ?>" ng-submit="download_legacy()">
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Export <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><button name="type" class="export_btn" type="submit" value="excel">Excel (Better Formatting)</button></li>
                                                <li><button name="type" class="export_btn" type="submit" value="csv">CSV (Faster)</button></li>
                                            </ul>
                                        </div>
                                        
                                    </form>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered" id="results_table">
                                        <thead>
                                            <tr>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    hrmApp.controller('adhoc_reportCtrl', function($scope, $http, $compile) {
        $scope.tables = []
        $scope.columns = []
        $scope.results_array = null;
        $scope.tables_changed = function(val) {
            if($scope.isChecked[val]) {
                $scope.tables.push(val)
            } else {
                $scope.tables = $scope.tables.filter((val2) => {
                    return val2 != val;
                })
            }
        }
        $scope.columns_changed = function(val) {
            if($scope.isColChecked[val]) {
                $scope.columns.push(val)
            } else {
                $scope.columns = $scope.columns.filter((val2) => {
                    return val2 != val;
                })
            }
        }
        $scope.checktable = function() {
            if(!$scope.tables.length) {
                alert('Please select at least one table from checkboxes');
                return
            }
            $('.se-pre-con').show()
            $http({
                method: "POST",
                url: "<?= base_url('reports/Adhoc/findtablefield')?>",
                data: $scope.tables
            }).then(function (response) {
                $('.se-pre-con').hide()
                if(!response.data) {
                    alert('Invalid data received from tables, check your table selection');
                    return
                }
                if(response.data.success) {
                    $scope.reset_table()
                    $('.nav-tabs > .active').next('li').find('a').trigger('click');
                    angular.element(document.getElementById("fields")).html($compile(response.data.success)($scope));
                    return
                }
                if(response.data.error) {
                    alert(response.data.error);return
                }
            }, function (response) {
                $('.se-pre-con').hide()
                alert('Error: ' + response.statusText)
            });
        }
        $scope.checkedfield = function() {
            if(!$scope.columns.length) {
                alert('Please select at least one field from checkboxes');
                return
            }
            $('.se-pre-con').show()
            $http({
                method: "POST",
                url: "<?= base_url('reports/Adhoc/selectedfield')?>",
                data: $scope.columns
            }).then(function (response) {
                $('.se-pre-con').hide()
                if(!response.data) {
                    alert('Invalid data received from tables, check your columns selection');
                } else {
                    $scope.reset_table()
                    $('.nav-tabs > .active').next('li').find('a').trigger('click');
                    document.getElementById("ssf1").innerHTML = response.data;
                }
            }, function (response) {
                $('.se-pre-con').hide()
                alert('Error: ' + response.statusText)
            });
        }
        $scope.results = function(callback){
            $.ajax({
                type: "post",
                url: "<?php echo site_url('reports/Adhoc/resultss')?>",
                data: {
                    tables: $scope.tables,
                    columns: $scope.columns,
                    criteria: $('form#criteria-form').serialize()
                },
                beforeSend: function() {                        
                    $('.se-pre-con').show()
                }
            })
            .always(() => {$('.se-pre-con').hide(); $scope.reset_table})
            .done((data) => {
                if(data.success) {
                    $scope.results_array = data.success;
                    $table = $('table#results_table');
                    $table.find('thead>tr').html('');
                    data.success.columns.forEach(col => {
                        $table.find('thead>tr').append(`<th>${col}</th>`)
                    });
                    $table.find('tbody').html('')
                    data.success.rows.forEach(row => {
                        let row_str = '<tr>';
                        row.forEach(col => {
                            row_str += `<td>${col}</td>`;
                        });
                        row_str += '</tr>';
                        $table.find('tbody').append(row_str)
                    });
                    callback && callback()
                }
            });
        }
        $scope.generateCSV = function(){
            if(!$scope.results_array) {
                $scope.results($scope.generateCSV);return
            }
            var csvContent = '';
            csvContent = $scope.results_array.columns.map((val_col) => {return `"${val_col.replace(/"/g, '""')}"`}).join(',') + '\n';
            $scope.results_array.rows.forEach(function(infoArray, index) {
                dataString = infoArray.map((val_col) => {return `"${val_col.replace(/"/g, '""')}"`}).join(',');
                csvContent += index < $scope.results_array.rows.length ? dataString + '\n' : dataString;
            });
            $scope.download(csvContent, 'adhoc-report.csv', 'text/csv;encoding:utf-8');
        }
        $scope.download = function(content, fileName, mimeType) {
            var a = document.createElement('a');
            mimeType = mimeType || 'application/octet-stream';

            if (navigator.msSaveBlob) { // IE10
                navigator.msSaveBlob(new Blob([content], {
                type: mimeType
                }), fileName);
            } else if (URL && 'download' in a) { //html5 A[download]
                a.href = URL.createObjectURL(new Blob([content], {
                type: mimeType
                }));
                a.setAttribute('download', fileName);
                document.body.appendChild(a);
                a.click();
                document.body.removeChild(a);
            } else {
                location.href = 'data:application/octet-stream,' + encodeURIComponent(content); // only this mime type is supported
            }
        }
        $scope.download_legacy = function() {
            let data = {
                    tables: $scope.tables,
                    columns: $scope.columns,
                    criteria: $('form#criteria-form').serialize()
                };
            data = JSON.stringify(data);
            data = btoa(data)
            $('form#download-form').find('[name=data]').remove()
            $('form#download-form').append('<input type="hidden" name="data" value="' + data + '">')
            return false
        }
        $scope.reset_table = function() {
            $scope.results_array = null;
            $table = $('table#results_table');
            $table.find('thead>tr').html('')
            $table.find('tbody').html('')
        }
    })
    $('.btnPrevious').click(function () {
        $('.nav-tabs > .active').prev('li').find('a').trigger('click');
    });
    var count = $('#equipment_table tr').length;
    var limits = 500;

    function addasset(divName) {
        if (count == limits) {
            alert("<?php echo display('you_have_reached_the_limit_of_adding')?> " + count +
                "<?php echo display('inputs')?> ");
        } else {
            var newdiv = document.createElement('tr');
            var tabin = "ssf" + count;
            var dropdown = document.getElementById("ssf1").innerHTML;
            newdiv = document.createElement("tr");
            newdiv.innerHTML = ' <td><div><select name="criteria[' + count + '][field]" id="ssf' + count +
                '"  class="form-control selectbox"></select></div></td><td> <div><select class="form-control selectbox" name="criteria[' + count + '][operator]" id="operator' +
                count +
                '"><option value="">Select Operator</option><option value="=">=</option><option value=">">></option><option value="<"><</option><option value="<="><=</option><option value=">=">>=</option><option value="!=">!=</option></select></div></td><td> <div><input name="criteria[' + count + '][value]" class="form-control selectbox" type="text" placeholder="Value" id="q' +
                count +
                '" value=""></div></td><td> <button style="text-align: center;" class="btn removeRow btn_rounded text-white" type="button" value="<?php echo display("delete")?>" onclick="deleteRow(this)"><i class="fa fa-close"></i></button></td>';
            document.getElementById(divName).appendChild(newdiv);
            document.getElementById(tabin).focus();
            document.getElementById("ssf" + count).innerHTML = dropdown;
            $('select:not(.dont-select-me)').select2()
            count++;
        }
    }
    //##########
    function deleteRow(e) {
        var t = $("#equipment_table > tbody > tr").length;
        if (1 == t) alert("There only one row you can't delete.");
        else {
            var a = e.parentNode.parentNode;
            a.parentNode.removeChild(a)
        }
    }
</script>