<?php 
class Employees_model extends CI_Model
{
    public function get_allowed_employee_listing()
    {
        if($this->permission->method('leave_report', 'update')->access()) {
            return  $this->db->select('employee_id id, CONCAT_WS(\' \', first_name, last_name, hrm_id) as label')->order_by('first_name')->get('employee_history')->result_array();
        } elseif ($this->session->userdata('supervisor')) {
            $this->load->model('employee/employees_model');
            return array_map(function($emp){
                return [
                    'id' => $emp['employee_id'],
                    'label' => sprintf('%s %s %s', $emp['first_name'], $emp['last_name'], $emp['hrm_id'])
                ];
            }, $this->employees_model->get_subordinates());
        } else {
            return $this->db->select('employee_id id, CONCAT_WS(\' \', first_name, last_name, hrm_id) as label')->where('employee_id', $this->session->userdata('employee_id'))->get('employee_history')->result_array();
        }
    }
    public function dropdowns($params = ['columns', 'employees', 'departments', 'supervisors'])
    {
        $data = [];
        if(in_array('columns', $params)) {
            $data['columns'] = $this->get_columns();
        }
        if(in_array('employees', $params)) {
            $data['employees'] = $this->get_allowed_employee_listing();
        }
        if(in_array('departments', $params)) {
            $data['department_ids'] =  $this->db->select('dept_id id, department_name as label')->order_by('department_name')->get('department')->result_array();
        }
        if(in_array('supervisors', $params)) {
            $data['supervisors_ids'] =  $this->db->select('employee_id id, CONCAT_WS(\' \', first_name, last_name, hrm_id) as label')->where('is_super_visor', 1)->order_by('first_name')->get('employee_history')->result_array();
        }
        return $data;
    }
    public function get_columns()
    {
        $columns = [];

        $columns[] = ['id' => 'e.hrm_id', 'label' => 'HRM ID'];
        $columns[] = ['id' => 'e.status', 'label' => 'Status'];
        $columns[] = ['id' => 'e.prefix', 'label' => 'Prefix'];
        $columns[] = ['id' => 'e.first_name', 'label' => 'First Name'];
        $columns[] = ['id' => 'e.middle_name', 'label' => 'Middle Name'];
        $columns[] = ['id' => 'e.middle_name', 'label' => 'Middle Name'];
        $columns[] = ['id' => 'e.email', 'label' => 'Email'];
        $columns[] = ['id' => 'e.phone', 'label' => 'Phone'];
        $columns[] = ['id' => 'e.alter_phone', 'label' => 'Alternative Phone'];
        $columns[] = ['id' => 'e.present_address', 'label' => 'Present Address'];
        $columns[] = ['id' => 'e.parmanent_address', 'label' => 'Permanent Address'];
        $columns[] = ['id' => 'e.father_name', 'label' => 'Father Name'];
        $columns[] = ['id' => 'e.degree_name', 'label' => 'Degree Name'];
        $columns[] = ['id' => 'e.institute_name', 'label' => 'Institute Name'];
        $columns[] = ['id' => 'e.cgp', 'label' => 'Grades'];
        $columns[] = ['id' => 'e.passing_year', 'label' => 'Passing Year'];
        $columns[] = ['id' => 'e.state', 'label' => 'Country'];
        $columns[] = ['id' => 'e.city', 'label' => 'City'];
        $columns[] = ['id' => 'e.hire_date', 'label' => 'Date of Joining'];
        $columns[] = ['id' => 'e.original_hire_date', 'label' => 'Original Date of Joining'];
        $columns[] = ['id' => 'e.termination_date', 'label' => 'Date of Separation'];
        $columns[] = ['id' => 'e.termination_reason', 'label' => 'Separation Reason'];
        $columns[] = ['id' => 'e.exit_interview', 'label' => 'Exit Interview Conducted'];
        $columns[] = ['id' => 'e.exit_interview_date', 'label' => 'Exit Interview Date'];
        $columns[] = ['id' => 'e.exit_interview_details', 'label' => 'Exit Interview Details'];
        $columns[] = ['id' => 'e.voluntary_termination', 'label' => 'Voluntary Resignation'];
        $columns[] = ['id' => 'e.rehire_date', 'label' => 'Rehire Date'];
        $columns[] = ['id' => 'e.is_supervisor', 'label' => 'Is Supervisor'];
        $columns[] = ['id' => 'e.dob', 'label' => 'Date of Birth'];
        $columns[] = ['id' => 'e.home_email', 'label' => 'Personal Email'];
        $columns[] = ['id' => 'e.business_email', 'label' => 'Official/Business Email'];
        $columns[] = ['id' => 'e.home_phone', 'label' => 'Home Phone'];
        $columns[] = ['id' => 'e.business_phone', 'label' => 'Official/Business Phone'];
        $columns[] = ['id' => 'e.cell_phone', 'label' => 'Cell Phone'];
        $columns[] = ['id' => 'e.emerg_contct', 'label' => 'Emergency Contact'];
        $columns[] = ['id' => 'e.probation_period', 'label' => 'Probation Period'];
        $columns[] = ['id' => 'e.performance_duration', 'label' => 'Performance Period'];
        $columns[] = ['id' => 'e.cnic', 'label' => 'CNIC'];
        $columns[] = ['id' => 'e.work_from_home', 'label' => 'Work From Home'];
        $columns[] = ['id' => 'e.transportation_required', 'label' => 'Transportation Required'];
        $columns[] = ['id' => 'e.primary_project', 'label' => 'Primary Project'];
        $columns[] = ['id' => 'e.team', 'label' => 'Team'];
        $columns[] = ['id' => 'e.campaign', 'label' => 'Campaign'];
        $columns[] = ['id' => 'e.pseudo', 'label' => 'Pseudo'];
        $columns[] = ['id' => 'e.medflow_id', 'label' => 'Medflow ID'];
        $columns[] = ['id' => 'e.skype_id', 'label' => 'Skype ID'];
        $columns[] = ['id' => 'e.replacement', 'label' => 'Hired In Place Of'];
        $columns[] = ['id' => 'e.last_employer', 'label' => 'Last Employer'];
        $columns[] = ['id' => 'e.last_employer_address', 'label' => 'Last Employer Address'];
        $columns[] = ['id' => 'e.account_title', 'label' => 'Account Title'];
        $columns[] = ['id' => 'e.account_number', 'label' => 'Account Number'];
        $columns[] = ['id' => 'e.account_iban', 'label' => 'Account IBAN'];
        $columns[] = ['id' => 'e.branch_code', 'label' => 'Branch Code'];
        $columns[] = ['id' => 'e.branch_address', 'label' => 'Branch Address'];

        if($this->permission->method('employee_salary_permission', 'read')->access()) {
            $columns[] = ['id' => 'e.rate', 'label' => 'Basic Salary'];
            $columns[] = ['id' => 'e.current_salary', 'label' => 'Gross salary'];
            $columns[] = ['id' => 'e.hired_salary', 'label' => 'Hired Salary'];
            $columns[] = ['id' => 'e.first_salary', 'label' => 'First Increment'];
            $columns[] = ['id' => 'e.second_salary', 'label' => 'Second Increment'];
            $columns[] = ['id' => 'e.third_salary', 'label' => 'Third Increment'];
        }

        return $columns;
    }
}