<?php
require_once APPPATH . 'libraries/Mysql_type.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Attrition_model extends CI_Model
{
    public function minimum_hire_year()
    {
        return $this->db->select('year(min(hire_date)) as hire_year')->get('employee_history')->row()->hire_year ?? date('Y');
    }
    public function get_summary($year, $month)
    {
        $interval = $this->get_start_end($year, $month);
        $start = $interval['start'];
        $end = $interval['end'];
        $recs = $this->db->query(
            'CALL get_attrition_summary(?, ?);',
            [$start, $end]
        )->result();
        $this->db->next_result();
        $sum_rec = (object) [
            'dept_id' => null,
            'department_name' => 'Total',
            'active' => 0,
            'separated' => 0,
            'rate' => 0,
        ];
        foreach ($recs as $rec) {
            $sum_rec->active += $rec->active;
            $sum_rec->separated += $rec->separated;
        }
        $sum_rec->rate = round(($sum_rec->separated / $sum_rec->active) * 100, 2);
        $recs[] = $sum_rec;
        return $recs;
    }
    public function get_details($year, $month)
    {
        $interval = $this->get_start_end($year, $month);
        $start = $interval['start'];
        $end = date('Y-m-d', strtotime($interval['end'] . ' +1 day'));
        return $this->db->select('hrm_id, full_name, direct_manager_name, division, department, position, status, hire_date, termination_date')
            ->where([
                'termination_date >' => $start,
                'termination_date <=' => $end,
            ])
            ->where_not_in('status', ['not-joined'])
            ->order_by('termination_date', 'asc')
            ->get('employee_details')
            ->result();
    }
    public function get_start_end($year, $month)
    {
        $total_days_in_month = cal_days_in_month(CAL_GREGORIAN, $month, $year);
        $start = sprintf('%s-%s-01', $year, $month);
        $end = sprintf('%s-%s-%s', $year, $month, $total_days_in_month);
        return [
            'start' => $start,
            'end' => $end,
        ];
    }
    public function download($year, $month)
    {
        $interval = $this->get_start_end($year, $month);

        $writer = new Xlsx($this->_create_spreadsheet($year, $month));
        header('Content-Description: File Transfer');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="Attrition Report - ' . date('F, Y', strtotime($interval['start'])) . '.xlsx"');
        header('Content-Transfer-Encoding: binary');

        $writer->save('php://output');exit;
    }
    private function _create_spreadsheet($year, $month)
    {
        $spreadsheet = new Spreadsheet();
        $properties = $spreadsheet->getProperties();

        $properties->setCreator('HRM Reporting System');
        $properties->setLastModifiedBy('HRM Reporting System');
        $properties->setTitle('Attrition Report');
        $properties->setSubject('Attrition Report');

        $summary_sheet = $spreadsheet->getActiveSheet();
        $summary_sheet->getSheetView()->setZoomScale(90);
        $summary_sheet->setShowGridlines(false);
        $summary_sheet->setTitle('Summary');

        $details_sheet = new Worksheet();
        $details_sheet->getSheetView()->setZoomScale(85);
        $details_sheet->setShowGridlines(false);
        $details_sheet->setTitle('Details');
        $spreadsheet->addSheet($details_sheet, 2);

        //Set Header
        $last_column = null;
        $header = $this->_headers('summary');
        foreach ($header as $column => $value) {
            $column += 1;
            $cell = $summary_sheet->getCellByColumnAndRow($column, 1);
            $cell->setValueExplicit(
                is_string($value) ? display($value) : display($value[0]),
                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
            );
            $summary_sheet->getColumnDimension($cell->getColumn())->setWidth(is_string($value) ? 20 : $value[1]);
            $last_column = $cell->getColumn();
        }
        $summary_sheet->freezePane('A2');

        if ($last_column) {
            $summary_sheet->getStyle("A1:{$last_column}1")->applyFromArray([
                'fill' => [
                    'color' => [
                        'rgb' => 'C5BE97',
                    ],
                    'fillType' => Fill::FILL_SOLID,
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
                'font' => [
                    'bold' => 1,
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'wrapText' => 1,
                ],
            ]);
        }
        //Set Data
        $row = 1;
        $rows = $this->get_summary($year, $month);
        $meta = $this->_meta('summary');
        foreach ($rows as $columns) {
            $row++;
            $columns = array_values((array) $columns);
            array_shift($columns);
            foreach ($columns as $column => $value) {
                $cell = $summary_sheet->getCellByColumnAndRow($column + 1, $row);

                if (empty($meta)) {
                    $cell->setValue($value);
                } else {
                    $mysql_types = new Mysql_type();
                    $mysql_type = $meta[$column];
                    switch ($mysql_types->check_type($mysql_type)) {
                        case 'perc':{
                                $cell->setValueExplicit(
                                    floatval($value) / 100,
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                                );
                                $cell->getStyle()->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_PERCENTAGE_00);
                                break;
                            }
                        case $mysql_types::IS_INT:{
                                $cell->setValueExplicit(
                                    floatval($value),
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                                );
                                $cell->getStyle()->getNumberFormat()->setFormatCode('#,##0');
                                break;
                            }
                        case $mysql_types::IS_DATE:{
                                $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                                if (!$timestamp) {
                                    $cell->setValueExplicit(
                                        $value,
                                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                    );
                                } else {
                                    $cell->setValue($timestamp);
                                    $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_SHORT);
                                }
                                break;
                            }
                        case $mysql_types::IS_DATETIME:{
                                $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                                if (!$timestamp) {
                                    $cell->setValueExplicit(
                                        $value,
                                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                    );
                                } else {
                                    $cell->setValue($timestamp);
                                    $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DATETIME);
                                }
                                break;
                            }
                        default:
                            $cell->setValueExplicit(
                                $value,
                                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                            );
                            break;
                    }
                }
            }
        }
        if ($last_column) {
            $summary_sheet->getStyle("A1:{$last_column}{$row}")->applyFromArray([
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
            ]);
        }
        //Set Header
        $last_column = null;
        $header = $this->_headers('details');
        foreach ($header as $column => $value) {
            $column += 1;
            $cell = $details_sheet->getCellByColumnAndRow($column, 1);
            $cell->setValueExplicit(
                is_string($value) ? display($value) : display($value[0]),
                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
            );
            $details_sheet->getColumnDimension($cell->getColumn())->setWidth(is_string($value) ? 20 : $value[1]);
            $last_column = $cell->getColumn();
        }
        $details_sheet->freezePane('A2');

        if ($last_column) {
            $details_sheet->getStyle("A1:{$last_column}1")->applyFromArray([
                'fill' => [
                    'color' => [
                        'rgb' => 'C5BE97',
                    ],
                    'fillType' => Fill::FILL_SOLID,
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
                'font' => [
                    'bold' => 1,
                ],
                'alignment' => [
                    'horizontal' => Alignment::HORIZONTAL_CENTER,
                    'vertical' => Alignment::VERTICAL_CENTER,
                    'wrapText' => 1,
                ],
            ]);
        }
        //Set Data
        $row = 1;
        $rows = $this->get_details($year, $month);
        $meta = $this->_meta('details');
        foreach ($rows as $columns) {
            $row++;
            $columns = array_values((array) $columns);
            foreach ($columns as $column => $value) {
                if ($column == 6) {
                    $value = slug_to_readable($value);
                }
                $cell = $details_sheet->getCellByColumnAndRow($column + 1, $row);

                if (empty($meta)) {
                    $cell->setValue($value);
                } else {
                    $mysql_types = new Mysql_type();
                    $mysql_type = $meta[$column];
                    switch ($mysql_types->check_type($mysql_type)) {
                        case 'perc':{
                                $cell->setValueExplicit(
                                    floatval($value) / 100,
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                                );
                                $cell->getStyle()->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_PERCENTAGE_00);
                                break;
                            }
                        case $mysql_types::IS_INT:{
                                $cell->setValueExplicit(
                                    floatval($value),
                                    \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_NUMERIC
                                );
                                $cell->getStyle()->getNumberFormat()->setFormatCode('#,##0');
                                break;
                            }
                        case $mysql_types::IS_DATE:{
                                $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                                if (!$timestamp) {
                                    $cell->setValueExplicit(
                                        $value,
                                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                    );
                                } else {
                                    $cell->setValue($timestamp);
                                    $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_SHORT);
                                }
                                break;
                            }
                        case $mysql_types::IS_DATETIME:{
                                $timestamp = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($value);
                                if (!$timestamp) {
                                    $cell->setValueExplicit(
                                        $value,
                                        \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                                    );
                                } else {
                                    $cell->setValue($timestamp);
                                    $cell->getStyle()->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_DATETIME);
                                }
                                break;
                            }
                        default:
                            $cell->setValueExplicit(
                                $value,
                                \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING
                            );
                            break;
                    }
                }
            }
        }
        if ($last_column) {
            $details_sheet->getStyle("A1:{$last_column}{$row}")->applyFromArray([
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => [
                            'rgb' => '000000',
                        ],
                    ],
                ],
            ]);
        }
        $summary_sheet->getStyle('A1');

        return $spreadsheet;
    }
    private function _headers($type = null)
    {
        $headers = [
            'summary' => [
                ['department', 30],
                'active',
                'separated',
                'attrition_rate',
            ],
            'details' => [
                ['hrm_id', 10],
                ['employee_name', 25],
                ['manager_name', 25],
                'division',
                ['department', 30],
                ['designation', 30],
                'status',
                'hire_date',
                'termination_date',
            ],
        ];
        return $headers[$type];
    }
    private function _meta($type = null)
    {
        $mysql_types = new Mysql_type();
        $headers = [
            'summary' => [
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_INT24,
                $mysql_types::TYPE_INT24,
                'perc',
            ],
            'details' => [
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_STRING,
                $mysql_types::TYPE_DATE,
                $mysql_types::TYPE_DATE,
            ],
        ];
        return $headers[$type];
    }
}
