<?php
include_once APPPATH . 'libraries/Mysql_type.php';
class Adhoc_model extends CI_Model
{
    private $_tables = [
        'employee_increments' => [
            'columns' => [
                'amount' => [
                    'label' => 'Amount',
                ],
                'date' => [
                    'label' => 'Date',
                    'type' => 'date',
                ],
            ],
        ],
    ];
    private $tables = [
        'department' => [
            'label' => 'Departments',
            'columns' => [
                'department_name' => [
                    'label' => 'Department Name',
                ],
            ],
            'relation' => [
                'employee_history' => 'department.dept_id=employee_history.dept_id',
            ],
        ],
        'divisions' => [
            'label' => 'Divisions',
            'columns' => [
                'name' => [
                    'label' => 'Division Name',
                ],
                'prefix' => [
                    'label' => 'Division Prefix',
                ],
            ],
            'relation' => [
                'employee_history' => 'divisions.id=employee_history.division_id',
            ],
        ],
        'employee_history' => [
            'label' => 'Employees',
            'columns' => [
                'hrm_id' => [
                    'label' => 'HRM ID',
                ],
                'status' => [
                    'label' => 'Status',
                    'type' => 'slug',
                ],
                'prefix' => [
                    'label' => 'Prefix',
                ],
                'first_name' => [
                    'label' => 'First Name',
                ],
                'middle_name' => [
                    'label' => 'Middle Name',
                ],
                'last_name' => [
                    'label' => 'Last Name',
                ],
                'email' => [
                    'label' => 'Email',
                ],
                'phone' => [
                    'label' => 'Phone',
                ],
                'alter_phone' => [
                    'label' => 'Alternative Phone',
                ],
                'present_address' => [
                    'label' => 'Present Address',
                ],
                'parmanent_address' => [
                    'label' => 'Permanent Address',
                ],
                'father_name' => [
                    'label' => 'Father Name',
                ],
                'degree_name' => [
                    'label' => 'Last Qualification',
                ],
                'institute_name' => [
                    'label' => 'Institute of Qualification',
                ],
                'cgp' => [
                    'label' => 'Grade',
                ],
                'passing_year' => [
                    'label' => 'Passing Year',
                    'type' => 'date',
                ],
                'state' => [
                    'label' => 'Country',
                ],
                'city' => [
                    'label' => 'City',
                ],
                'hire_date' => [
                    'label' => 'Hire Date',
                    'type' => 'date',
                ],
                'original_hire_date' => [
                    'label' => 'Original Hire Date',
                    'type' => 'date',
                ],
                'termination_date' => [
                    'label' => 'Separation Date',
                    'type' => 'date',
                ],
                'termination_reason' => [
                    'label' => 'Separation Reason',
                ],
                'exit_interview' => [
                    'label' => 'Exit Interview Conducted',
                    'type' => 'bool',
                ],
                'exit_interview_date' => [
                    'label' => 'Exit Interview Date',
                    'type' => 'date',
                ],
                'exit_interview_details' => [
                    'label' => 'Exit Interview Details',
                ],
                'voluntary_termination' => [
                    'label' => 'Voluntary Resignation',
                    'type' => 'bool',
                ],
                'rehire_date' => [
                    'label' => 'Re-Hire Date',
                    'type' => 'date',
                ],
                'is_super_visor' => [
                    'label' => 'Is Supervisor',
                    'type' => 'bool',
                ],
                'emp_dsp.first_name' => [
                    'label' => 'Direct Supervisor First Name',
                ],
                'emp_dsp.last_name' => [
                    'label' => 'Direct Supervisor Last Name',
                ],
                'emp_dsp.hrm_id' => [
                    'label' => 'Direct Supervisor HRM ID',
                ],
                'emp_isp.first_name' => [
                    'label' => 'Indirect Supervisor First Name',
                ],
                'emp_isp.last_name' => [
                    'label' => 'Indirect Supervisor Last Name',
                ],
                'emp_isp.hrm_id' => [
                    'label' => 'Indirect Supervisor HRM ID',
                ],
                'dob' => [
                    'label' => 'Date of Birth',
                    'type' => 'date',
                ],
                'ethnic_group' => [
                    'label' => 'Religion',
                ],
                'home_email' => [
                    'label' => 'Personal Email',
                ],
                'business_email' => [
                    'label' => 'Office Email',
                ],
                'home_phone' => [
                    'label' => 'Home Phone',
                ],
                'business_phone' => [
                    'label' => 'Office Phone',
                ],
                'cell_phone' => [
                    'label' => 'Cell Phone',
                ],
                'emerg_contct' => [
                    'label' => 'Emergency Contact',
                ],
                'emergency_contact_name' => [
                    'label' => 'Emergency Contact Name',
                ],
                'emergency_contact_relation' => [
                    'label' => 'Emergency Contact Relation',
                ],
                'probation_period' => [
                    'label' => 'Probation Period',
                ],
                'cnic' => [
                    'label' => 'CNIC',
                    'type' => 'cnic',
                ],
                'cnic_expiry' => [
                    'label' => 'CNIC Expiry Date',
                    'type' => 'date',
                ],
                'rate' => [
                    'label' => 'Basic Salary',
                ],
                'current_salary' => [
                    'label' => 'Gross Salary',
                ],
                'hired_salary' => [
                    'label' => 'Hired Salary',
                ],
                'eobi' => [
                    'label' => 'EOBI Amount',
                ],
                'work_from_home' => [
                    'label' => 'Work From Home',
                    'type' => 'bool',
                ],
                'c_covid_dose1' => [
                    'label' => 'First COVID Vaccine Dose',
                    'type' => 'bool',
                ],
                'c_covid_dose2' => [
                    'label' => 'Second COVID Vaccine Dose',
                    'type' => 'bool',
                ],
                'transportation_required' => [
                    'label' => 'Transportation Required',
                    'type' => 'bool',
                ],
                'primary_project' => [
                    'label' => 'Primary Project',
                ],
                'team' => [
                    'label' => 'Team',
                ],
                'campaign' => [
                    'label' => 'Campaign',
                ],
                'pseudo' => [
                    'label' => 'Pseudo',
                ],
                'medflow_id' => [
                    'label' => 'Medflow ID',
                ],
                'skype_id' => [
                    'label' => 'Skype ID',
                ],
                'replacement' => [
                    'label' => 'Hired in Replacement of',
                ],
                'last_employer' => [
                    'label' => 'Last Employer',
                ],
                'last_employer_address' => [
                    'label' => 'Last Employer Address',
                ],
                'account_title' => [
                    'label' => 'Bank Account Title',
                ],
                'account_number' => [
                    'label' => 'Bank Account Number',
                ],
                'account_iban' => [
                    'label' => 'Bank Account IBAN',
                ],
                'branch_code' => [
                    'label' => 'Bank Branch Code',
                ],
                'branch_address' => [
                    'label' => 'Bank Branch Address',
                ],
                'contract_period' => [
                    'label' => 'Contract Period',
                ],
            ],
            'joins' => [
                'employee_history as emp_dsp' => 'emp_dsp.employee_id=employee_history.super_visor_id',
                'employee_history as emp_isp' => 'emp_isp.employee_id=employee_history.indirect_super_visor_id',
            ],
            'relation' => [
                'position' => 'position.pos_id=employee_history.pos_id',
                'department' => 'department.dept_id=employee_history.dept_id',
                'divisions' => 'divisions.id=employee_history.division_id',
                'duty_type' => 'duty_type.id=employee_history.duty_type',
                'gender' => 'gender.id=employee_history.gender',
                'marital_info' => 'marital_info.id=employee_history.marital_status',
                'shift' => 'shift.id=employee_history.shift',
            ],
        ],
        'position' => [
            'label' => 'Designations',
            'columns' => [
                'position_name' => [
                    'label' => 'Designation',
                ],
            ],
            'relation' => [
                'employee_history' => 'position.pos_id=employee_history.pos_id',
            ],
        ],
        'employee_increments' => [
            'label' => 'Employee Increments',
            'columns' => [],
            'relation' => [
                'employee_history' => 'employee_increments.employee_id=employee_history.employee_id',
            ],
        ],
        'shift' => [
            'label' => 'Shifts',
            'columns' => [
                'name' => [
                    'label' => 'Shift Name',
                ],
                'start' => [
                    'label' => 'Shift Start Time',
                ],
                'end' => [
                    'label' => 'Shift End Time',
                ],
                'flexible_shift' => [
                    'label' => 'Flexible Shift',
                    'type' => 'bool',
                ],
                'flexible_hours' => [
                    'label' => 'Flexible Hours',
                ],
            ],
            'relation' => [
                'employee_history' => 'shift.id=employee_history.shift',
            ],
        ],
        'duty_type' => [
            'label' => 'Duty Types',
            'columns' => [
                'type_name' => [
                    'label' => 'Duty Type',
                ],
            ],
            'relation' => [
                'employee_history' => 'duty_type.id=employee_history.duty_type',
            ],
        ],
        'gender' => [
            'label' => 'Gender',
            'columns' => [
                'gender_name' => [
                    'label' => 'Gender',
                ],
            ],
            'relation' => [
                'employee_history' => 'gender.id=employee_history.gender',
            ],
        ],
        'marital_info' => [
            'label' => 'Marital Status',
            'columns' => [
                'marital_sta' => [
                    'label' => 'Marital Status',
                ],
            ],
            'relation' => [
                'employee_history' => 'marital_info.id=employee_history.marital_status',
            ],
        ],
    ];
    public function __construct()
    {
        parent::__construct();
        $this->mysql = new Mysql_type();
    }
    public function tables()
    {
        uasort($this->tables, function ($a, $b) {
            return strcmp($a['label'], $b['label']);
        });
        return $this->tables;
    }
    public function table($table)
    {
        if (!isset($this->tables[$table])) {
            return [];
        }
        uasort($this->tables[$table]['columns'], function ($val1, $val2) {
            return strcmp($val1['label'], $val2['label']);
        });
        return $this->tables[$table];
    }
    public function column_label($table, $columns)
    {
        if (!isset($this->tables[$table])) {
            return null;
        }
        if (!isset($this->tables[$table]['columns'][$columns])) {
            return null;
        }
        return $this->tables[$table]['columns'][$columns]['label'];
    }
    public function table_has_relation($table_name, $tables)
    {
        if (isset($this->tables[$table_name]['relation'])) {
            $col_keys = array_keys($this->tables[$table_name]['relation']);
            foreach ($tables as $table) {
                if (in_array($table, $col_keys)) {
                    return true;
                }
            }
        }
        foreach ($tables as $table) {
            $table = $this->tables[$table];
            if (isset($table['relation']) && isset($table['relation'][$table_name])) {
                return true;
            }
        }
        return false;
    }
    public function generate($tables, $columns, $criterias, $format_date = true)
    {
        $columns = array_map(function ($val) {
            $val_exp = explode('.', $val);
            if (count($val_exp) == 2) {
                return $val_exp;
            } else {
                return [array_shift($val_exp), implode('.', $val_exp)];
            }
        }, $columns);

        $select_cols = array_map(function ($val) {
            return strpos($val[1], '.') === false ? $val[0] . '.' . $val[1] : $val[1];
        }, $columns);

        $dupes_holder = [];
        $extra_tables = [];
        foreach ($select_cols as $key => $select_col) {
            $col_stripped = substr($select_col, strpos($select_col, '.') + 1);
            if (in_array($col_stripped, $dupes_holder)) {
                $select_cols[$key] .= ' as ' . $col_stripped . rand(pow(10, 2 - 1), pow(10, 2) - 1);
            }
            $dupes_holder[] = $col_stripped;
        }

        if (in_array('employee_history', $tables)) {
            $select_cols[] = 'employee_history.employee_id';
        }
        if (in_array('employee_increments', $tables)) {
            $extra_tables[] = 'employee_increments';
            unset($tables['employee_increments']);
        }
        $this->db->select(implode(', ', $select_cols));

        $this->db->from($tables[0]);
        $joins = [];
        foreach ($tables as $key => $table) {
            $table_data = $this->tables[$table];
            if ($table_data['joins']) {
                foreach ($table_data['joins'] as $join_table => $join_criteria) {
                    $joins[] = [$join_table, $join_criteria, 'left'];
                }
            }
            if ($key == 0) {
                continue;
            }
            foreach ($tables as $tb2) {
                $tb_data = $this->tables[$tb2];
                if (isset($tb_data['relation']) && isset($tb_data['relation'][$table])) {
                    $joins[] = [$table, $tb_data['relation'][$table], 'left'];
                    break;
                }
            }
        }
        usort($joins, function ($v1, $v2) {
            if (substr($v1[0], 0, 1) == 'd' && substr($v2[0], 0, 1) == 'e') {
                return 1;
            }
            if (substr($v1[0], 0, 1) == 'e' && substr($v2[0], 0, 1) == 'd') {
                return -1;
            }
            return strcmp($v1[0], $v2[0]);
        });
        foreach ($joins as $join) {
            $this->db->join($join[0], $join[1], $join[2]);
        }
        if ($criterias) {
            foreach ($criterias as $criteria) {
                if (empty(trim($criteria['field'])) || empty(trim($criteria['value']))) {
                    continue;
                }
                $c_table = '';
                $c_field = '';
                $val_exp = explode('.', $criteria['field']);
                if (count($val_exp) == 2) {
                    $c_table = $val_exp[0];
                    $c_field = $val_exp[1];
                } else {
                    $c_table = array_shift($val_exp);
                    $c_field = implode('.', $val_exp);
                }
                $field_data = $this->tables[$c_table]['columns'][$c_field];
                switch ($field_data['type']) {
                    case 'cnic':{
                            $criteria['value'] = str_replace('-', '', $criteria['value']);
                            $this->db->where($criteria['field'] . ' ' . $criteria['operator'], $criteria['value']);
                            break;
                        }
                    case 'bool':{
                            $criteria['value'] = strtolower($criteria['value']) == 'yes' ? 1 : 0;
                            $this->db->where($criteria['field'] . ' ' . $criteria['operator'], $criteria['value']);
                            break;
                        }
                    case 'slug':{
                            $criteria['value'] = str_replace(' ', '-', $criteria['value']);
                            $this->db->where($criteria['field'] . ' ' . $criteria['operator'], $criteria['value']);
                            break;
                        }
                    case 'date':{
                            $criteria['value'] = convert_excel_date($criteria['value'], 'Y-m-d', '-');
                            $this->db->where($criteria['field'] . ' ' . $criteria['operator'], $criteria['value']);
                            break;
                        }
                    default:{
                            $this->db->where($criteria['field'] . ' ' . $criteria['operator'], $criteria['value']);
                            break;
                        }
                }
            }
        }
        $query = $this->db->get();

        $field_meta = $query->field_data();
        $field_meta = array_filter($field_meta, function ($v) {
            return $v->name != 'employee_id';
        });

        $field_meta = array_map(function($v) {
            if(in_array($v->name, ['c_covid_dose1', 'c_covid_dose2'])) {
                $v->type = 16;
            }
            return $v;
        }, $field_meta);

        $data = $query->result_array();

        $employee_ids = array_column($data, 'employee_id');

        $data = array_map(function ($v) {
            $v = decrypt_employee_data($v);
            if (isset($v['employee_id'])) {
                if (isset($v['current_salary'])) {
                    $gross = calculate_gross_salary($v['employee_id']);
                    $v['current_salary'] = $gross;
                }
                if (isset($v['rate'])) {
                    $gross = calculate_gross_salary($v['employee_id']);
                    $v['rate'] = round(percentage_to_amount($gross, 68));
                }
            }
            return $v;
        }, $data);
        $all_tbs = $this->tables;
        $col_data = array_map(function ($cl) use ($all_tbs) {
            return $all_tbs[$cl[0]]['columns'][$cl[1]];
        }, $columns);

        $extra_columns = [];
        $extra_headers = [];
        foreach ($extra_tables as $extra_table) {
            if ($employee_ids) {
                if ($extra_table == 'employee_increments') {
                    $extra_columns[$extra_table] = [];
                    $inc_recs = $this->db->select('employee_id, num, amount, date')->where_in('employee_id', $employee_ids)->get($extra_table)->result();
                    foreach ($inc_recs as $inc_rec) {
                        $inc_rec = decrypt_employee_data($inc_rec, [], false, $extra_table);
                        if (!isset($extra_columns[$extra_table][$inc_rec->employee_id])) {
                            $extra_columns[$extra_table][$inc_rec->employee_id] = [];
                        }
                        if (!isset($extra_headers[$inc_rec->num . ' amount'])) {
                            $extra_headers[$inc_rec->num . ' amount'] = $this->_tables[$extra_table]['columns']['amount'];
                            $extra_headers[$inc_rec->num . ' amount']['label'] = addOrdinalNumberSuffix($inc_rec->num + 1) . ' Increment Amount';
                        }
                        if (!isset($extra_headers[$inc_rec->num . ' date'])) {
                            $extra_headers[$inc_rec->num . ' date'] = $this->_tables[$extra_table]['columns']['date'];
                            $extra_headers[$inc_rec->num . ' date']['label'] = addOrdinalNumberSuffix($inc_rec->num + 1) . ' Increment Date';
                        }
                        $extra_columns[$extra_table][$inc_rec->employee_id][$inc_rec->num . ' amount'] = $inc_rec->amount;
                        $extra_columns[$extra_table][$inc_rec->employee_id][$inc_rec->num . ' date'] = $inc_rec->date;
                    }
                }
            }
        }
        foreach ($extra_headers as $key => $extra_header) {
            $field_meta[] = (object) [
                'name' => $key,
                'type' => stripos($key, 'date') !== false ? $this->mysql::TYPE_DATE : $this->mysql::TYPE_INT24,
            ];
        }
        foreach ($extra_tables as $extra_table) {
            foreach ($data as &$dt) {
                foreach ($extra_headers as $key => $extra_header) {
                    $dt[$key] = $extra_columns[$extra_table][$dt['employee_id']][$key] ?? '';
                }
            }
        }
        $col_data = array_merge($col_data, array_values($extra_headers));

        $processed_data = [];
        foreach ($data as $dt) {
            if (isset($dt['employee_id'])) {
                unset($dt['employee_id']);
            }
            $dt = array_values($dt);
            foreach ($col_data as $key => $col_dt) {
                $new_value = null;
                switch (@$col_dt['type']) {
                    case 'bool':{
                            $new_value = $dt[$key] > 0 ? 'Yes' : 'No';
                            break;
                        }
                    case 'slug':{
                            $new_value = slug_to_readable($dt[$key]);
                            break;
                        }
                    case 'cnic':{
                            $new_value = cnic_with_dashes($dt[$key]);
                            break;
                        }
                    case 'date':{
                            if ($format_date) {
                                $new_value = formatted_date($dt[$key]);
                                break;
                            }
                        }
                    default:{
                            $new_value = $dt[$key];
                            break;
                        }
                }
                if (is_null($new_value)) {
                    $new_value = '';
                }
                $dt[$key] = $new_value;
            }
            $processed_data[] = $dt;
        }
        return [
            'columns' => array_column($col_data, 'label'),
            'rows' => $processed_data,
            'meta' => $field_meta,
        ];
    }
    public function generate_csv($tables, $columns, $criterias)
    {
        $data = $this->generate($tables, $columns, $criterias);
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename=adhoc-report.csv');
        header('Content-Transfer-Encoding: binary');

        $f = fopen('php://output', 'w');
        fwrite($f, chr(0xEF) . chr(0xBB) . chr(0xBF));
        fputcsv($f, $data['columns']);
        foreach ($data['rows'] as $row) {
            $row = array_map('html_entity_decode', $row);
            fputcsv($f, $row);
        }
    }
    public function generate_excel($tables, $columns, $criterias)
    {
        $sheet_info = [
            'author' => 'Appedology HRM System',
            'modifier' => 'Appedology HRM System',
            'title' => 'Adhoc Report - ' . formatted_date_now(null, true),
            'subject' => 'Employee data Adhoc Report',
            'description' => 'Auto generated adhoc report of employee data from HRM',
            'sheet_title' => 'Adhoc Report',
        ];
        $data = $this->generate($tables, $columns, $criterias, false);

        $meta = [];
        $encrypted_cols = @$this->config->item('encrypted_columns_types')['employee_history'];
        if (!empty($data['meta']) && !empty($encrypted_cols)) {
            foreach ($data['meta'] as $key => $f_meta) {
                if (isset($encrypted_cols[$f_meta->name])) {
                    $meta[$key] = $encrypted_cols[$f_meta->name];
                } else {
                    $meta[$key] = $f_meta->type;
                }
            }
        }

        $this->load->library('better_excel');
        $this->better_excel->download($data['columns'], $data['rows'], $meta, $sheet_info);
    }
}
