<?php
class Leave extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['leaves_model' => 'leaves']);
    }
    public function report()
    {
        $this->permission->method('leave_report', 'read')->redirect();
        $data['title'] = display('leave_report') . ' - ' . preg_replace('#[^\d]#is', '', $this->input->get('year'));
        $data['module'] = 'reports';
        $data['page'] = "leave_reports/leaves";
        $data['dropdowns'] = $this->leaves->dropdowns();

        if ($this->input->get('year') ||
            $this->input->get('employee') ||
            $this->input->get('leave_type') ||
            $this->input->get('department_id') ||
            $this->input->get('supervisor_id')) {
            $data['rows'] = $this->leaves->leave_report(
                $this->input->get('year'),
                $this->input->get('employee'),
                $this->input->get('leave_type'),
                $this->input->get('department_id'),
                $this->input->get('supervisor_id'),
            );
        }
        echo Modules::run('template/layout', $data);
    }
}
