<?php
class Employee extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'employees_model' => 'employee',
            'attrition_model',
            'credentials_model',
        ]);
    }
    public function report()
    {
        $this->permission->method('employee_report', 'read')->redirect();
        $data['title'] = display('employee_report');
        $data['module'] = 'reports';
        $data['page'] = "employee_report/employee";
        $data['dropdowns'] = $this->employee->dropdowns();

        if ($this->input->get('column') ||
            $this->input->get('employee') ||
            $this->input->get('department_id') ||
            $this->input->get('supervisor_id')) {
            $data['rows'] = $this->leaves->leave_report(
                $this->input->get('column'),
                $this->input->get('employee'),
                $this->input->get('department_id'),
                $this->input->get('supervisor_id'),
            );
        }
        echo Modules::run('template/layout', $data);
    }
    public function attrition($year = null, $month = null)
    {
        $this->permission->method('attrition_report', 'read')->redirect();
        if ($_GET['year'] && $_GET['month']) {
            if ($_GET['action'] == 'download') {
                $this->attrition_model->download($_GET['year'], $_GET['month']);
            }
            redirect(sprintf('reports/employee/attrition/%s/%s', $_GET['year'], $_GET['month']));
        }
        if (!is_numeric($year) || !is_numeric($month)) {
            $year = null;
            $month = null;
        }
        if (!$year) {
            $year = date('Y');
        }
        if (!$month) {
            $month = date('m');
        }
        $data['title'] = display('attrition_report') . ' - ' . preg_replace('#[^\d]#is', '', $year);

        $data['year'] = $year;
        $data['month'] = $month;
        $data['years'] = range(date('Y'), $this->attrition_model->minimum_hire_year());
        $data['months'] = month_labels();

        $data['summary'] = $this->attrition_model->get_summary($year, $month);
        $data['details'] = $this->attrition_model->get_details($year, $month);

        $data['module'] = 'reports';
        $data['page'] = 'employee_report/attrition';
        echo Modules::run('template/layout', $data);
    }
    public function credentials()
    {
        $this->permission->method('credentials_report', 'read')->redirect();
        if ($this->input->post()) {
            $this->credentials_model->download($this->input->post('employees'));return;
        }
        $this->load->model('attendance/csv_model');
        $data['employees'] = $this->csv_model->Employeename();
        $data['title'] = display('credentials_report');
        $data['module'] = 'reports';
        $data['page'] = 'employee_report/credentials';
        echo Modules::run('template/layout', $data);
    }
}
