<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Adhoc extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('adhoc_model');
    }
    public function index()
    {
        $this->permission->method('reports', 'read')->redirect();
        $data['title'] = display('adhoc_report');
        $data['tables'] = $this->adhoc_model->tables();
        $data['module'] = "reports";
        $data['page'] = "adhoc_form";
        echo Modules::run('template/layout', $data);
    }
    public function findtablefield()
    {
        $this->permission->method('reports', 'read')->redirect();
        $tables = json_decode($this->input->raw_input_stream);
        $data = '';
        foreach ($tables as $table_slug) {
            $table = $this->adhoc_model->table($table_slug);
            if (count($tables) > 1 && !$this->adhoc_model->table_has_relation($table_slug, $tables)) {
                sendJson(['error' => 'Table "' . $table['label'] . '" has no relation with other selected tables. Please reselect or choose only single "' . $table['label'] . '" table.']);
            }
            $data .= '<h4>' . $table['label'] . '</h4><div class="cFieldBox">';
            $first_letter = '';
            foreach ($table['columns'] as $col_key => $column) {
                if ($table_slug == 'employee_history' && in_array($col_key, ['rate', 'current_salary', 'hired_salary', 'first_salary', 'second_salary', 'third_salary']) && !$this->permission->method('employee_salary_permission', 'read')->access()) {
                    continue;
                }
                if (count($table['columns']) > 5 && $first_letter != ($_first_letter = substr($column['label'], 0, 1))) {
                    $data .= "<div class='d-flex align-items-center'><h4>{$_first_letter}</h4></div>";
                    $first_letter = $_first_letter;
                }
                $data .= "<div class='d-flex align-items-center'><input name='fields[]' id=\"col_" . $table_slug . '.' . $col_key . "\" type='checkbox' class='ckb' value='" . $table_slug . '.' . $col_key . "' ng-model=\"isColChecked['" . $table_slug . '.' . $col_key . "']\" ng-change=\"columns_changed('" . $table_slug . '.' . $col_key . "')\"><label for=\"col_" . $table_slug . '.' . $col_key . "\">" . $column['label'] . "</label></div>";
            }
            $data .= "</div><hr class='border'>";
        }
        sendJson(['success' => $data]);
    }
    public function selectedfield()
    {
        $this->permission->method('reports', 'read')->redirect();
        $field = json_decode($this->input->raw_input_stream);
        $html = '<option value="">Select One</option>';
        foreach ($field as $value) {
            $field_split = explode('.', $value);
            $label = $this->adhoc_model->column_label(array_shift($field_split), implode('.', $field_split));
            $html .= '<option value="' . $value . '">' . $label . '</option>';
        }
        echo $html;
    }
    public function resultss()
    {
        $this->permission->method('reports', 'read')->redirect();
        $criteria = [];
        parse_str($_POST['criteria'], $criteria);
        $criteria = $criteria['criteria'];
        $data = $this->adhoc_model->generate(
            $_POST['tables'],
            $_POST['columns'],
            $criteria
        );
        unset($data['meta']);
        if ($data) {
            sendJson(['success' => $data]);
        }
        echo '';
    }
    public function download()
    {
        $this->permission->method('reports', 'read')->redirect();
        if (!$this->input->post()) {
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $post = json_decode(base64_decode($_POST['data']), true);
        $criteria = [];
        parse_str($post['criteria'], $criteria);
        $criteria = $criteria['criteria'];
        if ($this->input->post('type') == 'csv') {
            $this->adhoc_model->generate_csv(
                $post['tables'],
                $post['columns'],
                $criteria
            );
        } else {
            $this->adhoc_model->generate_excel(
                $post['tables'],
                $post['columns'],
                $criteria
            );
        }
    }
}
