<style>
    .sub-block {
        border: black solid 1px;
        display: none;
    }
</style>
<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <strong>Status:</strong> <?php $alert_class = '';
    switch ($jobs_reads->requisition_status) {
    case 'pending_rm':{
            $alert_class = 'alert-primary';
            echo '<span class="label label-primary">Awaiting Recruitment Manager\'s Response</span>';
            break;
        }
    case 'rejected_rm':{
            $alert_class = 'alert-danger';
            echo '<span class="label label-danger">Rejected By Recruitment Manager</span>';
            break;
        }
    case 'changes_required':{
            $alert_class = 'alert-warning';
            echo '<span class="label label-warning">Changes Required</span>';
            break;
        }
    case 'pending_hr':{
            $hr_name = null;
            if($jobs_reads->hr_assigned){
                $hr_name = $this->db->select('CONCAT_WS(\' \', firstname, lastname) as name')->where('id', $jobs_reads->hr_assigned)->get('user')->row();
                if($hr_name){
                    $hr_name = $hr_name->name;
                }else{
                    $hr_name = null;
                }
            }
            if($hr_name){
                echo sprintf('<span class="label label-primary">Awaiting HR (%s) Review</span>', $hr_name);
            }else{
                echo '<span class="label label-primary">Awaiting HR Review</span>';
            }
            break;
        }
    case 'created':{
            echo '<span class="label label-success">Job Created</spans>';
            break;
        }
}?>
    </div>
</div>
<?php if ($jobs_remarks && !in_array($jobs_reads->requisition_status, ['pending_hr', 'created'])): ?>
<br>
<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <div class="alert <?=$alert_class?>">
            <strong>Remarks:</strong>
            <?=end($jobs_remarks)->remarks?>
        </div>
    </div>
</div>
<?php endif?>
<div id="actions" class="form-group text-right">
    <?php 
    if($jobs_reads->requisition_status == 'changes_required' && $this->session->userdata('id') == $jobs_reads->created_by):?>
            <button type="button" class="btn btn-success btn-action" value="pending_rm"><i class="fa fa-paper-plane" aria-hidden="true"></i> Re-submit</button>
            <a class="btn btn-primary" href="<?= base_url('recruitment/Requisition/update/' . $jobs_reads->jp_id) ?>" role="button"><i class="fa fa-pencil" aria-hidden="true"></i> Update Requisition</a>
    <?php elseif (
    !$this->session->userdata('isAdmin')
    && $this->permission->module('review_requisition_list')->access()
    && $jobs_reads->requisition_status == 'pending_rm'
): ?>
        <button type="button" class="btn btn-success btn-action" value="pending_hr"><i class="fa fa-thumbs-up" aria-hidden="true"></i> Approve</button>
        <button type="button" class="btn btn-warning btn-action" value="changes_required"><i class="fa fa-info-circle" aria-hidden="true"></i> Request Amendments</button>
        <button type="button" class="btn btn-danger btn-action" value="rejected_rm"><i class="fa fa-thumbs-down"></i> Reject</button>
    <?php elseif ($this->permission->module('create_ad_from_requisition')->access() && $jobs_reads->requisition_status == 'pending_hr'): ?>
        <button type="button" class="btn btn-success btn-action" value="created"><i class="fa fa-newspaper-o"></i> Publish</button>
    <?php elseif($this->permission->module('create_ad_from_requisition')->access() && $jobs_reads->requisition_status == 'created') :?>
        <button type="button" class="btn btn-success btn-download" value="created"><i class="fa fa-newspaper-o"></i> Download Ads</button>
    <?php endif?>
    <div class="row sub-block">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
            <form action="<?=base_url('recruitment/Requisition/process/' . $jobs_reads->jp_id)?>" method="post">
                <div class="form-group text-left">
                    <label for="txtRemrks">Enter Remarks / Reason:</label>
                    <textarea class="form-control editor" name="remarks" id="txtRemrks" rows="5"></textarea>
                </div>
                <button type="submit" name="type" class="btn btn-primary">Submit</button>
            </form>
        </div>
    </div>
</div>
<div class="container-fluid">
    <div class="row">
        <!--  table area -->
        <div class="col-sm-12">
            <div class="panel panel-default thumbnail">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <h2><?=$jobs_reads->position;?></h2>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <?=implode(', ', $jobs_reads->cities)?>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <h3>Job Description</h3>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12" style="margin-left: 15px;">
                            <p><?=$jobs_reads->jp_title_description;?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <h3>Job Skill</h3>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <?php foreach ($jobs_reads->skills as $location) {?>
                                <span
                                    style='margin-bottom: 10px;background: #<?= $location['jps_must_or_nice'] == 'must' ? 'ff6c6c' : 'eeeeee' ?>;padding: 6px 12px;border-radius: 0px;color: #000;font-weight: 400;'><?=$location['jps_name'];?></span>
                                <?php }?>
                            </p>
                        </div>
                    </div>
                    <?php if($jobs_reads->job_wfh): ?>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <h3>Work From Home</h3>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <?php foreach ($jobs_reads->job_wfh as $location) {?>
                                <span
                                    style='margin-bottom: 10px;background: #<?= $location['jpw_must_or_nice'] == 'must' ? 'ff6c6c' : 'eeeeee' ?>;padding: 6px 12px;border-radius: 0px;color: #000;font-weight: 400;'><?=$location['jpw_name'];?></span>
                                <?php }?>
                            </p>
                        </div>
                    </div>
                    <?php endif?>
                    <div class="row">
                        <div class="col-md-12">
                            <p>
                                <h3>Job Details</h3>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Total Positions:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_career_position;?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Job Type:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_employment_type;?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Shift:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_shift?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Gender:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_preference;?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Minimum Education:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_qualification_level;?>&nbsp;<?=$jobs_reads->jp_qualification_must != 'exactly' ?$jobs_reads->jp_qualification_must:null?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Career Level:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_career_level;?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Experience:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_experience_min;?> -
                                    <?=$jobs_reads->jp_experience_max;?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Salary:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=$jobs_reads->jp_salary_min;?> -
                                    <?=$jobs_reads->jp_salary_max;?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Benefit:</b>
                                </div>
                                <div class="col-md-9">
                                    <?=str_replace(',', ', ', $jobs_reads->jp_benefits)?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Posting Date:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=formatted_date($jobs_reads->jp_posted_on)?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <b>Due Date:</b>
                                </div>
                                <div class="col-md-3">
                                    <?=formatted_date($jobs_reads->jp_due_date)?>
                                </div>
                                <div class="col-md-3">
                                </div>
                                <div class="col-md-3">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo base_url(); ?>assets/js/ckeditor/ckeditor.js"></script>
<script>
    $(function () {
        $('.editor').each(function (e) {
            CKEDITOR.replace(this.id);
            CKEDITOR.config.height = 250;
        });
        $('#actions').on('click', 'button.btn-action', function(){
            var $sub_block = $('.sub-block');
            $sub_block.slideUp();
            if(this.value){
                $sub_block.find('button').val(this.value);
                if(!['pending_rm', 'changes_required', 'rejected_rm'].includes(this.value)){
                    $sub_block.find('button').trigger('click');return
                }
                $sub_block.slideDown();
            }
        })
        $('.btn-download').on('click', function (e) {
            e.preventDefault()
            $('body').append('<iframe id="printframe-apd" src="<?= base_url() ?>recruitment/requisition/print/apd/<?= $jobs_reads->jp_id ?>" frameborder="0" style="visibility:hidden;width: 950px;height: 950px;"></iframe>')
            $('body').append('<iframe src="<?= base_url() ?>recruitment/requisition/pdf/<?= $jobs_reads->jp_id ?>" frameborder="0" style="display:none"></iframe>')
        });
    });
</script>