<style>
    .table .dropdown-menu {
        left: -110px
    }
</style>
<div class="container-fluid">
    <div class="row">
        <!--  table area -->
        <div class="col-sm-12">
            <div class="panel panel-default thumbnail">
                <?php if($this->permission->method('process_applications', 'update')->access()): ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Filter</h3>
                </div>
                <?php endif;?>
                <div class="panel-body">
                    <?php if($this->permission->method('process_applications', 'update')->access()): ?>
                    <div class="row">
                        <form method="get">
                            <div class="row">
                                <div class="col-sm-6">
                                    <label class="col-sm-3 control-label">Status:</label>
                                    <div class="col-sm-9">
                                        <select name="status" class="form-control" style="width:100%">
                                            <option value="">Select Status</option>
                                            <?php foreach ($dropdowns['status'] as $status):
                                            if(in_array($status->status, ['rejected', 'completed'])){
                                                continue;
                                            }?>
                                            <option value="<?= $status->status ?>"
                                                <?= $status->status == $_GET['status'] ? 'selected' : null ?>>
                                                <?= display($status->status) ?></option>
                                            <?php endforeach?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <label class="col-sm-3 control-label">Job Ad:</label>
                                    <div class="col-sm-9">
                                        <select name="jp_id" class="form-control" style="width:100%">
                                            <option value="">Select Job Ad</option>
                                            <?php foreach ($dropdowns['positions'] as $position):?>
                                            <option value="<?= $position->jp_id ?>"
                                                <?= $position->jp_id == $_GET['jp_id'] ? 'selected' : null ?>>
                                                <?= sprintf('%s (%s)', $position->position_name, formatted_date($position->posted_on)) ?>
                                            </option>
                                            <?php endforeach?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <br>
                            <div class="text-right">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary">Filter</button>
                                    <a class="btn btn-default"
                                        href="<?= parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) ?>"
                                        role="button">Reset</a>
                                </div>
                            </div>
                        </form>
                    </div>
                    <?php endif ?>
                    <hr>
                    <br>
                    <table width="100%" class="table table-striped table-bordered table-hover table-main-applications">
                        <thead>
                            <tr>
                                <th><?= display('job_title') ?></th>
                                <th><?= display('name') ?></th>
                                <th><?= display('applied_on') ?></th>
                                <th><?= display('status') ?></th>
                                <th><?= display('interview_time') ?></th>
                                <th><?= display('updated_at') ?></th>
                                <th class="hideexport"><?= display('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($caninfo as $que) : ?>
                            <tr>
                                <td><?= $que->position_name; ?></td>
                                <td><?= $que->first_name.' '.$que->last_name; ?></td>
                                <td><?= formatted_date($que->applied_on) ?></td>
                                <?php if(in_array($que->status, ['interview_pending', 'interview_done', 'interview_canceled'])):
                                    $count = getByWhere('candidate_shortlist', 'count(*) as numrows', ['can_id' => $que->can_id])[0];
                                    ?>
                                <td><?= display($que->status) ?> #<?= $count->numrows ?></td>
                                <?php else:?>
                                <td><?= display($que->status) ?></td>
                                <?php endif?>
                                <td><?= $que->status == 'interview_pending' ? formatted_date($que->interview_date, true) : null ?></td>
                                <td><?= formatted_date($que->updated_at, true) ?></td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-default dropdown-toggle"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Action <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <?php if($this->permission->method('process_applications', 'update')->access()): ?>
                                                <?php if($que->status == 'shortlisted'): ?>
                                                <li><a href="#" class="btn-interview-add"
                                                        data-id="<?=$que->can_id?>">Schedule Interview</a></li>
                                                <?php elseif($que->status == 'interview_pending'):?>
                                                <li><a href="#" class="btn-interview-done" data-can-short-id="<?=$que->can_short_id?>">Mark
                                                        Interview Done</a></li>
                                                <li><a href="#" class="btn-interview-add" data-resch="yes" data-id="<?=$que->can_id?>">Reschedule Interview</a></li>
                                                <li><a href="#" class="btn-interview-cancel" data-id="<?=$que->can_id?>">Cancel Interview</a></li>
                                                <?php elseif($que->status == 'interview_canceled'): ?>
                                                    <li><a href="#" class="btn-interview-add" data-resch="yes" data-id="<?=$que->can_id?>">Reschedule Interview</a></li>                                            
                                                    <?php if($count->numrows > 0): ?>
                                                        <li><a href="#" class="btn-hire" data-id="<?=$que->can_id?>">Hire Candidate</a></li>
                                                        <li><a href="#" class="btn-reject" data-id="<?=$que->can_id?>">Reject Candidate</a></li>
                                                    <?php endif ?>
                                                <?php elseif($que->status == 'interview_done'): ?>
                                                    <li><a href="#" class="btn-interview-add" data-id="<?=$que->can_id?>">Schedule Additional Interview</a></li>
                                                    <li role="separator" class="divider"></li>
                                                    <li><a href="#" class="btn-hire" data-id="<?=$que->can_id?>">Hire Candidate</a></li>
                                                    <li><a href="#" class="btn-reject" data-id="<?=$que->can_id?>">Reject Candidate</a></li>
                                                <?php elseif($this->permission->module('review_requisition_list')->access() && $que->status == 'rm_pending'): ?>
                                                    <li><a href="#" class="btn-approve-rm" data-id="<?=$que->can_id?>">Approve</a></li>
                                                    <li><a href="#" class="btn-reject-rm" data-id="<?=$que->can_id?>">Reject</a></li>
                                                <?php elseif($que->status == 'rm_rejected'): ?>
                                                    <li><a href="#" class="btn-hire" data-id="<?=$que->can_id?>">Review Joining Details</a></li>
                                                <?php endif;?>
                                            <?php elseif ($this->permission->module('review_requisition_list')->access() && $que->status == 'rm_pending'): ?>
                                                <li><a href="#" class="btn-approve-rm" data-id="<?=$que->can_id?>">Approve</a></li>
                                                <li><a href="#" class="btn-reject-rm" data-id="<?=$que->can_id?>">Reject</a></li>
                                            <?php endif?>
                                            <?php
                                            $inter_recs = getByWhere('candidate_interview', 'count(*) numrows', ['can_id' => $que->can_id])[0];
                                            if($inter_recs->numrows): ?>
                                                <li role="separator" class="divider"></li>
                                                <li><a href="#" class="btn-interview-history" data-id="<?=$que->can_id?>">Interview History</a></li>
                                            <?php endif?>
                                            <li role="separator" class="divider"></li>
                                            <li><a href="#" class="btn-view-profile" data-id="<?=$que->can_id?>">View
                                                    Profile</a></li>
                                            <li><a href="<?=base_url('recruitment/candidate/documents/' . $que->can_id . '/resume')?>" download>Download Resume</a></li>
                                            <li><a href="<?=base_url('recruitment/job_posting/details/').$que->jp_id?>#shortlisted">View
                                                    Job</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        $('table.table-main-applications').dataTable($.extend({}, window.default_datatable_opts, {
            "columnDefs": [ {
                "targets": [5],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                    }
                    return data;
                }
            
            },
            {
                "targets": [4],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                    }
                    return data;
                }
            
            },
            {
                "targets": [2],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            
            } ],
            "order": [[ 5, "desc" ]]
        }))
    });
    function getInterviewSlot(date, c) {
        var $btn = $('.interview_flatpickr').closest('.modal').find('[type=submit]')
        $btn.attr('disabled', 'disabled')
        $.ajax({
            type: "POST",
            url: "<?=base_url()?>recruitment/candidate_select/get_interview_slot",
            data: {
                date: date
            },
            success: function (res) {
                $btn.removeAttr('disabled')
                $('#interview_date_help').text('')
                res.success ? c(res.success) : c()
            }
        });
    }

    function checkInterviewSlot(date, c) {
        var $btn = $('.interview_flatpickr').closest('.modal').find('[type=submit]')
        $btn.attr('disabled', 'disabled')
        $.ajax({
            type: "POST",
            url: "<?=base_url()?>recruitment/candidate_select/check_interview_slot",
            data: {
                date: date
            },
            success: function (res) {
                res.vacant && $btn.removeAttr('disabled')
                res.vacant ? c(res.vacant) : c()
            }
        });
    }
    $(function () {
        window.interview_flatpickr = $(".interview_flatpickr").flatpickr({
            dateFormat: 'd-m-Y H:i',
            enableTime: true,
            time_24hr: true,
            minuteIncrement: 1,
            /* onClose: function (date, datestr, instance) {
                checkInterviewSlot(datestr, function (vacant) {
                    if (!vacant) {
                        alert(
                            `This interview slot '${datestr}' is not available, try another date`);
                        $('#interview_date_help').css('color', 'red').text(
                            'Interview slot is filled')
                    } else {
                        $('#interview_date_help').css('color', 'green').text(
                            'Interview slot is vacant')
                    }
                })
            } */
        });
        window.doj_flatpickr = $(".doj_flatpickr").flatpickr({
            dateFormat: 'd-m-Y',
        });
        $('table.table-main-applications').on('click', '.btn-view-profile', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/get_profile",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-profile').find('.modal-body').html(res.success)
                        $('#model-profile').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-interview-history', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/interview_history",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-interview-history').find('.modal-body').html(res.success)
                        $('#model-interview-history').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-interview-cancel', function (e) {
            e.preventDefault();
            if(!confirm('Are you sure you want to cancel this interview?')){
                return
            }
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/cancel_interview",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        location.reload()
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-interview-add', function (e) {
            e.preventDefault()
            $('.se-pre-con').show()
            var reschedule = $(this).data('resch')
            $modal = $('#modal-schedule-interview');
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>recruitment/candidate_select/candidate_details",
                data: {
                    can_id: $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $modal.find('[name=reschedule]').val(reschedule)
                        $modal.find('[name=can_id]').val(res.success.can_id)
                        $modal.find('td.job').text(res.success.position_name)
                        $modal.find('td.name').text(
                            `${res.success.first_name} ${res.success.last_name}`)
                        $modal.find('td.email').text(res.success.email)
                        $modal.find('td.phone').text(res.success.phone)
                        $modal.find('td.altphone').text(res.success.alter_phone)
                    } else {
                        alert(
                            'Error while retreiving candidate details. Check your internet')
                    }
                }
            });
            getInterviewSlot(null, function (date) {
                window.interview_flatpickr.setDate(moment(date, 'DD-MM-YYYY hh:mm:ss A')
                .unix() * 1000);
                $('.se-pre-con').hide()
                $('#interview_date_help').text('')
                $modal.modal('show')
            })
        })
        $('table.table-main-applications').on('click', '.btn-interview-done', function (e) {
            e.preventDefault()
            $modal = $('#model-interview-done');
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/interview_form",
                data: {
                    can_short_id: $(this).data('can-short-id'),
                },
                success: function (res) {
                    if(res.success){
                        $modal.find('.modal-body').html(res.success)
                        $modal.modal('show')
                    }else{
                        alert('Error while loading interview data try again later')
                    }
                }
            });
        })
        $('.btn-next-free').on('click', function(){
            $input = $(this).closest('.form-group').find('input');
            getInterviewSlot(moment(flatpickr.parseDate($input.val(), "d-m-Y H:i")).format('YYYY-MM-DD HH:mm:ss'), function (res) {
                if(res){
                    window.interview_flatpickr.setDate(moment(res, 'DD-MM-YYYY hh:mm:ss A')
                    .unix() * 1000);
                }
            })
        })
        $('table.table-main-applications').on('click', '.btn-reject', function(e){
            e.preventDefault();
            if(!confirm('Are you sure that you want to reject this candidate?')){
                return;
            }
            var $modal = $('#modal-reject');
            $modal.find('[name=can_id]').val($(this).data('id'))
            $modal.modal('show')
        })
        $('table.table-main-applications').on('click', '.btn-hire', function (e) {
            e.preventDefault()
            $('.se-pre-con').show()
            $modal = $('#modal-hire');
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>recruitment/candidate_select/candidate_details",
                data: {
                    can_id: $(this).data('id')
                },
                complete: function () {
                    $('.se-pre-con').hide()  
                },
                success: function (res) {
                    if (res.success) {
                        $modal.find('td.id').text(res.success.can_id)
                        $modal.find('[name=can_id]').val(res.success.can_id)
                        $modal.find('td.job').text(res.success.position_name)
                        $modal.find('td.name').text(
                            `${res.success.first_name} ${res.success.last_name}`)
                        $modal.find('td.email').text(res.success.email)
                        $modal.find('td.phone').text(res.success.phone)
                        $modal.find('td.altphone').text(res.success.alter_phone)
                    } else {
                        alert(
                            'Error while retreiving candidate details. Check your internet')
                    }
                }
            });
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>recruitment/candidate_select/get_selection_info",
                data: {
                    can_id: $(this).data('id')
                },
                success: function (res) {
                    if(res.success){
                        window.doj_flatpickr.setDate(res.success.joining_date, false, 'Y-m-d')
                        $modal.find('[name=salary]').val(res.success.salary)
                    }
                }
            });
            $modal.modal('show')
        })
        $('table.table-main-applications').on('click', '.btn-reject-rm', function(e){
            e.preventDefault()
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>recruitment/candidate_select/rm_status/reject",
                data: {
                    can_id: $(this).data('id')
                },
                success: function (res) {
                    location.reload();
                }
            });
        })
        $('table.table-main-applications').on('click', '.btn-approve-rm', function(e){
            e.preventDefault()
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>recruitment/candidate_select/rm_status/approve",
                data: {
                    can_id: $(this).data('id')
                },
                success: function (res) {
                    location.reload();
                }
            });
        })
        $('table.table-main-applications').on('click', '.btn.dropdown-toggle', function(){
            var first_li = $(this).siblings('ul').children('li').first();
            if(first_li.hasClass('divider')){
                first_li.remove()
            }
        })
    });
</script>
<div class="modal fade" id="model-profile" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Candidate Information</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="model-interview-history" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Interview History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-schedule-interview" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <form action="<?= base_url() ?>recruitment/candidate_select/schedule_interview" method="post">
            <input type="hidden" name="can_id" class="form-control" value="">
            <input type="hidden" name="reschedule" class="form-control" value="">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Schedule Interview</h4>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Job</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Alternative Phone</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="job"></td>
                                <td class="name"></td>
                                <td class="email"></td>
                                <td class="phone"></td>
                                <td class="altphone"></td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="form-group">
                        <label for="input" class="col-sm-3 control-label">Interview Time:</label>
                        <div class="col-sm-9">
                            <input type="text" name="interview_date" class="form-control interview_flatpickr"
                                required="required">
                            <small id="interview_date_help" class="form-text"></small>
                        </div>
                    </div>
                    <div>&nbsp;</div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Interviewer:</label>
                        <div class="col-sm-9">
                            <select name="user_id" class="form-control" required="required" style="width: 100%;">
                                <option value="">Select One</option>
                                <?php foreach ($dropdowns['users'] as $user) :
                                if(empty($user->hrm_id)){
                                    continue;
                                }?>
                                <option value="<?= $user->id ?>"><?= $user->name ?> (<?= $user->hrm_id ?>)</option>
                                <?php endforeach?>
                            </select>
                        </div>
                    </div>
                    <div>&nbsp;</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="modal-hire" data-backdrop="static" data-keyboard="false" >
    <div class="modal-dialog modal-lg">
        <form action="<?= base_url() ?>recruitment/candidate_select/hire_candidate" method="post">
            <input type="hidden" name="can_id" class="form-control" value="">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Confirm Joining</h4>
                </div>
                <div class="modal-body">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Job</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Alternative Phone</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="id"></td>
                                <td class="job"></td>
                                <td class="name"></td>
                                <td class="email"></td>
                                <td class="phone"></td>
                                <td class="altphone"></td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="form-group">
                        <label for="input" class="col-sm-3 control-label">Date Of Joining:</label>
                        <div class="col-sm-9">
                            <input type="text" name="date_of_joining" class="form-control doj_flatpickr"
                                required="required">
                        </div>
                    </div>
                    <div>&nbsp;</div>
                    <div class="form-group">
                        <label class="col-sm-3 control-label">Salary Package:</label>
                        <div class="col-sm-9">
                            <input type="text" name="salary" class="form-control" value="" required="required">
                        </div>
                    </div>
                    <div>&nbsp;</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </form>
    </div>
</div>
<div id="model-interview-done" class="modal fade right" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong> INTERVIEW FORM</strong></center>
            </div>
            <div class="modal-body">
            </div>
        </div>
        <div class="modal-footer">
        </div>
    </div>
</div>
<div class="modal fade" id="modal-reject" data-backdrop="static" data-keyboard="false" >
    <div class="modal-dialog">
        <form action="<?=base_url()?>recruitment/job_posting/reject_candidate" method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Reject Candidate</h4>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="can_id" value="">
                    <div class="form-group">
                      <label>Remarks</label>
                      <textarea class="form-control" name="remarks" rows="3" required></textarea>
                    </div>
                    <div class="form-group">
                      <label>Tag for future position of (optional)</label>
                      <select class="form-control" name="pos_id" style="width: 100%;">
                        <option value="">None</option>
                        <?php foreach ($positions as $position): ?>
                            <option value="<?=$position->pos_id?>"><?=$position->position_name?></option>
                        <?php endforeach?>
                      </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </form>
    </div>
</div>