<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>Appedology :: Talent Network</title>
    <!-- Favicon and touch icons -->

    <link rel="shortcut icon" href="<?php echo base_url((!empty($setting->favicon) ? $setting->favicon : 'assets/img/new-ui/mini-logo.png')) ?>" type="image/x-icon">

    <!-- Start Global Mandatory Style -->
    <!-- Bootstrap -->
    <link href="<?php echo base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet" type="text/css" />
    <!-- Bootstrap rtl -->
    <!-- <link href="<?php echo base_url('assets/css/bootstrap-rtl.min.css') ?>" rel="stylesheet" type="text/css"/> -->
    <!-- Pe-icon -->
    <link href="<?php echo base_url('assets/css/pe-icon-7-stroke.css') ?>" rel="stylesheet" type="text/css" />
    <!-- Theme style -->
    <link href="<?php echo base_url('assets/css/custom.min.css') ?>" rel="stylesheet" type="text/css" />
    <!-- Theme style rtl -->
    <!-- <link href="<?php echo base_url('assets/css/custom-rtl.min.css') ?>" rel="stylesheet" type="text/css"/> -->
    <style>
        .career_grid .panel-heading {
            border: 0px;
        }

        .career_grid .view-header {
            display: flex;
            align-items: center;
        }

        .career_grid .view-header .logo img {
            max-width: 100px;
        }

        .career_grid .view-header h1 {
            margin-left: 20px;
            color: #fff;
            font-weight: 600;
            font-size: 26px;
            margin-bottom: 8px;
        }

        .career_grid .career-bg {
            padding: 20px 10px;
            box-shadow: 0px 10px 13px -5px #dcdcdc;
        }

        .d-flex {
            display: flex;
        }

        .align-items-center {
            align-items: center;
        }

        .career-bg {
            background-size: cover;
        }

        .career_grid .panel-body h3 {
            font-weight: 600;
            color: #425985;
        }

        .career_grid .sub_title {
            margin-left: 20px;
            color: #fff;
            font-weight: 500;
            font-size: 16px;
        }

        .grid_filter {
            min-width: 150px;
            border: 1px solid #425985;
            border-radius: 100px;
            max-width: 150px;
            text-align: left;
            padding: 6px 10px;
            font-size: 12px;
        }

        .grid_filter select {
            background-color: transparent;
            border: 0px;
            width: 100%;
        }

        .b-scroll-no {
            overflow: auto;
            max-height: 64vh;
        }

        .b-scroll ul {
            padding-left: 15px;
        }

        .career_grid .b-scroll b {
            font-weight: 600;
        }

        .career_grid form label {
            font-weight: 500 !important;
        }

        .details_col_list .row {
            padding-bottom: 3px;
            padding-top: 3px;
            font-size: 13px;
        }

        .career_grid .form-group.row {
            margin-bottom: 7px;
        }

        .form-check {
            float: left;
            margin-right: 20px;
            margin-bottom: 8px;
        }

        @media only screen and (min-width:1201px) {
            .career_grid form .tab-pane {
                width: 85%;
                margin-left: auto;
                margin-right: auto;
                margin-top: 20px;
            }
        }

        .panel_height {
            height: 650px;
        }

        .pt-10 {
            padding-top: 10px;
        }

        .pt-30 {
            padding-top: 30px;
        }
        .mb-0 {
            margin-bottom: 0;
        }
    </style>
</head>

<body>
    <div class="container career_grid" style="margin-top : 50px">
        <div class="panel panel-bd careers_panel panel_height">
            <div class="panel-heading  career-bg row">
                <div class="view-header d-flex align-items-center col-sm-12">
                    <div class="logo"><a href="#">
                            <span class="logo-lg">
                                <img src="<?= base_url() ?>assets/img/new-ui/new-logo.png" alt="logo">
                            </span>
                        </a></div>
                    <div>
                        <h1>Join Our Talent Network</h1>
                    </div>
                </div>
            </div>
            <div class="b-scroll-no">
                <div class="panel-heading" style="margin-top:5px;">
                    <div class="">
                        <!-- alert message -->
                        <?php if ($this->session->flashdata('message') != null) {  ?>
                            <div class="alert alert-info alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo $this->session->flashdata('message'); ?>
                            </div>
                        <?php } ?>
                        <?php if ($this->session->flashdata('exception') != null) {  ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo $this->session->flashdata('exception'); ?>
                            </div>
                        <?php } ?>
                        <?php if (validation_errors()) {  ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo validation_errors(); ?>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="panel-body">
                    <div class="b-scroll-no-">
                        <form method="post" enctype="multipart/form-data" data-toggle="validator">
                            <div class="tab-content">
                                <div class="tab-pane active">

                                    <input type="hidden" name="<?= $this->security->get_csrf_token_name() ?>" value="<?= $this->security->get_csrf_hash() ?>" />

                                    <div class="form-group row">
                                        <label for="first_name" class="col-sm-3 col-form-label"><?php echo display('first_name') ?>*</label>
                                        <div class="col-sm-9">
                                            <input name="first_name" class="form-control" type="text" placeholder="<?php echo display('first_name') ?>" id="first_name" value="<?php echo set_value('first_name') ?>" pattern="^[A-z0-9\s]{3,}$" required data-error="Please enter a valid first name">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="last_name" class="col-sm-3 col-form-label"><?php echo display('last_name') ?> *
                                        </label>
                                        <div class="col-sm-9">
                                            <input name="last_name" class="form-control" type="text" placeholder="<?php echo display('last_name') ?>" id="last_name" value="<?php echo set_value('last_name') ?>" pattern="^[A-z0-9\s]{3,}$" required data-error="Please enter a valid last name">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="email" class="col-sm-3 col-form-label"><?php echo display('email') ?>
                                            *</label>
                                        <div class="col-sm-9">
                                            <input name="email" class="form-control" type="email" placeholder="<?php echo display('email') ?>" id="email" value="<?php echo set_value('email') ?>" required data-error="Please enter a valid email">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="phone" class="col-sm-3 col-form-label"><?php echo display('phone') ?>
                                            *</label>
                                        <div class="col-sm-9">
                                            <input name="phone" class="form-control num-only" type="text" placeholder="<?php echo display('phone') ?>" id="phone" value="<?php echo set_value('phone') ?>" required pattern="^[0-9]{3,}$" data-error="Please enter a valid phone number">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label for="address" class="col-sm-3 col-form-label">
                                            <?php echo display('Description') ?>
                                        </label>
                                        <div class="col-sm-9">
                                            <textarea name="address" class="form-control" placeholder="<?php echo display('Description') ?>" id="Description"><?php echo set_value('Description') ?></textarea>
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <div class="form-group">
                                            <!-- Are you able to work from home? -->
                                            <label for="inputwfhq" class="col-sm-3 control-label">Job Categories *</label>
                                            <div class="col-sm-9">
                                                <select id="inputwfhq" name="inputwfhq" class="form-control" required="required">
                                                    <option value="">Select One Option</option>
                                                    <option value="Communication Specialist">Communication Specialist</option>
                                                    <option value="Client Relationship Executive">Client Relationship Executive</option>
                                                    <option value="Social Media Executive">Social Media Executive</option>
                                                    <option value="Retention Specialist">Retention Specialist</option>
                                                    <option value="Training Executive">Training Executive</option>
                                                    <option value="Business Development Executive">Business Development Executive</option>
                                                    <option value="Customer Support Specialist">Customer Support Specialist</option>
                                                    <option value="Web Developer">Web Developer</option>
                                                    <option value="Mobile App Developer">Mobile App Developer</option>
                                                    <option value="UI/UX Engineer">UI/UX Engineer</option>
                                                    <option value="SEO/ Content Writer">SEO/ Content Writer</option>
                                                    <option value="Other">Other</option>
                                                </select>
                                                <div class="help-block with-errors"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="picture" class="col-sm-3 col-form-label">
                                            <?php echo display('resume_uploads') ?>*</label>
                                        <div class="col-sm-9">
                                            <input type="file" name="resume_uploads" required class="form-control" placeholder="<?php echo display('resume_uploads') ?>" id="picture" value="<?php echo set_value('resume_uploads') ?>">
                                            <div class="help-block with-errors"></div>
                                        </div>
                                    </div>
                                    <div class="form-group text-right pt-10 mb-0">
                                        <!--<a class="btn btn-primary btnPrevious">Previous</a>-->
                                        <a href="<?php echo base_url('careers') ?>">Back</a> &nbsp; &nbsp;
                                        <button type="submit" class="btn btn-success theme_btn_1"><?php echo display('submit') ?></button>

                                        <!-- <div class="col-sm-3"> </div> <div class="col-sm-9"> </div> -->

                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- jQuery -->
    <script src="<?php echo base_url('assets/js/jquery-1.12.4.min.js') ?>" type="text/javascript"></script>
    <!-- Bootstrap -->
    <script src="<?php echo base_url('assets/js/bootstrap.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo base_url('assets/plugins/validator/validator.min.js') ?>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            var info = $('table tbody tr');
            info.click(function() {
                var email = $(this).children().first().text();
                var password = $(this).children().first().next().text();
                $("input[name=email]").val(email);
                $("input[name=password]").val(password);
            });
            $('#inputwfhq').on('change', function(e) {
                $('#wfhchecks').hide()
                if (this.value == 'yes') {
                    $('#wfhchecks').show()
                }
            });

            function num_only(e) {
                this.value = this.value.replace(/\D+/g, '')
            }
            $('input.num-only').on('keyup', num_only)
            $('input.num-only').on('change', num_only)
        });
    </script>
</body>

</html>