<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="appedology" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="<?=base_url()?>assets/ads/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?=base_url()?>assets/ads/css/style.css?v=1.0.1">
    <title>appedology</title>
    <script>parent.show_loader()</script>
</head>

<body>
    <header class="d-flex justify-content-end">
        <a href="https://appedology.com/" title="appedology"><img src="<?=base_url()?>assets/ads/images/appedologylogo.png"
                alt="appedologylogo" class="pr-3">
        </a>
    </header>
    <section class="d-flex justify-content-end ">
        <h1 class="hiring-txt text-center">WE ARE </h1>
        <h1><span class="bg-hiring hir-txt">HIRING</span></h1>
    </section>
    <section class="d-flex justify-content-start">
        <p class="bg-red mr-1"></p>
        <h2 class="assis-txt"><?=$job->position?></h2>
    </section>
    <section class="">
        <h3 class="req-txt pr-2">KEY REQUIREMENTS: </h3>
        <div class="container-fluid requirements pt-3">
            <?=$job->jp_title_description?>
        </div>
    </section>
    <section class="">
        <div class="row">
            <div class="container-fluid col-sm-12 col-md-6 col-lg-6 col-xl-6">
                <h3 class="pl-2">BENEFITS:</h3>
                <?php $job->jp_benefits = explode(',', $job->jp_benefits)?>
                <ul class="benefits-item">
                    <?php foreach ($job->jp_benefits as $benefit): ?>
                    <li class="benefits"><?=$benefit?></li>
                    <?php endforeach?>
                </ul>
                <div class="location pl-3">
                    <h3 class="shifts "><img src="<?=base_url()?>assets/ads/images/location.png" alt="appedology location" class="loc-img">
                        <b><?= implode(', ', $job->cities) ?></b><span>&nbsp;|&nbsp;</span>Shift<span>&nbsp;:&nbsp;</span><?= $job->jp_shift ?></h3>
                </div>
                <p class="last-date pt-3 pl-3">Last date to apply: <b><?= formatted_date($job->jp_due_date) ?></b> </p>
            </div>
            <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 d-flex justify-content-end ">
                <img src="<?=base_url()?>assets/ads/images/app-medical-bill.png" alt="right medical image" class="med-img mt-5">
            </div>
        </div>
        <!-- <div>
            <h3 class="apply mt-1 pr-4" style="text-align: right;">APPLY NOW AT <img src="<?=base_url()?>assets/ads/images/apply.png"
                    alt="appedology apply now" class="apply-img"></h3>
            <p class="contact pl-4"><b>jobs@appedology.com </b></p>
            <p class="contact pl-4 pb-5"> mention "<?=$job->position?>" in the subject line.</p>
        </div> -->
        <div>
            <h3 class="apply mt-1 pr-4" style="text-align: right;">APPLY NOW AT <img src="<?=base_url()?>assets/ads/images/apply.png"
                    alt="appedology apply now" class="apply-img"></h3>
            <p class="contact pl-4"><b><?= base_url('job/' . $job->jp_short_url) ?> </b></p>
            <p class="contact pl-4 pb-5"></p>
        </div>
    </section>
    <script src="<?php echo base_url('assets/js/jquery-1.12.4.min.js') ?>" type="text/javascript"></script>
    <script src="<?=base_url()?>assets/ads/js/html2canvas.min.js"></script>
    <script>
        $(function () {
            html2canvas(document.body).then(function (canvas) {
                document.body.appendChild(canvas);
                const image = canvas.toDataURL("image/png")
                $.ajax({
                    type: "POST",
                    data: {
                        file: image
                    },
                    success: function (res) {
                        parent.hide_loader()
                        if(res.success){
                            location.href = location.href + '?url=' + res.success
                            setTimeout(() => {
                                parent.closeIFrame('apd')
                            }, 1000);
                        }else{
                            alert('Error rendering ad template')
                        }
                    }
                });
            }).catch((e)=>{
                console.log(e);
                alert('Error while generating ad, try again');
            })
        });
    </script>
</body>

</html>