<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Selection_model extends CI_Model
{
    public function viewShortlist()
    {
        return $this->db->select('count(DISTINCT(stl.can_short_id)) as can_short_id,stl.*,bi.can_id,bi.first_name,bi.last_name,po.position_name')
            ->from('candidate_shortlist stl')
            ->join('candidate_basic_info bi', 'stl.can_id = bi.can_id', 'left')
            ->join('position po', 'stl.job_adv_id = po.pos_id', 'left')
            ->group_by('stl.can_short_id')
            ->order_by('stl.can_short_id', 'desc')
            ->get()
            ->result();
    }
    public function underprocess_list($id = null, $status = null)
    {
        $this->db->select('candidate_basic_info.*,position.*, candidate_shortlist.interview_date, MAX(candidate_shortlist.can_short_id) as can_short_id')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id')
            ->join('position', 'job_posting.pos_id = position.pos_id')
            ->join('candidate_shortlist', 'candidate_basic_info.can_id = candidate_shortlist.can_id', 'left')
            ->order_by('candidate_basic_info.can_id', 'desc')
            ->group_by('candidate_basic_info.can_id')
            ->where('status !=', null)
            ->where('status !=', 'rejected')
            ->where('status !=', 'completed');
        if ($id) {
            $this->db->where('candidate_basic_info.jp_id', $id);
        }
        if ($status) {
            $this->db->where('candidate_basic_info.status', $status);
        }
        if($this->session->userdata('isAdmin') || $this->permission->full('recruitment')->access()) {
        } elseif($this->permission->module('review_requisition_list')->access() && $this->permission->method('process_applications', 'update')->access()) {
        } elseif($this->permission->module('review_requisition_list')->access()) {
            $this->db->where('candidate_basic_info.status', 'rm_pending');
        }
        return $this->db->get()
            ->result();
    }
    public function pending_interviews()
    {
        $where = [
            'candidate_basic_info.status' => 'interview_pending',
            'candidate_shortlist.interview_done' => 0,
            'candidate_shortlist.interview_date !=' => null,
        ];
        if(!$this->session->userdata('isAdmin') && !$this->permission->full('recruitment')->access()){
            $where['candidate_shortlist.interviewer_id'] = $this->session->userdata('id');
        }
        return getByWhere(
            'candidate_shortlist,
			candidate_basic_info-candidate_basic_info.can_id=candidate_shortlist.can_id-left,
			job_posting-job_posting.jp_id=candidate_basic_info.jp_id-left,
			position-position.pos_id=job_posting.pos_id-left,
			user-candidate_shortlist.interviewer_id=user.id-left',
            'candidate_shortlist.*,
			CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as can_name,
            candidate_basic_info.email,
            candidate_basic_info.phone,
            candidate_basic_info.status,
            candidate_basic_info.resume,
			position.position_name as position,
			CONCAT_WS(\' \', user.firstname, user.lastname) as interviewer',
            $where
        );
    }
    public function interview_form_data($can_short_id)
    {
        $rec = getByWhere(
            'candidate_shortlist,
			candidate_basic_info-candidate_basic_info.can_id=candidate_shortlist.can_id-left,
			job_posting-job_posting.jp_id=candidate_basic_info.jp_id-left,
			position-position.pos_id=job_posting.pos_id-left,
			user-candidate_shortlist.interviewer_id=user.id-left',
            'candidate_shortlist.*,
			CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as can_name,
			position.position_name as position,
			CONCAT_WS(\' \', user.firstname, user.lastname) as interviewer',
            [
                'candidate_shortlist.can_short_id' => $can_short_id,
                'candidate_shortlist.interview_done' => 0,
            ]
        )[0];
        if($rec){
            $rec->skills = getByWhere(
                'job_posting_skills',
                '*',
                ['jp_id' => $rec->job_adv_id]
            );
        }
        return $rec;
    }
    public function rm_reject($can_id)
    {
        $this->db->trans_start();
        $can_rec = $this->db->where('can_id', $can_id)->get('candidate_basic_info')->row();
        $this->db->where('can_id', $can_id)->update('candidate_basic_info', [
            'status' => 'rm_rejected',
            'updated_at' => current_date(true),
        ]);
        $this->activity
            ->set_job($can_rec->jp_id)
            ->set_candidate($can_id)
            ->log('candidate_onboarding_rejected');
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function rejected_list()
    {
        return $this->db->select('candidate_basic_info.*,position.*')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id')
            ->join('position', 'job_posting.pos_id = position.pos_id')
            ->order_by('candidate_basic_info.can_id', 'desc')
            ->where('status', 'rejected')
            ->get()
            ->result();
    }
    public function shortlist_create($data = array())
    {
        return $this->db->insert('candidate_shortlist', $data);
    }
    public function update_shortlist($data = array())
    {
        return $this->db->where('can_short_id', $data["can_short_id"])
            ->update("candidate_shortlist", $data);
    }
    public function shortlist_updateForm($id)
    {
        $this->db->where('can_short_id', $id);
        $query = $this->db->get('candidate_shortlist');
        return $query->row();
    }
    public function delete_shorlist($id = null)
    {
        return;
        $this->db->where('can_short_id', $id)
            ->delete('candidate_shortlist');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function dropdownPosition()
    {
        $this->db->select('*');
        $this->db->from('candidate_shortlist');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->job_adv_id] = $value->job_adv_id;
            }
        }
        return $list;
    }
    public function dropdown()
    {
        $this->db->select('*');
        $this->db->from('position');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->pos_id] = $value->position_name;
            }
        }
        return $list;
    }
    public function dropdowncanid()
    {
        $this->db->select('*');
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->first_name . "(" . $value->can_id . ")";
            }
        }
        return $list;
    }
    public function employee_onboarding($can_id)
    {
        $this->db->trans_start();
        $can_rec = getByWhere('candidate_basic_info', '*', ['can_id' => $can_id]);
        if (!$can_rec) {
            return false;
        }
        $can_rec = $can_rec[0];
        $selection_rec = getByWhere('candidate_selection', '*', ['can_id' => $can_id]);
        if (!$selection_rec) {
            return false;
        }
        $division = getByWhere('job_posting, divisions-divisions.id=job_posting.division_id-left', 'divisions.*, job_posting.pos_id as position_id', ['job_posting.jp_id' => $can_rec->jp_id]);
        if (!$division) {
            return false;
        }
        $job_details = getByWhere('job_posting, user-job_posting.created_by=user.id-left, employee_history-employee_history.email=user.email-left', 'job_posting.*, employee_history.*', ['job_posting.jp_id' => $can_rec->jp_id])[0];
        $division = $division[0];
        $selection_rec = $selection_rec[0];
        $hrm_id_num = generate_hrm_id($division->id);
        $hrm_email = strtolower($division->prefix . $hrm_id_num . '@' . $division->email_domain);
        $postData = [
            'status' => 'not-joined',
            'pos_id' => $division->position_id,
            'hrm_id' => $division->prefix . '-' . $hrm_id_num,
            'first_name' => $can_rec->first_name,
            'maiden_name' => '',
            'middle_name' => '',
            'last_name' => $can_rec->last_name,
            'father_name' => '',
            'email' => $hrm_email,
            'phone' => $can_rec->phone,
            'alter_phone' => $can_rec->alter_phone,
            'present_address' => $can_rec->address,
            'parmanent_address' => $can_rec->address,
            'work_from_home' => 0,
            'transportation_required' => 0,
            'picture' => '',
            'dept_id' => $job_details->dept_id,
            'division_id' => $division->id,
            'state' => '',
            'city' => '',
            'zip' => '',
            'citizenship' => '',
            'duty_type' => 5,
            'hire_date' => date("Y-m-d", strtotime($selection_rec->joining_date)),
            'original_hire_date' => date("Y-m-d", strtotime($selection_rec->joining_date)),
            'termination_date' => !empty($this->input->post('terminatedate')) ? date("Y-m-d", strtotime($this->input->post('terminatedate'))) : '0000-00-00',
            'termination_reason' => '',
            'voluntary_termination' => '',
            'rehire_date' => !empty($this->input->post('rehiredate')) ? date("Y-m-d", strtotime($this->input->post('rehiredate'))) : '0000-00-00',
            'rate_type' => '',
            'rate' => percentage_to_amount($selection_rec->salary, 68),
            'current_salary' => $selection_rec->salary,
            'pay_frequency' => $this->input->post('pay_frequency', true),
            'pay_frequency_txt' => $this->input->post('pay_f_text', true),
            'hourly_rate2' => $this->input->post('h_rate2', true),
            'hourly_rate3' => $this->input->post('h_rate3', true),
            'home_department' => $this->input->post('h_department', true),
            'department_text' => $this->input->post('h_dep_text', true),
            'class_code' => $this->input->post('c_code', true),
            'class_code_desc' => $this->input->post('c_code_d', true),
            'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
            'class_status' => $this->input->post('class_sst', true),
            'is_super_visor' => 0,
            'super_visor_id' => 0,
            'indirect_super_visor_id' => 0,
            'supervisor_report' => $this->input->post('reports', true),
            'dob' => date("Y-m-d", strtotime(!empty($this->input->post('dob', true)) ? $this->input->post('dob', true) : null)),
            'gender' => $this->input->post('gender', true),
            'marital_status' => $this->input->post('marital_status', true),
            'ethnic_group' => $this->input->post('ethnic', true),
            'eeo_class_gp' => $this->input->post('eeo_class', true),
            'cnic' => $this->input->post('cnic', true),
            'work_in_state' => $this->input->post('w_s', true),
            'live_in_state' => $this->input->post('l_in_s', true),
            'home_email' => $can_rec->email,
            'business_email' => $this->input->post('b_email', true),
            'home_phone' => $this->input->post('h_phone', true),
            'business_phone' => $this->input->post('w_phone', true),
            'cell_phone' => $this->input->post('c_phone', true),
            'emerg_contct' => $this->input->post('em_contact', true),
            'emrg_h_phone' => $this->input->post('e_h_phone', true),
            'emrg_w_phone' => $this->input->post('e_w_phone', true),
            'emgr_contct_relation' => $this->input->post('e_c_relation', true),
            'alt_em_contct' => $this->input->post('alt_em_cont', true),
            'alt_emg_h_phone' => $this->input->post('a_e_h_phone', true),
            'alt_emg_w_phone' => $this->input->post('a_e_w_phone', true),
            'shift' => $this->input->post('shift', true),
            'probation_period' => 3,
            'performance_duration' => $this->input->post('performance_duration', true),
            'hired_salary' => $selection_rec->salary,
            'first_salary' => $this->input->post('first_salary', true),
            'second_salary' => $this->input->post('second_salary', true),
            'third_salary' => $this->input->post('third_salary', true),
            'joining_notified' => 0,
            'referrer' => $can_rec->referrer
        ];
        $this->db->insert('employee_history', encrypt_employee_data($postData));
        $employee_id = $this->db->insert_id();
        $this->db->where('employee_id', $employee_id)->delete('emp_salary_setup_details');
        $this->db->insert('emp_salary_setup_details', [
            'addition_id' => 1,
            'employee_id' => $employee_id,
            'value' => percentage_to_amount($selection_rec->salary, 32),
            'created_on' => date('Y-m-d')
        ]);
        $this->db->insert('emp_salary_setup_details', [
            'deduction_id' => 1,
            'employee_id' => $employee_id,
            'value' => percentage_to_amount($postData['rate'], 9.3),
            'created_on' => date('Y-m-d')
        ]);
        increment_hrm_id($division->id, $hrm_id_num);
        $this->db->where('can_id', $can_id)->update('candidate_basic_info', [
            'status' => 'completed',
            'updated_at' => current_date(true),
            'employee_id' => $employee_id,
            'orientation' => 'pending'
        ]);
        if($this->total_hired_candidate_by_job($can_rec->jp_id) >= $job_details->jp_career_position){
            $this->db->where('jp_id', $can_rec->jp_id)->update('job_posting', [
                'requisition_status' => 'fulfilled',
            ]);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            $this->template_mail->send($can_rec->jp_id, 'offerletter', null, [], [], $can_id, null, [
                'candidate' => [
                    'joining_date' => formatted_date($selection_rec->joining_date),
                    'salary' => $selection_rec->salary,
                ],
            ]);
        }
        return $this->db->trans_status();
    }
    public function make_required_documents($employee_id)
    {
        $required_docs = $this->db->where('is_required', 1)->get('upload_documents_type')->result();
        foreach ($required_docs as $required_doc) {
            $exists = $this->db->select('id')->where(['employee_id' => $employee_id, 'document_type' => $required_doc->id])->get('upload_documents')->row();
            if(!$exists) {
                $this->db->insert('upload_documents', [
                    'employee_id' => $employee_id,
                    'created_date' => date('Y-m-d'),
                    'document_type' => $required_doc->id,
                    'status' => 'missing',
                    'period_end' => $required_doc->has_deadline ? date('Y-m-d', strtotime('+5 days')) . ' 23:59:59' : null,
                ]);
            }
        }
    }
    public function total_hired_candidate_by_job($jp_id)
    {
        return $this->db->where(['status' => 'completed', 'jp_id' => $jp_id])->count_all_results('candidate_basic_info');
    }
/*##########################Interview Part ################*/
    public function viewInterview()
    {
        return $this->db->select('count(DISTINCT(int.can_int_id)) as can_int_id,int.*,bi.can_id,bi.first_name,bi.last_name,po.position_name')
            ->from('candidate_interview int')
            ->join('candidate_basic_info bi', 'int.can_id = bi.can_id', 'left')
            ->join('position po', 'int.job_adv_id = po.pos_id', 'left')
            ->group_by('int.can_int_id')
            ->order_by('int.can_int_id', 'desc')
            ->get()
            ->result();
    }
    public function interview_create($data = array(), $can_skills = [])
    {
        $this->db->trans_start();
        $this->db->insert('candidate_interview', $data);
        $insert_id = $this->db->insert_id();
        if($can_skills && $insert_id){
            $skills = getByWhere(
                'job_posting_skills',
                '*',
                ['jp_id' => $data['job_adv_id']]
            );
            $skill_list = [];
            foreach ($skills as $skill) {
                $skill_list[$skill->jps_id] = $skill;
            }
            foreach ($can_skills as $key => $value) {
                $this->db->insert('interview_skill_result', [
                    'skill' => $skill_list[$key]->jps_name,
                    'pass' => !empty($value),
                    'can_id' => $data['can_id'],
                    'job_id' => $data['job_adv_id'],
                    'can_int_id' => $insert_id
                ]);
            }
        }
        $this->db->where('can_id', $data['can_id'])->update('candidate_basic_info', [
            'status' => 'interview_done',
            'updated_at' => current_date(true)
        ]);
        $this->db->where('can_id', $data['can_id'])->update('candidate_shortlist', [
            'interview_done' => 1,
        ]);
        $this->activity
        ->set_url('recruitment/Candidate_select/process?jp_id=' . $data['job_adv_id'])
        ->set_job($data['job_adv_id'])
        ->set_candidate($data['can_id'])
        ->log('interview_conducted');
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function delete_interview($id = null)
    {
        return;
        $this->db->where('can_int_id', $id)
            ->delete('candidate_interview');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_interview($data = array())
    {
        return $this->db->where('can_int_id', $data["can_int_id"])
            ->update("candidate_interview", $data);
    }
    public function interview_updateForm($id)
    {
        return $caninterviewInfo = $this->db->select('a.*,b.position_name')->from('candidate_interview a')->join('position b', 'a.job_adv_id=b.pos_id')->where('a.can_int_id', $id)->get()->row();
    }
    public function interview_history($can_id)
    {
        $rec = getByWhere(
            'candidate_interview,
            candidate_basic_info-candidate_interview.can_id=candidate_basic_info.can_id-left,
			job_posting-job_posting.jp_id=candidate_interview.job_adv_id-left,
			position-job_posting.pos_id=position.pos_id-left,
			user-candidate_interview.interviewer_id=user.id-left,
			employee_history-employee_history.email=user.email-left',
            'candidate_interview.*,
			position.position_name as position,
			CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as interviewer_name,
			employee_history.hrm_id,
            CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as candidate_name',
            ['candidate_interview.can_id' => $can_id],
            ['candidate_interview.interview_date', 'ASC']
        );
        if($rec){
            foreach ($rec as $key => $rc) {
                $rec[$key]->skill_results = getByWhere('interview_skill_result', 'skill, pass', [
                    'can_int_id' => $rc->can_int_id,
                    'can_id' => $rc->can_id
                ]);
            }
        }
        return $rec;
    }
    /* #################### Selection Part  #######################*/
    public function viewSelection()
    {
        return $this->db->select('count(DISTINCT(sel.can_sel_id)) as can_sel_id,sel.*,bi.can_id,bi.first_name,bi.last_name,pi.position_name,cbc.background_status')
            ->from('candidate_selection sel')
            ->join('candidate_basic_info bi', 'sel.can_id = bi.can_id', 'left')
            ->join('position pi', 'pi.pos_id = sel.pos_id', 'left')
            ->join('candidate_background_check cbc', 'cbc.can_id = sel.can_id', 'left')
            ->group_by('sel.can_sel_id')
            ->order_by('sel.can_sel_id', 'desc')
            ->get()
            ->result();
    }
    public function hire_candidate($can_id, $doj, $salary)
    {
        $this->db->trans_start();
        $can_rec = getByWhere('candidate_basic_info, job_posting-job_posting.jp_id=candidate_basic_info.jp_id-left', 'candidate_basic_info.*, job_posting.pos_id', ['can_id' => $can_id]);
        if ($can_rec) {
            $can_rec = $can_rec[0];
            $this->db->insert('candidate_selection', [
                'can_id' => $can_rec->can_id,
                'employee_id' => 0,
                'pos_id' => $can_rec->pos_id,
                'joining_date' => date('Y-m-d H:i:s', strtotime($doj)),
                'salary' => preg_replace('@\D+@', '', $salary),
            ]);
            $this->db->where('can_id', $can_rec->can_id)->update('candidate_basic_info', [
                'status' => 'rm_pending',
                'updated_at' => current_date(true)
            ]);
        }
        $rm_user_ids = $this->notify->role('recruitment_manager')->get_all_users();
        $this->notify->clear();
        if($rm_user_ids) {
            $this->notify->role('recruitment_manager')->send(
                sprintf('Candidate "%s %s (%s)" needs your onboarding approval', $can_rec->first_name, $can_rec->last_name, $can_rec->email),
                'recruitment/Candidate_select/process'
            );
            $user_recs = $this->db->where_in('user.id', $rm_user_ids)->select('COALESCE(NULLIF(employee_history.business_email,\'\'), user.email) as email')->join('employee_history', 'user.email=employee_history.email', 'left')->get('user')->result();
            $user_recs = array_column($user_recs, 'email');
            $this->template_mail->send($can_rec->jp_id, 'onboarding_approval', $user_recs, [], [], $can_id, null, [
                'candidate' => [
                    'joining_date' => $doj,
                    'salary' => $salary,
                ],
            ]);
        }
        $this->activity
        ->set_url('recruitment/Candidate_select/process?jp_id=' . $can_rec->jp_id)
        ->set_job($can_rec->jp_id)
        ->set_candidate($can_id)
        ->log('candidate_hired');
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function selection_create($data = array())
    {
        return $this->db->insert('candidate_selection', $data);
    }
    public function selection_delete($id = null)
    {
        return;
        $this->db->where('can_sel_id', $id)
            ->delete('candidate_selection');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_selection($data = array())
    {
        return $this->db->where('can_sel_id', $data["can_sel_id"])
            ->update("candidate_selection", $data);
    }
    public function selection_updateForm($id)
    {
        $this->db->where('can_sel_id', $id);
        return $query = $this->db->select('a.*,b.position_name')->from('candidate_selection a')->join('position b', 'a.pos_id=b.pos_id')->where('a.can_sel_id', $id)->get()->row();
    }
    public function dropdowninterview()
    {
        $this->db->select('a.*,b.first_name,b.last_name');
        $this->db->from('candidate_shortlist a');
        $this->db->join('candidate_basic_info b', 'a.can_id=b.can_id');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->first_name . ' ' . $value->last_name;
            }
        }
        return $list;
    }
    public function dropdownselection()
    {
        $data = $this->db->select('a.*,b.first_name,b.last_name')->from('candidate_interview a')->join('candidate_basic_info b', 'a.can_id=b.can_id')->where('a.selection', 'ok')->get()->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->first_name . ' ' . $value->last_name;
            }
        }
        return $list;
    }
    /* selected dropdown position */
    public function selected()
    {
        $query = $this->db->get_where('candidate_interview', array('selection' => "ok"));
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->job_adv_id] = $value->job_adv_id;
            }
        }
        return $list;
    }
/*  ################ selected auto ######################  */
    public function insert_employee($data = array())
    {
        return $this->db->insert('employee_history', $data); //
    }
    public function Canlist()
    {
        $this->db->select("can_id,CONCAT_WS(' ',first_name,last_name) AS name");
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->name;
            }
        }
        return $list;
    }
    public function headcode()
    {
        $query = $this->db->query("SELECT MAX(HeadCode) as HeadCode FROM acc_coa WHERE HeadLevel='2' And HeadCode LIKE '502020000%'");
        return $query->row();
    }
    public function create_coa($data = [])
    {
        $this->db->insert('acc_coa', $data);
        return true;
    }
    public function get_dropdowns()
    {
        $data = [];
        $this->db->distinct();
        $data['status'] = getByWhere('candidate_basic_info', 'status', ['status !=' => null], ['status', 'ASC']);
        $data['positions'] = getByWhere('job_posting, position-position.pos_id=job_posting.pos_id-left', 'job_posting.jp_id, DATE(job_posting.jp_posted_on) as posted_on, position.position_name', [], ['job_posting.jp_posted_on', 'DESC']);
        $data['users'] = getByWhere('user, employee_history-employee_history.email=user.email-left', 'user.id, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as name, employee_history.hrm_id', [], ['employee_history.first_name', 'ASC']);
        return $data;
    }
    public function get_empty_interview_slot($date = null)
    {
        if (!$date) {
            $date = date('Y-m-d H:i:s');
        }
        $datetime = new DateTime($date);
        $date = $datetime->modify('+1 hour')->format('Y-m-d H:i:s');

        $rec = null;
        $interval = null;
        do {
            $interval = $this->date_range_interval($interval['end'] ? $interval['end'] : $date, $interval['end']);
            $rec = $this->db->query("SELECT
				*
				FROM `candidate_shortlist`
				WHERE interview_done != 1 AND interview_date BETWEEN  ? AND ?",
                [$interval['start'], $interval['end']]
            )->row();
        } while ($rec);
        return formatted_date($interval['start'], true);
    }
    public function check_interview_slot($date)
    {
        $interval = $this->date_range_interval($date);
        return $this->db->query("SELECT
			*
			FROM `candidate_shortlist`
			WHERE interview_done != 1 AND interview_date BETWEEN  ? AND ?",
            [$interval['start'], $interval['end']]
        )->row();
    }
    public function schedule_interview($can_id, $date, $interviewer, $rescheduled)
    {
        $this->db->trans_start();
        $rec = getByWhere('candidate_shortlist', '*', [
            'can_id' => $can_id,
            'interview_done' => 0,
        ], ['can_short_id', 'DESC'])[0];
        $can_rec = getByWhere('candidate_basic_info', '*', ['can_id' => $can_id])[0];
        if ($rec) {
            $this->db->where('can_short_id', $rec->can_short_id)->update('candidate_shortlist', [
                'interview_date' => date('Y-m-d H:i:s', strtotime($date)),
                'interviewer_id' => $interviewer ? $interviewer : $rec->interviewer_id,
            ]);
            if($rescheduled){
                $this->notify->department('hr')->user($rec->interviewer_id)->send(
                    sprintf('Interview scheduled for candidate \'%s %s\' on \'%s\' has been canceled', $can_rec->first_name, $can_rec->last_name, formatted_date($rec->interview_date, true))
                );
                $interv_rec = get_employee_by_user_id($rec->interviewer_id);
                $this->template_mail->send($rec->job_adv_id, 'interview_canceled', null, [$interv_rec->working_email], [], $can_id, null, [
                    'candidate' => [
                        'interview_date' => formatted_date($rec->interview_date, true)
                    ]
                ]);
            }
        } else {
            $rec = getByWhere('candidate_shortlist', '*', [
                'can_id' => $can_id,
            ], ['can_short_id', 'DESC'])[0];
            $this->db->insert('candidate_shortlist', [
                'can_id' => $can_id,
                'job_adv_id' => $rec->job_adv_id,
                'date_of_shortlist' => $rec->date_of_shortlist,
                'interview_date' => date('Y-m-d H:i:s', strtotime($date)),
                'shortlist_by' => $rec->shortlist_by,
                'interviewer_id' => $interviewer,
            ]);
        }
        $this->db->where('can_id', $can_id)->update('candidate_basic_info', [
            'status' => 'interview_pending',
            'updated_at' => current_date(true)
        ]);
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            $this->notify->department('hr')->user($interviewer)->send(
                sprintf('New Interview scheduled for candidate \'%s %s\' on \'%s\'', $can_rec->first_name, $can_rec->last_name, $date)
            );
            $interv_rec = get_employee_by_user_id($interviewer);
            $this->template_mail->send($rec->job_adv_id, 'interview_scheduled', null, [$interv_rec->working_email], [], $can_id);
            $this->activity
            ->set_job($can_rec->jp_id)
            ->set_candidate($can_id)
            ->set_user($interviewer)
            ->log([
                'interview_scheduled',
                formatted_date($date, true)
            ]);
        }
        return $this->db->trans_status();
    }
    public function cancel_interview($can_id)
    {
        $this->db->trans_start();
        $rec = getByWhere('candidate_shortlist', '*', [
            'can_id' => $can_id,
            'interview_done' => 0,
        ], ['can_short_id', 'DESC'])[0];
        if ($rec) {
            $this->db->where('can_short_id', $rec->can_short_id)->update('candidate_shortlist', [
                'interview_done' => 1,
            ]);
        }
        $this->db->where('can_id', $can_id)->update('candidate_basic_info', [
            'status' => 'interview_canceled',
            'updated_at' => current_date(true)
        ]);
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            $can_rec = getByWhere('candidate_basic_info', '*', ['can_id' => $can_id])[0];
            $this->notify->department('hr')->user($rec->interviewer_id)->send(
                sprintf('Interview scheduled for candidate \'%s %s\' on \'%s\' has been canceled', $can_rec->first_name, $can_rec->last_name, $rec->interview_date)
            );
            $interv_rec = get_employee_by_user_id($rec->interviewer_id);
            $this->activity
            ->set_job($rec->job_adv_id)
            ->set_candidate($can_id)
            ->log([
                'interview_canceled',
                formatted_date($rec->interview_date, true)
            ]);
            $this->template_mail->send($rec->job_adv_id, 'interview_canceled', null, [$interv_rec->working_email], [], $can_id);
        }
        return $this->db->trans_status();
    }
    public function pending_interview($can_id)
    {
        return getByWhere(
            'candidate_shortlist,
			candidate_basic_info-candidate_basic_info.can_id=candidate_shortlist.can_id-left,
			job_posting-job_posting.jp_id=candidate_basic_info.jp_id-left,
			position-position.pos_id=job_posting.pos_id-left,
			user-candidate_shortlist.interviewer_id=user.id-left',
            'candidate_shortlist.*,
			CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as can_name,
			position.position_name as position,
			CONCAT_WS(\' \', user.firstname, user.lastname) as interviewer',
            [
                'candidate_basic_info.can_id' => $can_id,
                'candidate_shortlist.interview_done' => 0,
            ]
        )[0];
    }
    public function pending_interview_by_id($id)
    {
        return getByWhere(
            'candidate_shortlist,
			candidate_basic_info-candidate_basic_info.can_id=candidate_shortlist.can_id-left,
			job_posting-job_posting.jp_id=candidate_basic_info.jp_id-left,
			position-position.pos_id=job_posting.pos_id-left,
			user-candidate_shortlist.interviewer_id=user.id-left',
            'candidate_shortlist.*,
			CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as can_name,
			position.position_name as position,
			CONCAT_WS(\' \', user.firstname, user.lastname) as interviewer',
            [
                'candidate_shortlist.can_short_id' => $id,
                'candidate_shortlist.interview_done' => 0,
            ]
        )[0];
    }
    private function date_range_interval($date, $hour = false)
    {
        $datetime = new DateTime($date);
        if ($hour) {
            $date = $datetime->modify('+1 minute')->format('Y-m-d H:i:s');
            $datetime = new DateTime($date);
        }
        $datetime->modify('+59 minute');
        return [
            'start' => $date,
            'end' => $datetime->format('Y-m-d H:i:s'),
        ];
    }
    public function get_hired_candidates($id = null, $status = null)
    {
        $this->db->select(
            'candidate_basic_info.*,
            position.*, employee_history.hrm_id, employee_history.hire_date'
            )->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id', 'left')
            ->join('position', 'job_posting.pos_id = position.pos_id', 'left')
            ->join('employee_history', 'candidate_basic_info.employee_id = employee_history.employee_id', 'left')
            ->order_by('employee_history.hire_date', 'desc')
            ->where('candidate_basic_info.status !=', null)
            ->where('candidate_basic_info.status =', 'completed');
        if ($id) {
            $this->db->where('candidate_basic_info.jp_id', $id);
        }
        if ($status) {
            $this->db->where('candidate_basic_info.status', $status);
        }

        return $this->db->get()
            ->result();
    }
}
