<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Curl\Curl;

class Credmlmsp_model extends CI_Model
{
    private $_filter_role_ids = [
        1, 6,
    ];
    private $_creds = null;
    public function __construct()
    {
        parent::__construct();
        $this->_creds = $this->db->where('id', 'mlmsp')->get('other_portals')->row_array();
        if (empty($this->_creds)) {
            log_message('error', 'No settings found for MLM SP');
        }
    }
    public function getRoles()
    {
        if (!$data = $this->cache->get('Cred.mlmsp.Roles')) {
            try {
                $curl = new Curl();
                $raw_data = $curl->get($this->_creds['url'] . '/rolelisting?rl');
                if ($curl->error) {
                    throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
                }
                foreach ($raw_data as $raw_dt) {
                    if (in_array($raw_dt->userRoleId, $this->_filter_role_ids)) {
                        continue;
                    }
                    $data[] = [
                        'id' => $raw_dt->userRoleId,
                        'name' => $raw_dt->userRoleName,
                    ];
                }
            } catch (Throwable $e) {
                log_message('error', 'SP getRoles: ' . $e->getMessage());
                return [];
            }
            $this->cache->save('Cred.mlmsp.Roles', $data, 10800);
        }

        return $data;
    }
    public function getEmail($string)
    {
        return $string . '@' . $this->_creds['email'];
    }
    public function userExists($email, $verbose = false)
    {
        $curl = new Curl();
        try {
            $curl->setHeader('apikey', $this->_creds['api_key']);
            $res = $curl->post($this->_creds['url'] . '/userExists', [
                'email' => $this->getEmail($email),
            ]);
            if ($curl->error && !in_array($curl->errorCode, [202, 404])) {
                throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
            }
            if ($verbose) {
                log_message('error', 'MLM SP user check reply: ' . json_encode($res));
                log_message('error', 'MLM SP user check status: ' . $curl->getHttpStatusCode());
            }
        } catch (Throwable $e) {
            log_message('error', 'SP userExists: ' . $e->getMessage());
            return null;
        }
        switch ($curl->getHttpStatusCode()) {
            case 202:
                return true;
                break;
            case 404:
                return false;
                break;
            default:
                return null;
                break;
        }
    }
    public function getUserByPseudo($pseudo)
    {
        $cache_slug = 'Cred.mlmsp.get_supervisor.' . preg_replace('#\W+#', '', $pseudo);
        if (!$data = $this->cache->get($cache_slug)) {
            try {
                $curl = new Curl();
                $curl->setHeader('apikey', $this->_creds['api_key']);
                $raw_data = $curl->get($this->_creds['url'] . '/userbyemail', [
                    'email' => $this->getEmail($pseudo),
                ]);
                if ($curl->error) {
                    throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
                }
                if ($raw_data && isset($raw_data->status)) {
                    if ($raw_data->status == 'success') {
                        $data = $raw_data->message;
                    } else {
                        return null;
                    }
                } else {
                    throw new Exception('Invalid response: ' . json_encode($raw_data));
                }
            } catch (Throwable $e) {
                log_message('error', 'SP getUserByEmail: ' . $e->getMessage());
                return null;
            }
            $this->cache->save($cache_slug, $data, 3600);
        }

        return $data;
    }
    public function addUser($username, $employee, $roles)
    {
        $this->load->helper('string');
        $generated_password = str_replace('I', 'L', strtoupper(random_string('alpha', 6)));

        try {
            $supervisor_data = $this->getUserByPseudo($employee->supervisor_medflow_id);
            $curl = new Curl();
            $raw_data = $curl->post($this->_creds['url'] . '/signUp', [
                'fname' => $employee->first_name,
                'lname' => $employee->last_name,
                'email' => $this->getEmail($username),
                'password' => md5($generated_password),
                'location' => $employee->division_id == 3 ? 1 : 3,
                'role' => $roles,
                'Supervisor' => $supervisor_data ? $supervisor_data->UserId : '',
                'status' => 1,
                'BDE_Level' => 0,
                'LoggedUser' => 0,
                'HRM_Call' => !!$supervisor_data,
                'RealName' => implode(' ', [$employee->first_name, $employee->last_name]),
            ]);
            if ($curl->error && !in_array($curl->errorCode, [200])) {
                throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
            }
            log_message('error', sprintf('SP user create request: %s - role id: %s', $employee->hrm_id, $roles));
            if ($curl->getHttpStatusCode() == 200 && $raw_data->status == 'success') {
                return [
                    'username' => $this->getEmail($username),
                    'password' => $generated_password,
                ];
            }
            log_message('error', 'Unknown reply from SP: ' . json_encode($raw_data));
            log_message('error', 'Unknown reply from SP Status: ' . $curl->getHttpStatusCode());
        } catch (Throwable $e) {
            log_message('error', 'SP addUser: ' . $e->getMessage());
        }
        return [];
    }
    public function setStatus($medflow_id, $status)
    {
        $curl = new Curl();
        try {
            $curl->setHeader('apikey', $this->_creds['api_key']);
            $curl->post($this->_creds['url'] . '/changeStatus', [
                'email' => $this->getEmail($medflow_id),
                'status' => $status ? 'Y' : 'N',
            ]);
            if ($curl->error && !in_array($curl->errorCode, [202, 400])) {
                throw new Exception('HTTP Error: ' . $curl->errorCode . ': ' . $curl->errorMessage);
            }
        } catch (Throwable $e) {
            log_message('error', 'SP setStatus: ' . $e->getMessage());
            return null;
        }
        switch ($curl->getHttpStatusCode()) {
            case 202:
                return true;
                break;
            case 400:
                return false;
                break;
            default:
                return null;
                break;
        }
    }
}
