<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Candidate_model extends CI_Model
{
    public function create_caninfo($data = array())
    {
        $res = $this->db->insert('candidate_basic_info', $data);
        if ($res) {
            $this->notify->department('hr')->send(
                sprintf('A new candidate %s has entered into recruitment pool', implode(' ', [$data['first_name'], $data['last_name'], '(' . $data['can_id'] . ')'])),
                'recruitment/Candidate/candidateinfo_view'
            );
        }
        return $res;
    }
    public function viewcanInfoTalentNetwork()
    {
        return $this->db->select('*')
            ->from('talent_network')
            ->get()
            ->result();
    }
    public function viewcanInfo()
    {
        return $this->db->select('candidate_basic_info.*,position.*')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id')
            ->join('position', 'job_posting.pos_id = position.pos_id')
            ->order_by('candidate_basic_info.can_id', 'desc')
            ->get()
            ->result();
    }
    public function jobs_reads($id)
    {
        return $this->db->select('job_posting.jp_id,position.*')
            ->from('job_posting')
            ->join('position', 'job_posting.pos_id = position.pos_id')
            ->where('job_posting.jp_id', $id)
            ->order_by('position.position_name', 'desc')
            ->get()
            ->first_row();
    }
    public function specific_caninfo($id = null)
    {
        return $this->db->select('candidate_basic_info.*,position.*, referer.full_name referer_name, referer.hrm_id referer_id')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id', 'left')
            ->join('employee_details referer', 'candidate_basic_info.referrer = referer.employee_id', 'left')
            ->join('position', 'job_posting.pos_id = position.pos_id', 'left')
            ->where('candidate_basic_info.can_id', $id)
            ->get()
            ->row();
    }
    public function update_canInfo($data = array())
    {
        return $this->db->where('can_id', $data["can_id"])
            ->update("candidate_basic_info", $data);
    }
    public function delete_cinfo($id = null)
    {
        $this->activity->set_candidate($id)->log('candidate_deleted');
        $this->db->where('can_id', $id)
            ->delete('candidate_basic_info');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function delete_talentNetwork($id = null)
    {
        $rec = $this->db->from('talent_network')
            ->select('id, first_name, last_name')
            ->where('id', $id)
            ->get()
            ->row();
        if ($rec) {
            $this->activity->log([
                'talent_deleted',
                $rec->first_name,
                $rec->last_name,
                $rec->id,
            ]);
            $this->db->where('id', $id)
                ->delete('talent_network');
            if ($this->db->affected_rows()) {
                return true;
            }
        }
        return false;
    }
    public function canifo_updateForm($id)
    {
        $this->db->select('*');
        $this->db->from('candidate_basic_info');
        $this->db->join('candidate_education_info', 'candidate_basic_info.can_id = candidate_education_info.can_id', 'left');
        $this->db->join('candidate_workexperience', 'candidate_basic_info.can_id = candidate_workexperience.can_id', 'left');
        $this->db->where('candidate_basic_info.can_id', $id);
        return $data = $this->db->get()->row();
    }
    /*#############################----Education info Part---############*/
    public function viewEduinfo()
    {
        return $this->db->select('*')
            ->from('candidate_education_info')
            ->order_by('can_edu_id', 'desc')
            ->get()
            ->result();
    }
    public function upcanedu($id)
    {
        return $this->db->select('*')
            ->from('candidate_education_info')
            ->where('can_id', $id)
            ->get()
            ->result_array();
    }
    public function caneduinfo_create($data = array())
    {
        return $this->db->insert('candidate_education_info', $data);
    }
    public function eduinfo_dropdown()
    {
        $this->db->select('*');
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->can_id] = $value->can_id . $value->first_name;
            }
        }
        return $list;
    }
    public function delete_canedu_info($id = null)
    {
        $this->db->where('can_id', $id)
            ->delete('candidate_education_info');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_canEduinfo($data = array())
    {
        return $this->db->where('can_id', $data["can_id"])
            ->update("candidate_education_info", $data);
    }
    public function canEdu_updateForm($id)
    {
        $this->db->where('can_id', $id);
        $query = $this->db->get('candidate_education_info');
        return $query->row();
    }
    public function get_eduinf_dropdown($id)
    {
        $query = $this->db->get_where('candidate_basic_info', array('can_id' => $id));
        return $query->row_array();
    }
    public function viewExperience()
    {
        return $this->db->select('*')
            ->from('candidate_workexperience')
            ->order_by('can_workexp_id', 'desc')
            ->get()
            ->result();
    }
    public function work($id)
    {
        return $this->db->select('*')
            ->from('candidate_workexperience')
            ->where('can_id', $id)
            ->get()
            ->result();
    }
    public function canworkexp_create($data = array())
    {
        return $this->db->insert('candidate_workexperience', $data);
    } //
    public function update_workexperience($data = array())
    {
        return $this->db->where('can_id', $data["can_id"])
            ->update("candidate_workexperience", $data);
    }
    public function workexperience_updateForm($id)
    {
        $this->db->where('can_id', $id);
        $query = $this->db->get('candidate_workexperience');
        return $query->row();
    }
    public function delete_workexp($id = null)
    {
        $this->db->where('can_id', $id)
            ->delete('candidate_workexperience');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function retrieve_all_data()
    {
        $this->db->select("candidate_basic_info.can_id,candidate_basic_info.first_name,candidate_basic_info.email,candidate_basic_info.phone,candidate_education_info.degree_name,candidate_education_info.university_name,candidate_education_info.cgp");
        $this->db->from('candidate_basic_info');
        $this->db->join('candidate_education_info', 'candidate_basic_info.can_id = candidate_education_info.can_id');
        $this->db->group_by('candidate_education_info.can_id');
        $query = $this->db->get();
        return $query->result();
    }
    public function employee_details($id)
    {
        return $this->db->select('*')
            ->from('candidate_basic_info')
            ->where('can_id', $id)
            ->get()
            ->result();
    }
    public function eduInfo($id)
    {
        return $this->db->select('degree_name,university_name,cgp')
            ->from('candidate_education_info')
            ->where('can_id', $id)
        // ->order_by('can_workexp_id', 'desc')
            ->get()
            ->result();
    }
    public function workingexp($id)
    {
        return $this->db->select('*')
            ->from('candidate_workexperience')
            ->where('can_id', $id)
        // ->order_by('can_workexp_id', 'desc')
            ->get()
            ->result();
    }
    public function get_requisition_dropdown()
    {
        return getByWhereAsArray('job_posting, position-position.pos_id=job_posting.pos_id-left', 'job_posting.jp_id as job_id, position.position_name as position', [], ['job_posting.jp_id', 'desc']);
    }
    public function countAllRows()
    {
        return $this->db->count_all('candidate_basic_info');
    }
    private function query()
    {
        return $this->db->select('candidate_basic_info.*,position.*')
            ->from('candidate_basic_info')
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id')
            ->join('position', 'job_posting.pos_id = position.pos_id');
    }
    public function countDatatable($orWhere = [])
    {
        $query = $this->query();
        if ($orWhere) {
            $query->group_start();
            foreach ($orWhere as $key => $value) {
                $query->or_like($key, $value, 'right', false);
            }
            $query->group_end();
        }
        return $query->count_all_results();
    }
    public function getDatatable($post, $orWhere = [])
    {
        $query = $this->query();
        if ($orWhere) {
            $query->group_start();
            foreach ($orWhere as $key => $value) {
                $query->or_like($key, $value, 'right', false);
            }
            $query->group_end();
        }
        $query->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir']);
		if($post['length'] > 0) {
            $query->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
		}
        return $query->get()->result_array();
    }
}
