<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Candidate_select extends Loggedin_Controller {

	public function __construct()
	{
		parent::__construct();
		
		$this->load->model(array(
			'Selection_model',
			'Job_model',
		));
	}

	public function process()
	{
        $this->permission->module('process_applications','read')->redirect();

        $this->load->model('employee/Employees_model');
        $data['positions'] = $this->Employees_model->designation();
		$data['title']    = display('process_applications');
		$data['caninfo'] = $this->Selection_model->underprocess_list($this->input->get('jp_id'), $this->input->get('status'));
		$data['dropdowns'] = $this->Selection_model->get_dropdowns();
		$data['module'] = "recruitment";
		$data['page']   = "process_applications";   
		echo Modules::run('template/layout', $data); 
	}
	public function get_interview_slot()
	{
		if($this->input->post()){
			$date = null;
			if(!empty($this->input->post('date'))){
				$date = date('Y-m-d H:i:s', strtotime($this->input->post('date')));
			}
			sendJson([
				'success' => $this->Selection_model->get_empty_interview_slot($date)
			]);
		}
	}
	public function check_interview_slot()
	{
		if($this->input->post()){
			$date = date('Y-m-d H:i:s', strtotime($this->input->post('date')));
			$date = $this->Selection_model->check_interview_slot($date);
			if(!$date){
				sendJson(['vacant'=> '1']);
			}else{
				sendJson(['filled'=> '1']);				
			}
		}
	}
	public function candidate_details()
	{
		if($this->input->post('can_id')){
			$this->load->model('candidate_model');
			$rec = $this->candidate_model->specific_caninfo($this->input->post('can_id'));
			if($rec){
				sendJson(['success' => $rec]);
			}
		}
		sendJson(['error' => 1]);
	}
	public function rejected()
	{
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('rejected_applications');
		$data['caninfo'] = $this->Selection_model->rejected_list();
		$data['module'] = "recruitment";
		$data['page']   = "rejected_applications";   
		echo Modules::run('template/layout', $data); 
	}
	public function pending_interview()
	{
		if($this->input->post('can_id')){
			$rec = $this->Selection_model->pending_interview($this->input->post('can_id'));
			if($rec){
				$rec->interview_date = formatted_date($rec->interview_date);
			}
			if($rec){
				sendJson(['success' => $rec]);
			}
		}
		sendJson(['error' => 1]);
	}
    public function candidate_shortlist_view(){   
        $this->permission->module('recruitment','read')->redirect();
		$data['title']         = display('shortlist');  ;
		$data['shortlist']     = $this->Selection_model->viewShortlist();
		$data['dropdowncanid'] = $this->Selection_model->dropdowncanid(); 
		$data['dropdown']      = $this->Selection_model->dropdown(); 
		$data['module']        = "recruitment";
		$data['page']          = "shortlist_view";  
		echo Modules::run('template/layout', $data); 
	} 
	public function schedule_interview()
	{
		if($this->input->post()){
			$rules_config = array(
			   array(
				  'field' => 'interview_date',
				  'label' => 'Interview Date',
				  'rules' => 'trim|required',
			   ),
			   array(
				  'field' => 'user_id',
				  'label' => 'Interviewer',
				  'rules' => 'trim|required',
			   ),
			);
			$this->form_validation->set_rules($rules_config);
			if ($this->form_validation->run() === true) {
				$res = $this->Selection_model->schedule_interview(
					$this->input->post('can_id'),
					$this->input->post('interview_date'),
					$this->input->post('user_id'),
					!empty($this->input->post('reschedule'))
				);
				if($res){
					$this->session->set_flashdata('success', 'Interview scheduled successfully');
				}else{
					$this->session->set_flashdata('exception', 'Error while scheduling interview, try again');
				}
			}else{
				$this->session->set_flashdata('exception', validation_errors());
			}
			redirect($_SERVER['HTTP_REFERER']);
		}
	}
	public function cancel_interview()
	{
		if($this->input->post()){
			$res = $this->Selection_model->cancel_interview(
				$this->input->post('can_id')
			);
			if($res){
				$this->session->set_flashdata('success', 'Interview canceled successfully');
			}else{
				$this->session->set_flashdata('exception', 'Error while canceling interview, try again');
			}
		}
		sendJson(['success' => 1]);
	}
	public function save_interview()
	{
		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('total_marks', 'Typing Speed','max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'max_length[1028]');
		$this->form_validation->set_rules('details',display('details')  ,'max_length[1028]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {
			$rec = $this->Selection_model->pending_interview_by_id($this->input->post('can_short_id'));
			if($rec){
				$postData = [
					'can_id' 	         => $this->input->post('can_id',true),
					'job_adv_id' 	     => $rec->job_adv_id,
					'interview_date' 	 => $rec->interview_date,
					'interviewer_id' 	 => $rec->interviewer_id,
					'interview_marks' 	 => 0,
					'written_total_marks'=> 0,
					'mcq_total_marks' 	 => 0,
					'total_marks' 	     => $this->input->post('total_marks',true),
					'recommandation' 	 => $this->input->post('recommandation',true),
					'details' 	         => $this->input->post('details',true),
				];   
				if ($this->Selection_model->interview_create($postData, $_POST['skills'])) { 
					$this->session->set_flashdata('message', display('successfully_saved'));
				} else {
					$this->session->set_flashdata('exception',  display('please_try_again'));
				}
			}else{
				$this->session->set_flashdata('exception',  'Interview details not found, try again');
			}
		}else{
			$this->session->set_flashdata('exception',  validation_errors());
		}
		redirect($_SERVER['HTTP_REFERER']);
	}
	public function interview_history()
	{
		if($this->input->post('can_id')){
			$data['history'] = $this->Selection_model->interview_history($this->input->post('can_id'));
			sendJson(['success' => $this->load->view('interview_history_partial', $data, true)]);
		}
		sendJson(['error' => 1]);
	}
	public function hire_candidate()
	{
		if($this->input->post('can_id')){
			$rules_config = array(
			   array(
				  'field' => 'date_of_joining',
				  'label' => 'Date Of Joining',
				  'rules' => 'trim|required',
			   ),
			   array(
				  'field' => 'salary',
				  'label' => 'Salary',
				  'rules' => 'trim|required|is_natural',
				),
			);
			$this->form_validation->set_rules($rules_config);
			if ($this->form_validation->run() === true) {
			   if($this->Selection_model->hire_candidate(
				   	$this->input->post('can_id'),
					$this->input->post('date_of_joining'),
					$this->input->post('salary')
				)){
					$this->session->set_flashdata('success', 'Candidate record updated successfully');
				}else{
					$this->session->set_flashdata('exception', 'Error while updating candidate record, try again');
				}
			}else{
				$this->session->set_flashdata('exception', validation_errors());
			}
		}
		redirect($_SERVER['HTTP_REFERER']);
	}
	public function get_selection_info()
	{
		if($this->input->post('can_id')){
			$rec = getByWhere('candidate_selection', '*', ['can_id' => $this->input->post('can_id')]);
			if($rec){
				$rec = $rec[0];
				sendJson(['success' => $rec]);
			}
		}
		sendJson(['error' => 1]);
	}
	public function rm_status($status)
	{
		if($this->input->post('can_id')){
			if($status == 'reject'){
				if($this->Selection_model->rm_reject($this->input->post('can_id'))){
					$this->session->set_flashdata('success', 'Record updated successfully');
					sendJson(['success' => 1]);
				}else{
					$this->session->set_flashdata('exception', 'Error while updating, try again');
				}
			}
			if($status == 'approve'){
				if($this->Selection_model->employee_onboarding($this->input->post('can_id'))){
					$this->session->set_flashdata('success', 'Record updated successfully');
					sendJson(['success' => 1]);
				}else{
					$this->session->set_flashdata('exception', 'Error while updating, try again');
				}
			}
		}
		sendJson(['error' => 1]);
	}
public function create_shortlist()
	{ 
		redirect();
		$data['title'] = display('candidateshortlist');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_shortlist.can_id]|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('date_of_shortlist',display('date_of_shortlist'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'can_id' 	       => $this->input->post('can_id',true),
				'job_adv_id' 	   => $this->input->post('job_adv_id',true),
				'date_of_shortlist'=> $this->input->post('date_of_shortlist',true),
				'interview_date'   => $this->input->post('interview_date',true),
			];   

			if ($this->Selection_model->shortlist_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/create_shortlist");

		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "shortlist_form"; 
			$data['dropdowncanid'] = []; 
			$data['dropdown'] = $this->Selection_model->dropdown(); 
			$data['shortlist'] = $this->Selection_model->viewShortlist();
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	
	public function dropdowncanid($id){

		$this->db->select('*');
        $this->db->from('candidate_basic_info');
        $this->db->where('jp_id',$id);
        $query = $this->db->get();
        $data = $query->result();
       
        $list = array('' => 'Select One...');
        $html = "";
       	if (!empty($data) ) {
       	    $html .= "<option value=''>Select One...</option>";
       		foreach ($data as $value) {
       		    $html .= "<option value='".$value->can_id."'>".$value->first_name."(".$value->can_id.").</option>";
       		} 
       	}
    	echo $html;
    }
    
    public function dropdowncanidby_can_id($id){

		$this->db->select('*');
        $this->db->from('candidate_basic_info');
        $this->db->where('can_id',$id);
        $query = $this->db->get();
        $data = $query->first_row();
       
        echo json_encode($data);
    }
    
    

	public function delete_shortlist($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Selection_model->delete_shorlist($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect('recruitment/Candidate_select/candidate_shortlist_view');
	}

public function update_shortlist_form($id = null){
	redirect();
 		$this->form_validation->set_rules('can_short_id',null,'required|max_length[11]');
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('date_of_shortlist',display('date_of_shortlist'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_short_id' 	             => $this->input->post('can_short_id',true),
				'can_id' 	                 => $this->input->post('can_id',true),
				'job_adv_id' 	             => $this->input->post('job_adv_id',true),
				'date_of_shortlist' 		 => $this->input->post('date_of_shortlist',true),
				'interview_date' 		     => $this->input->post('interview_date',true),
			]; 
			
			if ($this->Selection_model->update_shortlist($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/update_shortlist_form/". $id);

		} else {
			$data['title']   = display('update');
		    $data['data']    =$this->Selection_model->shortlist_updateForm($id);
		    $data['canlist'] =$this->Selection_model->Canlist();
			$data['module']  = "recruitment";
			$data['dropdown']= $this->Selection_model->dropdown(); 
			$data['page']    = "update_short_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}


	/*######################## Interview Part ######################*/
public function candidate_interview_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('interview');  ;
		$data['interview'] = $this->Selection_model->viewInterview();
		$data['module'] = "recruitment";
		$data['page']   = "interview_view";   
		echo Modules::run('template/layout', $data); 
	} 

	public function select_interviewlist($id){

    	$data = $this->db->select('a.*,b.position_name')->from('candidate_shortlist a')->join('position b','a.job_adv_id=b.pos_id')->where('a.can_id',$id)->get()->row();
    
    	echo json_encode($data);
    }
    


public function create_interview()
	{ 
		redirect();
		$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_interview.can_id]|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');

		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('total_marks',display('total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'total_marks' 	     => $this->input->post('total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			];   

			if ($this->Selection_model->interview_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/create_interview");
		   } else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "interview_form"; 
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['interview'] = $this->Selection_model->viewInterview();
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}


  public function delete_interview($id = null){ 
     $this->permission->module('recruitment','delete')->redirect();
		if ($this->Selection_model->delete_interview($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("recruitment/Candidate_select/candidate_interview_view");
	}

	public function interview_update_form($id = null){
		redirect();
		$this->form_validation->set_rules('can_int_id',null,'required|max_length[11]');
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'required|max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_int_id' 	     => $this->input->post('can_int_id',true),
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			]; 
			
			if ($this->Selection_model->update_interview($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
				redirect("recruitment/Candidate_select/create_interview");
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
				redirect("recruitment/Candidate_select/interview_update_form/". $id);
			}	

	     	} else {
			$data['title']  = display('update');
		    $data['data']   =$this->Selection_model->interview_updateForm($id);
			$data['module'] = "recruitment";
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['page']   = "update_interview_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
	
		/*######################## Job posting Part ######################*/
public function job_posting_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('interview');  ;
		$data['interview'] = $this->Selection_model->viewInterview();
		$data['module'] = "recruitment";
		$data['page']   = "interview_view";   
		echo Modules::run('template/layout', $data); 
	} 

	public function select_joblist($id){

	$data = $this->db->select('a.*,b.position_name')->from('candidate_shortlist a')->join('position b','a.job_adv_id=b.pos_id')->where('a.can_id',$id)->get()->row();

	echo json_encode($data);
}

    public function positionselect(){

    	$data = $this->Job_model->getPositions($_POST['search']);
    
    	echo json_encode($data);
    }

public function job_posting_form()
	{ 
		redirect();
	   // echo "<pre>";
	   // print_r($this->Job_model->viewJobPosting());die;
		$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_interview.can_id]|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');

		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('total_marks',display('total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'total_marks' 	     => $this->input->post('total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			];   

			if ($this->Selection_model->interview_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/create_interview");
		   } else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "job_posting_form"; 
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['job_posting'] = $this->Job_model->viewJobPosting();
			$data['cities'] = $this->Job_model->cities();
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}


  public function job_posting_interview($id = null){ 
     $this->permission->module('recruitment','delete')->redirect();
		if ($this->Selection_model->delete_interview($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("recruitment/Candidate_select/candidate_interview_view");
	}

	public function job_posting_update_form($id = null){
		redirect();
		$this->form_validation->set_rules('can_int_id',null,'required|max_length[11]');
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'required|max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_int_id' 	     => $this->input->post('can_int_id',true),
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			]; 
			
			if ($this->Selection_model->update_interview($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
				redirect("recruitment/Candidate_select/create_interview");
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
				redirect("recruitment/Candidate_select/interview_update_form/". $id);
			}	

	     	} else {
			$data['title']  = display('update');
		    $data['data']   =$this->Selection_model->interview_updateForm($id);
			$data['module'] = "recruitment";
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['page']   = "update_interview_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
/* ##################### selection part ###########################*/
/* ##################### selection part ###########################*/



public function candidate_selection_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('selection');  ;
		$data['selection'] = $this->Selection_model->viewSelection();
		$data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
		$data['module'] = "recruitment";
		$data['page']   = "selection_view";   
		echo Modules::run('template/layout', $data); 
	} 


public function select_to_load($id){

	$data = $this->db->select('*')->from('candidate_interview')->where('can_id',$id)->get()->row();

	echo json_encode($data);
}

public function select_to_load_background_data($id){

	$data = $this->db->select('*')->from('candidate_background_check')->where('can_id',$id)->get()->row();

	echo json_encode($data);
}
public function sendingEmail($sendToEmail = null, $name = null, $subject = null, $templatePath = null, $data = array()){
	    if($sendToEmail != null && $subject != null && $templatePath != null && !empty($data)){
	        $mail = $this->phpmailer_library->load();
    		$mail->SMTPDebug =0;                                 // Enable verbose debug output
    		$mail->SMTPOptions = array(
    			'ssl' => array(
    				'verify_peer' => false,
    				'verify_peer_name' => false,
    				'allow_self_signed' => true
    			)
    		);
    		$mail->Host = $this->config->item('smtp_host');  // Specify main and backup SMTP servers
    		$mail->isSMTP();
    		$mail->Port = $this->config->item('smtp_port');
    		$mail->SMTPAuth = true;
    		$mail->SMTPSecure = $this->config->item('smtp_crypto'); // Enable SMTP authentication
    		$mail->Username = $this->config->item('smtp_user'); // SMTP username
            $mail->Password = $this->config->item('smtp_pass');  // TCP port to connect to
    		$mail->setFrom($this->config->item('admin_info'), $this->config->item('mail_subject'));
    		$mail->addAddress($sendToEmail, $name);
    		$mail->isHTML(true);  // Set email format to HTML
    		$mail->Subject = $subject;
    		$mail->Body = $this->load->view($templatePath, $data, TRUE);   
    		if($mail->send()){
    		    return true;
    		}
        }
	}

public function create_selection()
	{ 
		redirect();
		$data['title'] = display('selectionlist');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_selection.can_id]|max_length[50]');
		$this->form_validation->set_rules('pos_id',display('pos_id'),'required|max_length[50]');
		$this->form_validation->set_rules('selection_terms',display('selection_terms')  ,'required|max_length[100]');
		$id=$this->input->post('can_id');
		$employee = $this->db->select('*')->from('candidate_basic_info')->where('can_id',$id)->get()->row();
	   //  $zk = new ZKLibrary('192.168.1.201', 4370);
	   //     // echo 'welcome';exit();
	   //         $zk->connect();
	   //         $zk->disableDevice();
    //             $user = $zk->getUser();
    //             $max = max($user);
    //             $max_id = $max[0];
	   //         $zk->enableDevice();
    //             $zk->disconnect();
		
		if(!empty($max_id)){
		$employee_id = $max_id+1;	
		}else{
			$employee_id=1;
		}

		#-------------------------------#
		if ($this->form_validation->run() === true) {
		    
		    if(isset($_POST['sent_job_letter']) && $_POST['sent_job_letter'] !=''){
		        $data = array();
    		    $chapterList = $this->load->view('email/job_offer_pdf.php', $data, TRUE);
    
    
                $filename = "Job_Offer_".$employee->first_name.'_'.$employee->last_name."_".date("Y_m_d_h_i_s").".pdf";
                
                $pdfFilePath = "./assets/$filename";
                ini_set('memory_limit','128M');
                $this->pdf->loadHtml($chapterList);
                $this->pdf->render();
                $output = $this->pdf->output();
                file_put_contents($pdfFilePath, $output);
                $mail = $this->phpmailer_library->load();
                //Server settings
                $mail->SMTPDebug =0;                                 // Enable verbose debug output
                $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );
                $mail->isSMTP();    
                                                  // Set mailer to use SMTP
                $mail->Host = 'smtp.gmail.com';  // Specify main and backup SMTP servers
                $mail->isSMTP();
                $mail->Port = 587;
                $mail->SMTPAuth = true;
                $mail->SMTPSecure = 'tls';                            // Enable SMTP authentication
                $mail->Username = "protegeglobal93@gmail.com";                 // SMTP username
                $mail->Password = "global93protege321";                                  // TCP port to connect to
                //Recipients
                $mail->setFrom('info@appedology.com', 'Appedology');
                $mail->addAddress($employee->email,$employee->first_name.' '.$employee->last_name);
                $mail->isHTML(true);                                  // Set email format to HTML
                $mail->Subject = 'Job Offer Letter';
                $mail->Body = "Dear ".$employee->first_name.' '.$employee->last_name.", <br>Please find attachment<br> Thanks";   
                $mail->AddAttachment($pdfFilePath); 
                $sendStatus =$mail->send();
                if(file_exists($pdfFilePath))
                {
                    unlink($pdfFilePath);
                }
		    }
		    
			$postData = [
				'can_id' 	     => $this->input->post('can_id',true),
				'employee_id' 	 => $employee_id,
				'pos_id' 	     => $this->input->post('pos_id',true),
				'selection_terms'=> $this->input->post('selection_terms',true),
			];   

				$coa = $this->Selection_model->headcode();
			if($coa->HeadCode!=NULL){
				$headcode=$coa->HeadCode+1;
			}else{
				$headcode="502020000001";
			}

			$c_code = $employee_id;
			$c_name = $employee->first_name.$employee->last_name;
			$c_acc=$c_code.'-'.$c_name;
			$createby = $this->session->userdata('fullname');
			$createdate = date('Y-m-d H:i:s');
			$data['aco']  = (Object) $coaData = [
				'HeadCode'         => $headcode,
				'HeadName'         => $c_acc,
				'PHeadName'        => 'Account Payable',
				'HeadLevel'        => '2',
				'IsActive'         => '1',
				'IsTransaction'    => '1',
				'IsGL'             => '0',
				'HeadType'         => 'L',
				'IsBudget'         => '0',
				'IsDepreciation'   => '0',
				'DepreciationRate' => '0',
				'CreateBy'         => $createby,
				'CreateDate'       => $createdate,
			];
			$Data1 = [
				'employee_id'                => $employee_id,
				'pos_id' 	                 => $this->input->post('pos_id',true),
				'first_name' 	             => $employee->first_name,
				'last_name' 	             => $employee->last_name,
				'email'                      => $employee->email,
				'phone'                      => $employee->phone,
				'alter_phone' 	             => $employee->alter_phone,
				'present_address' 	         => $employee->present_address,
				'parmanent_address' 	     => $employee->parmanent_address,
				'picture'                    => $employee->picture,
				'state'                      => $employee->state,
			    'city'                       => $employee->city,
			     'zip'                       => $employee->zip
			];  
           if($this->Selection_model->selection_create($postData)){
			    $this->Selection_model->insert_employee($Data1);
			    $this->Selection_model->create_coa($coaData);
				$this->session->set_flashdata('message', display('successfully_saved'));
			
			redirect("recruitment/Candidate_select/create_selection");
		}else{
		   $this->session->set_flashdata('exception', display('please_try_again'));
			redirect("recruitment/Candidate_select/create_selection");	
		}
		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "selection_form"; 
			$data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
			$data['selected'] = $this->Selection_model->selected(); 
			$data['selection'] = $this->Selection_model->viewSelection();
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	public function delete_selection($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Selection_model->selection_delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("recruitment/Candidate_select/candidate_selection_view");
	}

       public function update_selection_form($id = null){
		   redirect();
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('pos_id',display('pos_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('selection_terms',display('selection_terms'),'max_length[100]');
		$employee = $this->db->select('*')->from('candidate_basic_info')->where('can_id',$id)->get()->row();
		$employee_id = $this->input->post('employee_id',true);
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_sel_id' 	             => $this->input->post('can_sel_id',true),
				'can_id' 	                 => $this->input->post('can_id',true),
				'employee_id' 	             => $employee_id,
				'pos_id' 		             => $this->input->post('pos_id',true),
				'selection_terms' 		     => $this->input->post('selection_terms',true),
			]; 

			$Data1 = [
				'employee_id'                => $employee_id,
				'pos_id' 	                 => $this->input->post('pos_id',true),
				'first_name' 	             => $employee->first_name,
				'last_name' 	             => $employee->last_name,
				'email'                      => $employee->email,
				'phone'                      => $employee->phone,
				'alter_phone' 	             => $employee->alter_phone,
				'present_address' 	         => $employee->present_address,
				'parmanent_address' 	     => $employee->parmanent_address,
				'picture'                    => $employee->picture,
				'state'                      => $employee->state,
			    'city'                       => $employee->city,
			     'zip'                       => $employee->zip
			];  
			// print_r($Data1);
			// exit; 
			
			
			if ($this->Selection_model->update_selection($postData)) { 
				$this->db->where('employee_id', $employee_id)
			  ->update("employee_history", $Data1);
				$this->session->set_flashdata('message', display('successfully_updated'));
				redirect("recruitment/Candidate_select/candidate_selection_view");
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
				redirect("recruitment/Candidate_select/update_selection_form/". $id);
			}
			

		} else {
			$data['title']  = display('update');
		    $data['data']   = $this->Selection_model->selection_updateForm($id);
		    $data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
			$data['module'] = "recruitment";
			$data['page']   = "update_selection_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
	
	public function candidate_background_check(){
	    redirect();
	    $this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
	    

		#-------------------------------#
		if ($this->form_validation->run() === true) {
		    
            $employee = $this->db->select('*')->from('candidate_background_check')->where('can_id',$this->input->post('can_id'))->get()->row();
            
           
    		$postData = [
    			'can_id'          => $this->input->post('can_id'),
    			'last_employer' 	  => $this->input->post('last_employer'),
    			'phone' =>       $this->input->post('phone'),
    			'behavior' 	  => $this->input->post('behavior'),
    			'punctuality' 	  => $this->input->post('punctuality'),
    			'performance' 	  => $this->input->post('performance'),
    			'remarks' 	  => $this->input->post('remarks'),
    			'background_status' 	  => $this->input->post('background_status'),
    			'verified_by' 	  => $this->session->userdata('id')
    			
    		]; 
			
			
			if ($employee) { 
			    
				$this->db->where('can_id', $employee->can_id)
			     ->update("candidate_background_check", $postData);
				
			} else {
				$this->activity->set_candidate($this->input->post('can_id'))->log('background_check_inserted');
			    $this->db->insert("candidate_background_check", $postData);
			}
			
            $this->session->set_flashdata('message', display('successfully_updated'));
			redirect("recruitment/Candidate_select/create_selection");
		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "selection_form"; 
			$data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
			$data['selected'] = $this->Selection_model->selected(); 
			$data['selection'] = $this->Selection_model->viewSelection();
			echo Modules::run('template/layout', $data);   
		}
	}


	   public function randID()
    {
        $result = ""; 
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

        $charArray = str_split($chars);
        for($i = 0; $i < 7; $i++) {
                $randItem = array_rand($charArray);
                $result .="".$charArray[$randItem];
        }
        return "E".$result;
    }

	public function interviews_scheduled()
	{
		$this->permission->module('interviews_scheduled','read')->redirect();

        $this->load->model('employee/Employees_model');
		$data['title']    = 'Process Interviews';
		$data['caninfo'] = $this->Selection_model->pending_interviews();
		$data['module'] = "recruitment";
		$data['page']   = "interviews_scheduled";   
		echo Modules::run('template/layout', $data); 
	}

	public function interview_form()
	{
		if($this->input->post('can_short_id')){
			$rec = $this->Selection_model->interview_form_data($this->input->post('can_short_id'));
			if($rec){
				$data['data'] = $rec;
				sendJson(['success' => $this->load->view('interview_form_partial', $data, true)]);
			}
		}
		sendJson(['error' => 'Invalid request']);
	}
}
