<style>
.panel-body .row {
    margin-top: 5px;
}

.label-test-status {
    font-size: 12px;
    font-weight: normal;
}

.label-test-status.label-success {
    background-color: green;
    border-color: green;
}

form div.error {
    color: red;
}
</style>
<div class="container-fluid">
    <div class="row">
        <div class="panel panel-info">
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-3">
                        <?= display('title') ?>:
                    </div>
                    <div class="col-md-5">
                        <?= $question->label ?>
                    </div>
                    <div class="col-md-2 text-right">
                        <?= display(['due', 'date']) ?>:
                    </div>
                    <div class="col-md-2">
                        <?= formatted_date($question->due_date) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= display(['quiz', 'name']) ?>:
                    </div>
                    <div class="col-md-5">
                        <?= $question->title ?>
                    </div>
                    <div class="col-md-2 text-right">
                        <?= display(['auto', 'send', 'results']) ?>:
                    </div>
                    <div class="col-md-2">
                        <?= slug_to_readable($question->{'autorelease-score'}) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= display(['total', 'marks']) ?>:
                    </div>
                    <div class="col-md-9">
                        <?= $question->totalScore ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= display(['passing', 'percentage']) ?>:
                    </div>
                    <div class="col-md-9">
                        <?= $question->passing_perc ?>%
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= display(['created', 'at']) ?>:
                    </div>
                    <div class="col-md-9">
                        <?= formatted_date($question->added_at, true) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= 'Google ' . display(['form', 'modified', 'at']) ?>:
                    </div>
                    <div class="col-md-9">
                        <?= formatted_date($question->modifiedTime, true) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= display('link') ?>:
                    </div>
                    <div class="col-md-7">
                        <a target="_blank" href="<?= $question->link ?>">Google Form Link</a>
                    </div>
                    <?php if($question->{'autorelease-score'} == 'no' && $this->permission->method('all_quiz', 'update')->access()) :?>
                    <div class="col-md-2">
                        <a class="btn btn-primary btn-block btn-sendmail" data-id="all" href="#" role="button"><i
                                class="fa fa-paper-plane" aria-hidden="true"></i>
                            <?= display(['send', 'results']) ?></a>
                    </div>
                    <?php endif?>
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <?= display('description') ?>:
                    </div>
                    <div class="col-md-7">
                        <p><?= $question->description ?></p>
                    </div>
                    <?php if($this->permission->method('all_quiz', 'update')->access()) :?>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-primary btn-block" data-toggle="modal"
                            data-target="#modelEdit"><i class="fa fa-pencil" aria-hidden="true"></i>
                            <?= display('edit') ?></button>
                    </div>
                    <?php endif?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <ul class="nav nav-tabs">
            <li data-toggle="tab" data-target="#questions" class="active"><a
                    href="#questions"><?= display('questions') ?></a></li>
            <li data-toggle="tab" data-target="#employees" class=""><a href="#employees"><?= display('employees') ?></a>
            </li>
            <li data-toggle="tab" data-target="#emails" class=""><a href="#emails"><?= display('email_log') ?></a></li>
            <li data-toggle="tab" data-target="#deleted-employees" class="pull-right"><a href="#deleted-employees"><i
                        class="fa fa-trash" aria-hidden="true"></i> <?= display(['deleted', 'employees']) ?></a></li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade in active" id="questions">
                <div class="panel panel-info">
                    <div class="panel-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?= display(['Question']) ?></th>
                                    <th><?= display(['Marks']) ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($question->questions as $key => $child_q) : ?>
                                <tr>
                                    <td><?= $key + 1 ?></td>
                                    <td><?= $child_q->title ?></td>
                                    <td><?= $child_q->pointValue ?></td>
                                </tr>
                                <?php endforeach?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="employees">
                <div class="panel panel-info">
                    <div class="panel-body">
                        <div class="container-fluid">
                            <?php if($this->permission->method('all_quiz', 'read')->access()): ?>
                            <div class="row">
                                <div class="form-group">
                                    <label for="add_employee"
                                        class="col-sm-2 control-label"><?= display(['Add', 'employee']) ?>:</label>
                                    <div class="col-sm-8">
                                        <select id="add_employee" class="form-control">
                                            <option value="">select one</option>
                                            <?php foreach ($employees as $group => $recs) :?>
                                            <optgroup label="<?= display($group) ?>">
                                                <?php foreach ($recs as $rec) :?>
                                                <option value="<?= $rec->employee_id ?>">
                                                    <?= sprintf('%s (%s) (%s)', $rec->full_name, $rec->pseudo ? $rec->pseudo : 'Not Assigned', $rec->hrm_id) ?>
                                                </option>
                                                <?php endforeach?>
                                            </optgroup>
                                            <?php endforeach?>
                                        </select>
                                    </div>
                                    <div class="col-sm-2">
                                        <button type="button" class="btn btn-primary btn-add-employee">Add</button>
                                    </div>
                                </div>
                            </div>
                            <?php endif?>
                            <div class="row">
                                <table class="table table-employees" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th><?= display(['Name']) ?></th>
                                            <th><?= display(['Email']) ?></th>
                                            <th><?= display(['Pseudo']) ?></th>
                                            <th><?= display(['Obtained', 'Marks']) ?></th>
                                            <th><?= display(['Obtained', 'Percentage']) ?></th>
                                            <th><?= display('status') ?></th>
                                            <th><?= display(['Attempted', 'At']) ?></th>
                                            <?php if($question->{'autorelease-score'} == 'no') :?>
                                            <th><?= display(['result', 'mail']) ?></th>
                                            <?php endif?>
                                            <th class="hideexport"><?= display('action') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="emails">
                <div class="panel panel-info">
                    <div class="panel-body">
                        <table width="100%" class="table table-hover table-email-logs">
                            <thead>
                                <tr>
                                    <th>Subject</th>
                                    <th>To</th>
                                    <th>Retries</th>
                                    <th>Last Tried Sending</th>
                                    <th>Status</th>
                                    <th class="hideexport">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="deleted-employees">
                <div class="panel panel-info">
                    <div class="panel-body">
                        <table class="table table-deleted-employees" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th><?= display(['Name']) ?></th>
                                    <th><?= display(['Email']) ?></th>
                                    <th><?= display(['Pseudo']) ?></th>
                                    <th><?= display('status') ?></th>
                                    <th><?= display(['Attempted', 'At']) ?></th>
                                    <?php if($question->{'autorelease-score'} == 'no') :?>
                                    <th><?= display(['result', 'mail']) ?></th>
                                    <?php endif?>
                                    <th><?= display(['deleted', 'on']) ?></th>
                                    <th class="hideexport"><?= display('action') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    $('.flatpickr').flatpickr({
        dateFormat: 'd-m-Y',
        minDate: 'today'
    })
    window.dtable_employees = $('table.table-employees').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                url: "<?= base_url() ?>quiz/employeeTable/<?= $question->id ?>",
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                    'data': 'full_name',
                }, {
                    'data': 'business_email',
                }, {
                    'data': 'pseudo',
                }, {
                    'data': 'totalScore',
                }, {
                    'data': 'obtained_percentage',
                }, {
                    'data': 'status',
                }, {
                    'data': 'submittedAt',
                },
                <?php if($question->{'autorelease-score'} == 'no'): ?> {
                    'data': 'resultSent',
                },
                <?php endif ?> {
                    'data': 'action',
                    'sortable': false
                },
            ],
            order: [
                [0, 'asc']
            ]
        }
    ))
    window.dtable_employees_deleted = $('table.table-deleted-employees').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                url: "<?= base_url() ?>quiz/employeeTable/<?= $question->id ?>/deleted",
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                    'data': 'full_name',
                }, {
                    'data': 'business_email',
                }, {
                    'data': 'pseudo',
                }, {
                    'data': 'status',
                }, {
                    'data': 'submittedAt',
                },
                <?php if($question->{'autorelease-score'} == 'no'): ?> {
                    'data': 'resultSent',
                },
                <?php endif ?> {
                    'data': 'deletedAt',
                }, {
                    'data': 'action',
                    'sortable': false
                },
            ],
            order: [
                [0, 'asc']
            ]
        }
    ))
    window.dtable = $('table.table-email-logs').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                url: "<?= base_url() ?>quiz/email/log/<?= $question->id ?>",
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                    'data': 'subject',
                }, {
                    'data': 'full_name',
                },
                {
                    'data': 'total_retries'
                },
                {
                    'data': 'updated_at',
                }, {
                    'data': 'status',
                },
                {
                    'data': 'action',
                    'sortable': false
                },
            ],
            order: [
                [0, 'desc']
            ]
        }
    ))
    $('button.btn-add-employee').on('click', function(e) {
        e.preventDefault();
        let $sel = $('select#add_employee');
        if (!$sel.val()) {
            Swal.fire(
                '<?= display('error') ?>!',
                '<?= display(['Please', 'select', 'an', 'employee', 'to', 'proceed'], true) ?>',
                'error'
            )
            return;
        }
        myajax({
            type: "POST",
            url: "<?= base_url() ?>quiz/quiz_employee/add",
            data: {
                'employee_id': $sel.val(),
                'form_id': '<?= $question->id ?>'
            },
            success: function(res) {
                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    ).then(() => {
                        $sel.val('').trigger('change')
                        window.dtable_employees.ajax.reload()
                        if (res.restored) {
                            window.dtable_employees_deleted.ajax.reload()
                        } else {
                            window.dtable.ajax.reload();
                        }
                    })
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error ?? 'invalid response from server',
                        'error'
                    )
                }
            }
        });
    });
    $('table.table-employees').on('click', '.btn-marksheet', function(e) {
        e.preventDefault();
        let $btn = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url() ?>quiz/getAnswerSheet",
            data: {
                'form_employee_id': $btn.data('id')
            },
            success: function(res) {
                if (res.success) {
                    $modal = $('#modalMarksheet');
                    $modal.find('.modal-body').html(res.success);
                    $modal.modal('show')
                } else {
                    alert(res.error ?? 'invalid response from server');
                }
            }
        });
    })
    $('table.table-employees').on('click', '.btn-delete', function(e) {
        e.preventDefault();
        let $btn = $(this)
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove this record of <strong>${$btn.data('name')}</strong> from quiz.`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, remove it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>quiz/quiz_employee/delete",
                    data: {
                        'form_employee_id': $btn.data('id')
                    },
                    success: function(res) {
                        if (res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            ).then(() => {
                                window.dtable_employees.ajax.reload()
                                window.dtable_employees_deleted.ajax
                                    .reload()
                            })
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error ??
                                '<?= display('invalid_response') ?>',
                                'error'
                            ).then(() => {
                                window.dtable_employees.ajax.reload()
                                window.dtable_employees_deleted.ajax
                                    .reload()
                            })
                        }
                    }
                });
            }
        })
    })
    $('table.table-deleted-employees').on('click', '.btn-undelete', function(e) {
        e.preventDefault();
        let $btn = $(this)
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will restore this record of <strong>${$btn.data('name')}</strong> to quiz.`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, restore it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>quiz/quiz_employee/restore",
                    data: {
                        'form_employee_id': $btn.data('id')
                    },
                    success: function(res) {
                        if (res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            ).then(() => {
                                window.dtable_employees.ajax.reload()
                                window.dtable_employees_deleted.ajax
                                    .reload()
                            })
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error ??
                                '<?= display('invalid_response') ?>',
                                'error'
                            ).then(() => {
                                window.dtable_employees.ajax.reload()
                                window.dtable_employees_deleted.ajax
                                    .reload()
                            })
                        }
                    }
                });
            }
        })
    })
    $('#modelEdit form').on('submit', function(e) {
        e.preventDefault()
        let $form = $(this)
        myajax({
            type: "POST",
            data: $form.serialize(),
            beforeSend: function() {
                $form.find('div.error').remove()
            },
            success: function(res) {
                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    ).then(() => {
                        location.reload()
                    })
                } else if (res.errors) {
                    res.errors.forEach(err => {
                        $form.find(`[name=${err[0]}]`).closest('div.form-group')
                            .append(
                                `<div class="error">${err[1]}</div>`)
                    });
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error ?? '<?= display('invalid_response') ?>',
                        'error'
                    )
                }
            }
        });
    })
    $(document).on('click', '.btn-sendmail', function(e) {
        e.preventDefault();
        let $btn = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will send result email to <strong>${$btn.data('name')}</strong>`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, send it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>quiz/sendResultEmails/<?= $question->id ?>",
                    data: {
                        'employee_id': $btn.data('id')
                    },
                    success: function(res) {
                        if (res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            ).then(() => {
                                window.dtable_employees.ajax.reload()
                            })
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error ??
                                '<?= display('invalid_response') ?>',
                                'error'
                            ).then(() => {
                                window.dtable_employees.ajax.reload()
                            })
                        }
                    }
                });
            }
        })
    })
});
</script>
<!-- Modal -->
<div class="modal fade" id="modalMarksheet" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?= display(['employee', 'answer', 'sheet']) ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modelEdit" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form action="#" method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?= display('edit') ?> <?= $question->label ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="txtTitle"><?= display('title') ?></label>
                        <input type="text" class="form-control" name="title" id="txtTitle"
                            value="<?= $question->label ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="passing_perc"
                            class="col-form-label"><?= display(['Passing', 'Percentage']) ?></label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="passing_perc" id="passing_perc"
                                value="<?= $question->passing_perc ?>" style="border-radius: 0px !important">
                            <span class="input-group-addon">%</span>
                        </div>
                    </div>
                    <?php if(strtotime($question->due_date) >= time()): ?>
                    <div class="form-group">
                        <label for="due_date" class="col-form-label"><?= display(['Due', 'Date']) ?></label>
                        <input type="text" class="form-control flatpickr" name="due_date" id="due_date"
                            value="<?= formatted_date($question->due_date) ?>">
                    </div>
                    <?php endif?>
                    <div class="form-group">
                        <label for="autorelease-score"
                            class="col-form-label"><?= display(['Auto', 'Send', 'Results']) ?></label>
                        <select name="autorelease-score" id="autorelease-score" class="form-control dont-select-me"
                            required="required">
                            <option value="1" <?= $question->{'autorelease-score'} == 'yes' ? 'selected' : null ?>>
                                <?= display('yes') ?></option>
                            <option value="0" <?= $question->{'autorelease-score'} == 'no' ? 'selected' : null ?>>
                                <?= display('no') ?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $this->load->view('quiz/email_logs_scripts') ?>