<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Quiz extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'quiz_model',
        ]);
        if (!$this->input->is_ajax_request()
            && !in_array($this->router->method, ['settings', 'login', 'mail_login', 'logout', 'mail_logout'])
            && (!$this->quiz_model->googleClient->auth() || !$this->quiz_model->mailClient->auth())) {
            $this->session->set_flashdata('exception', display(['one', 'or', 'more', 'accounts', 'is', 'logged', 'out'], true) . '. ' . display(['please', 'login', 'to', 'proceed'], true));
            redirect('quiz/settings');
        }
    }
    public function create()
    {
        $this->permission->method('create_quiz', 'create')->redirect();
        if ($this->input->post()) {
            return $this->create_post();
        }
        $employee_recs = $this->quiz_model->getEmployees();
        $new_recs = [];
        $year_recs = [];
        $month_recs = [];
        $fresh_recs = [];
        foreach ($employee_recs as $employee) {
            if ($employee->tenure > 0) {
                if (!isset($year_recs[$employee->tenure])) {
                    $year_recs[$employee->tenure] = [];
                }
                $year_recs[$employee->tenure][] = $employee;
                continue;
            } else {
                if ($employee->tenure_in_months > 0) {
                    if (!isset($month_recs[$employee->tenure_in_months])) {
                        $month_recs[$employee->tenure_in_months] = [];
                    }
                    $month_recs[$employee->tenure_in_months][] = $employee;
                    continue;
                } else {
                    $fresh_recs[] = $employee;
                    continue;
                }
            }
        }
        krsort($month_recs);
        krsort($year_recs);
        foreach ($year_recs as $key => $emp_collection) {
            $new_recs[$key . ' year' . ($key == 1 ? null : 's')] = $emp_collection;
        }
        foreach ($month_recs as $key => $emp_collection) {
            $new_recs[$key . ' month' . ($key == 1 ? null : 's')] = $emp_collection;
        }
        $new_recs['Fresh'] = $fresh_recs;
        $data['employees_tenure_wise'] = $new_recs;
        $employee_recs = $this->quiz_model->getManagers();
        $new_recs = [];
        $year_recs = [];
        $month_recs = [];
        $fresh_recs = [];
        foreach ($employee_recs as $employee) {
            if ($employee->tenure > 0) {
                if (!isset($year_recs[$employee->tenure])) {
                    $year_recs[$employee->tenure] = [];
                }
                $year_recs[$employee->tenure][] = $employee;
                continue;
            } else {
                if ($employee->tenure_in_months > 0) {
                    if (!isset($month_recs[$employee->tenure_in_months])) {
                        $month_recs[$employee->tenure_in_months] = [];
                    }
                    $month_recs[$employee->tenure_in_months][] = $employee;
                    continue;
                } else {
                    $fresh_recs[] = $employee;
                    continue;
                }
            }
        }
        krsort($month_recs);
        krsort($year_recs);
        foreach ($year_recs as $key => $emp_collection) {
            $new_recs[$key . ' year' . ($key == 1 ? null : 's')] = $emp_collection;
        }
        foreach ($month_recs as $key => $emp_collection) {
            $new_recs[$key . ' month' . ($key == 1 ? null : 's')] = $emp_collection;
        }
        $new_recs['Fresh'] = $fresh_recs;
        $data['managers_tenure_wise'] = $new_recs;
        $data['quizzes'] = $this->quiz_model->getQuizList();
        $data['title'] = display(['create', 'quiz']);
        $data['page'] = 'create';
        $data['module'] = 'quiz';
        echo Modules::run('template/layout', $data);
    }
    private function create_post()
    {
        $rules_config = array(
            array(
                'field' => 'quiz_id',
                'label' => display('quiz'),
                'rules' => 'required',
            ),
            array(
                'field' => 'label',
                'label' => display('label'),
                'rules' => 'required|max_length[255]',
            ),
            array(
                'field' => 'due_date',
                'label' => display(['due', 'date']),
                'rules' => 'required',
            ),
            array(
                'field' => 'passing_perc',
                'label' => display(['passing', 'percentage']),
                'rules' => 'required|greater_than_equal_to[10]|less_than_equal_to[100]',
            ),
            array(
                'field' => 'emps[]',
                'label' => display('employees'),
                'rules' => 'required',
            ),
            array(
                'field' => 'subject',
                'label' => display('subject'),
                'rules' => 'required',
            ),
            array(
                'field' => 'body',
                'label' => display('body'),
                'rules' => 'required',
            ),
            array(
                'field' => 'send',
                'label' => display(['send', 'now']),
                'rules' => 'required|in_list[now,later]',
            ),
            array(
                'field' => 'autorelease-score',
                'label' => display(['Auto', 'Send', 'Results']),
                'rules' => 'required|in_list[0,1]',
            ),
        );
        if (!empty(trim($this->input->post('bcc')))) {
            $rules_config[] = [
                'field' => 'bcc',
                'label' => 'BCC',
                'rules' => 'valid_emails',
            ];
        }
        if ($this->input->post('send') == 'later') {
            $rules_config[] = array(
                'field' => 'email_scheduled',
                'label' => display('schedule_email'),
                'rules' => 'required',
            );
        }
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            $fields = array_column($rules_config, 'field');
            foreach ($fields as $field) {
                if ($err = form_error($field)) {
                    return sendJson(['error' => $err]);
                }
                if ($field == 'due_date' && strtotime(date('Y-m-d')) < strtotime($this->input->post('due_date'))) {
                    return sendJson(['error' => display(['due_date', 'must', 'be', 'a', 'date', 'in', 'future'])]);
                }
            }
        }
        if ($this->quiz_model->addQuiz($this->input->post())) {
            return sendJson(['success' => display(['quiz', 'saved', 'successfully']), 'redirect' => base_url('quiz/all')]);
        }
        return sendJson(['error' => display(['unable', 'to', 'save', 'quiz'])]);
    }
    public function settings()
    {
        $this->permission->method('quiz_settings', 'read')->redirect();
        if ($this->input->post()) {
            if (!$this->permission->method('quiz_settings', 'update')->access()) {
                $this->session->set_flashdata('exception', display(['you', 'are', 'not', 'authorized', 'to', 'perform', 'this', 'action']));
                redirect($_SERVER['HTTP_REFERER']);
            }
            $departments = $this->input->post('departments');
            $departments = implode(',', $departments);
            $this->options->set_system('system.quiz.departments', $departments);
            $this->options->set_system('system.quiz.warning_letter', $this->input->post('warning_letter'));
            $this->activity->log('quiz_settings_updated');
            $this->session->set_flashdata('success', display(['quiz', 'settings', 'saved', 'successfully']));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['letters'] = $this->db->select('id, title')->get('letters')->result();
        $data['selected_letter'] = $this->options->get_system('system.quiz.warning_letter');
        $data['departments'] = $this->db->select('dept_id as id, department_name as name')->order_by('department_name', 'asc')->get('department')->result();
        $data['selected_departments'] = explode(',', $this->options->get_system('system.quiz.departments'));
        $data['authenticated'] = $is_auth = $this->quiz_model->googleClient->auth();
        $data['mail_authenticated'] = $is_mailAuth = $this->quiz_model->mailClient->auth();
        if ($is_auth) {
            $data['account_name'] = $this->quiz_model->googleClient->userinfo()->getName();
            $data['account_email'] = $this->quiz_model->googleClient->userinfo()->getEmail();
        }
        if ($is_mailAuth) {
            $data['mail_account_name'] = $this->quiz_model->mailClient->userinfo()->getName();
            $data['mail_account_email'] = $this->quiz_model->mailClient->userinfo()->getEmail();
        }

        $data['title'] = display(['quiz', 'settings']);
        $data['page'] = 'settings';
        $data['module'] = 'quiz';
        echo Modules::run('template/layout', $data);
    }
    public function details($id)
    {
        $this->permission->method('all_quiz', 'read')->redirect();
        if ($this->input->post()) {
            if (!$this->permission->method('all_quiz', 'update')->access()) {
                return sendJson(['error' => display(['not', 'authorized', 'to', 'perform', 'this', 'action'])]);
            }

            $rules_config = array(
                array(
                    'field' => 'title',
                    'label' => display('title'),
                    'rules' => 'required|max_length[255]',
                ),
                array(
                    'field' => 'due_date',
                    'label' => display(['due', 'date']),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'passing_perc',
                    'label' => display(['passing', 'percentage']),
                    'rules' => 'required|greater_than_equal_to[10]|less_than_equal_to[100]',
                ),
                array(
                    'field' => 'autorelease-score',
                    'label' => display(['Auto', 'Send', 'Results']),
                    'rules' => 'required|in_list[0,1]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $fields = array_column($rules_config, 'field');
                $errors = [];
                foreach ($fields as $field) {
                    if ($err = form_error($field)) {
                        $errors[] = [$field, $err];
                    }
                }
                return sendJson(['errors' => $errors]);
            }
            if ($this->quiz_model->editQuiz($id, $this->input->post())) {
                return sendJson(['success' => display(['quiz', 'details', 'are', 'updated'])]);
            }
            return sendJson(['error' => display(['unable', 'to', 'update', 'quiz', 'details'])]);
        }
        $data['question'] = $quiz = $this->quiz_model->getQuizDetails($id);
        if (!$quiz) {
            show_404();
        }
        $data['employees'] = [];
        $data['employees']['employees'] = $this->quiz_model->getEmployees();
        $data['employees']['managers'] = $this->quiz_model->getManagers();
        $data['title'] = addslashes($quiz->title);
        $data['page'] = 'detail';
        $data['module'] = 'quiz';
        echo Modules::run('template/layout', $data);
    }
    public function all()
    {
        $this->permission->method('all_quiz', 'read')->redirect();
        if ($this->input->post()) {
            return $this->listDatatable();
        }
        $data['title'] = display('all_quiz');
        $data['page'] = 'list';
        $data['module'] = 'quiz';
        echo Modules::run('template/layout', $data);
    }
    public function link($form_id)
    {
        $link = $this->quiz_model->obtainLink($form_id);
        if (!$link) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        redirect($link);
    }
    public function open()
    {
        $this->permission->method('open_quiz', 'read')->redirect();
        $data['quizzes'] = $this->quiz_model->getOpenQuizEmployee();
        $data['title'] = display('open_quiz');
        $data['page'] = 'open';
        $data['module'] = 'quiz';
        echo Modules::run('template/layout', $data);
    }
    private function listDatatable()
    {
        $search_arr = [];
        $search_columns = [
            'id',
            'title',
            'passing_perc',
            "DATE_FORMAT(`due_date`, '%d-%m-%Y')",
            "DATE_FORMAT(`added_at`, '%d-%m-%Y')",
            "DATE_FORMAT(`modifiedTime`, '%d-%m-%Y')",
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->quiz_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->quiz_model->countDatatable($search_arr);
        $rows = $this->quiz_model->getDatatable($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'link':{
                            $tdData = '<a class="btn btn-primary" target="_blank" href="' . $rec[$col['data']] . '" role="button"><i class="fa fa-link" aria-hidden="true"></i></a>';
                            break;
                        }
                    case 'due_date':{
                            $tdData = formatted_date($rec[$col['data']]);
                            break;
                        }
                    case 'added_at':
                    case 'modifiedTime':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'passing_perc':{
                            $tdData = $rec[$col['data']] . '%';
                            break;
                        }
                    case 'action':{
                            if (is_null($rec['modifiedTime'])) {
                                $tdData = '<div class="table-quiz-loader">Loading...</div>';
                            } else {
                                $btns = [];
                                $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                                $btns[] = '<li><a href="' . base_url('quiz/details/') . $rec['id'] . '" >View Details</a></li>';
                                if ($this->permission->method('all_quiz', 'delete')->access()) {
                                    $btns[] = '<li><a href="#" class="btn-delete" data-name="' . addslashes($rec['title']) . '" data-id="' . $rec['id'] . '">Delete Quiz</a></li>';
                                }

                                $tdData .= implode('', $btns);
                                $tdData .= '</ul></div>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function employeeTable($id, $type = null)
    {
        $this->load->model('quiz_employee_model');
        $search_arr = [];
        $search_columns = [
            'hrm_id',
            'full_name',
            'business_email',
            'pseudo',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->quiz_employee_model->countAllRows($id, $type == 'deleted');
        $out_arr["recordsFiltered"] = $this->quiz_employee_model->countDatatable($id, $search_arr, $type == 'deleted');
        $rows = $this->quiz_employee_model->getDatatable($id, $this->input->post(), $search_arr, $type == 'deleted');

        $label_classes = [
            'not-attempted' => 'primary',
            'passed' => 'success',
            'failed' => 'danger',
            'retake-needed' => 'danger',
        ];
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'full_name':{
                            $tdData = sprintf('%s (%s)', $rec[$col['data']], $rec['hrm_id']);
                            break;
                        }
                    case 'obtained_percentage':{
                            if (!$rec['submittedAt']) {
                                $tdData = '';
                                break;
                            }
                            $tdData = sprintf('%g%%', round($rec[$col['data']], 2));
                            break;
                        }
                    case 'submittedAt':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'status':{
                            if ($rec[$col['data']] == 'failed') {
                                $rec[$col['data']] = 'retake-needed';
                            }
                            $tdData = '<span class="label label-test-status label-' . $label_classes[$rec[$col['data']]] . '">' . slug_to_readable($rec[$col['data']]) . '</span>';
                            break;
                        }
                    case 'action':{
                            $btns = [];
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            if ($type != 'deleted') {
                                if ($rec['submittedAt']) {
                                    $btns[] = '<li><a href="#" class="btn-marksheet" data-id="' . $rec['form_employee_id'] . '">View Answer Sheet</a></li>';
                                    if ($rec['autorelease-score'] == 'no' && $rec['resultSent'] == 'held' && $this->permission->method('all_quiz', 'update')->access()) {
                                        $btns[] = '<li><a href="#" class="btn-sendmail" data-name="' . addslashes($rec['full_name']) . '" data-id="' . $rec['form_employee_id'] . '">Send Result</a></li>';
                                    }
                                }
                                if ($this->permission->method('all_quiz', 'delete')->access()) {
                                    if (count($btns) > 0) {
                                        $btns[] = '<li role="separator" class="divider"></li>';
                                    }
                                    $btns[] = '<li><a href="#" class="btn-delete" data-name="' . addslashes($rec['full_name']) . '" data-id="' . $rec['form_employee_id'] . '">Remove Employee</a></li>';
                                }
                            } else {
                                if ($this->permission->method('all_quiz', 'delete')->access()) {
                                    if (count($btns) > 0) {
                                        $btns[] = '<li role="separator" class="divider"></li>';
                                    }
                                    $btns[] = '<li><a href="#" class="btn-undelete" data-name="' . addslashes($rec['full_name']) . '" data-id="' . $rec['form_employee_id'] . '">Restore Employee</a></li>';
                                }
                            }
                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    case 'totalScore':{
                            if (!$rec['submittedAt']) {
                                $tdData = '';
                                break;
                            }
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function delete()
    {
        $this->permission->method('all_quiz', 'delete')->redirect();
        if ($this->input->post('id')) {
            if ($this->quiz_model->delete($this->input->post('id'))) {
                return sendJson(['success' => display(['quiz', 'removed', 'successfully'])]);
            }
        }
        return sendJson(['error' => display(['unable', 'to', 'remove', 'quiz'])]) . '. ' . display(['try', 'again']);
    }
    public function login()
    {
        $this->permission->method('quiz_settings', 'update')->redirect();
        if (isset($_GET['code'])) {
            if (!$this->quiz_model->googleClient->saveFromAuthCode($_GET['code'])) {
                $this->session->set_flashdata('exception', display(['Google', 'Authentication', 'failed'], true));
            } else {
                $this->activity->log([
                    'quiz_google_auth',
                    $this->quiz_model->googleClient->userinfo()->getEmail(),
                    'forms',
                ]);
                $this->session->set_flashdata('success', display(['Google', 'Authentication', 'succeeded'], true));
            }
            redirect('quiz/settings');
        }

        if (!$this->quiz_model->googleClient->auth()) {
            redirect($this->quiz_model->googleClient->redirectUri);
        }
    }
    public function mail_login()
    {
        $this->permission->method('quiz_settings', 'update')->redirect();
        if (isset($_GET['code'])) {
            if (!$this->quiz_model->mailClient->saveFromAuthCode($_GET['code'])) {
                $this->session->set_flashdata('exception', display(['Google', 'Authentication', 'failed'], true));
            } else {
                $this->activity->log([
                    'quiz_google_auth',
                    $this->quiz_model->mailClient->userinfo()->getEmail(),
                    'mailing',
                ]);
                $this->session->set_flashdata('success', display(['Google', 'Authentication', 'succeeded'], true));
            }
            redirect('quiz/settings');
        }

        if (!$this->quiz_model->mailClient->auth()) {
            redirect($this->quiz_model->mailClient->redirectUri);
        }
    }
    public function logout()
    {
        $this->permission->method('quiz_settings', 'update')->redirect();
        $email = $this->quiz_model->googleClient->userinfo()->getEmail();
        if ($this->quiz_model->googleClient->unauth()) {
            $this->activity->log([
                'quiz_remove_google_auth',
                $email,
                'forms',
            ]);
            $this->session->set_flashdata('success', display(['Google', 'logout', 'succeeded'], true));
        } else {
            $this->session->set_flashdata('exception', display(['Google', 'logout', 'failed'], true));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function mail_logout()
    {
        $this->permission->method('quiz_settings', 'update')->redirect();
        $email = $this->quiz_model->mailClient->userinfo()->getEmail();
        if ($this->quiz_model->mailClient->unauth()) {
            $this->activity->log([
                'quiz_remove_google_auth',
                $email,
                'mailing',
            ]);
            $this->session->set_flashdata('success', display(['Google', 'logout', 'succeeded'], true));
        } else {
            $this->session->set_flashdata('exception', display(['Google', 'logout', 'failed'], true));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function getComposedEmail()
    {
        $this->permission->method('create_quiz', 'create')->redirect();
        $rules_config = array(
            array(
                'field' => 'quiz_id',
                'label' => display('quiz'),
                'rules' => 'required',
            ),
            array(
                'field' => 'due_date',
                'label' => display(['due', 'date']),
                'rules' => 'required',
            ),
            array(
                'field' => 'passing_perc',
                'label' => display(['passing', 'percentage']),
                'rules' => 'required|greater_than_equal_to[10]|less_than_equal_to[100]',
            ),
            array(
                'field' => 'emps[]',
                'label' => display('employees'),
                'rules' => 'required',
            ),
        );
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            $fields = array_column($rules_config, 'field');
            foreach ($fields as $field) {
                if ($err = form_error($field)) {
                    return sendJson(['error' => $err]);
                }
            }
        }
        $form = $this->quiz_model->getFormDetails($this->input->post('quiz_id'));

        $data = [];
        $data['subject'] = sprintf('Invitation for \'%s\' Certification Quiz', $form->info->documentTitle);
        $data['body'] = $this->load->view('quiz/emails/email_body', [
            'title' => $form->info->documentTitle,
            'quiz_link' => $form->responderUri,
            'due_date' => $this->input->post('due_date'),
        ], true);
        $data['from'] = $this->quiz_model->mailClient->userinfo()->getEmail();

        $employee_recs = $this->quiz_model->getEmployeesById($this->input->post('emps'));
        $to_mails = array_column($employee_recs, 'business_email');
        $to_mails = array_unique(array_filter($to_mails));
        $cc_mails = array_column($employee_recs, 'direct_manager_email');
        $cc_mails = array_unique(array_filter($cc_mails));
        sort($to_mails);
        sort($cc_mails);

        $data['to'] = $to_mails;
        $data['cc'] = $cc_mails;
        $data['bcc'] = [];
        sendJson(['success' => $data]);
    }
    public function getAnswerSheet()
    {
        $this->permission->method('all_quiz', 'read')->redirect();
        if ($this->input->post('form_employee_id')) {
            $emp = $this->db->from('google_quiz_employee_details')->where(['form_employee_id' => $this->input->post('form_employee_id')])->get()->row();
            $recs = $this->quiz_model->getAnswerSheet($this->input->post('form_employee_id'));
            return sendJson(['success' => $this->load->view('quiz/answer_sheet', ['employee' => $emp, 'questions' => $recs], true)]);
        }
        return sendJson(['error' => 'invalid request']);
    }
    public function sendResultEmails($form_id)
    {
        if ($this->input->post('employee_id')) {
            if ($this->quiz_model->sendResultEmails($form_id, $this->input->post('employee_id'))) {
                return sendJson(['success' => display(['result', 'emails', 'sent', 'successfully'])]);
            }
            return sendJson(['error' => display(['unable', 'to', 'send', 'result', 'emails', 'try', 'again'])]);
        }
        return sendJson(['error' => display('invalid_response')]);
    }
}
