<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Email extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'quiz_model',
            'email_model',
        ]);
        if (!$this->quiz_model->googleClient->auth()) {
            redirect('quiz/settings');
        }
    }
    public function log($form_id = null)
    {
        if(!$this->permission->method('email_log', 'read')->access() && !$this->permission->method('all_quiz', 'read')->access()) {
            redirect();
        }
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->getdatatable($form_id);
        }
        $data['title'] = display('email_log');
        $data['module'] = 'quiz';
        $data['page'] = 'email_logs';
        echo Modules::run('template/layout', $data);
    }
    public function requeue()
    {
        if ($this->input->post('ids') && $this->input->is_ajax_request()) {
            if ($this->email_model->requeue($this->input->post('ids'))) {
                sendJson(['success' => 'Emails queued for resending successfully.']);
            } else {
                sendJson(['error' => 'Unable to requeue emails for resending, try again']);
            }
        }
    }
    public function view()
    {
        if ($this->input->post('id') && $this->input->is_ajax_request()) {
            $mail = $this->email_model->get($this->input->post('id'));

            if ($mail) {
                $data['content'] = json_decode($mail->content, true);
                unset($mail->content);
                $data['mail'] = $mail;
                sendJson(['success' => $this->load->view('quiz/email_view', $data, true)]);
            }
            sendJson(['error' => 'Email not found']);
        }
    }
    public function show_error($id)
    {
        $rec = $this->email_model->get($id);
        if ($rec) {
            sendJson(['success' => $rec->error]);
        }
        sendJson(['error' => 'Email not found']);
    }
    private function getdatatable($form_id)
    {
        $search_arr = [];
        $search_columns = [
            'qz_form.title',
            'employee_details.hrm_id',
            'employee_details.full_name',
            'qz_email_queue.id',
            'qz_email_queue.eto',
            'qz_email_queue.subject',
            'qz_email_queue.status',
            'qz_email_queue.retries',
            'DATE_FORMAT(qz_email_queue.updated_at, \'%d-%m-%Y %r\')',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->email_model->countAllRows($form_id);
        $out_arr["recordsFiltered"] = $this->email_model->countDatatable($form_id, $search_arr);
        $rows = $this->email_model->getDatatable($form_id, $search_arr);

        $status_classes = [
            'queued' => 'primary',
            'failed' => 'danger',
            'sent' => 'success',
        ];
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'full_name':{
                            $tdData = sprintf('%s (%s)<br>%s', $rec['full_name'], $rec['hrm_id'], $rec['eto']);
                            break;
                        }
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'status':{
                            $tdData = '<span class="label label-' . $status_classes[$rec[$col['data']]] . '">' . ucfirst($rec[$col['data']]) . '</span>';
                            break;
                        }
                    case 'action':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];

                            $btns[] = '<li><a href="#" class="btn-view" data-id="' . $rec['id'] . '">View Email</a></li>';

                            if ($rec['status'] == 'failed') {
                                $btns[] = '<li><a href="#" class="btn-error" data-id="' . $rec['id'] . '">View Error</a></li>';
                            }
                            if ($this->permission->method('email_logs', 'update')->access() || $this->permission->method('all_quiz', 'update')->access()) {
                                $btns[] = '<li><a href="#" class="btn-requeue" data-id="' . $rec['id'] . '">Resend</a></li>';
                            }

                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
