<link rel="stylesheet" href="<?= base_url('assets/css/payroll-view.css') ?>">
<?php $emp_sno = 0; ?>
<?php $this->fixedTable->left([40, 50, 80, 140], null, '#payroll') ?>
<?php $this->fixedTable->top([0], null, '#payroll') ?>

<?php $this->fixedTable->left([40, 140, 80, 50], null, '#attendance') ?>
<?php $this->fixedTable->top([0], null, '#attendance') ?>

<?php $this->fixedTable->left([40, 140, 80, 50], null, '#leave') ?>
<?php $this->fixedTable->top([0], null, '#leave') ?>
<div id="main">
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#payroll">Payroll</a></li>
        <li><a data-toggle="tab" href="#attendance">Attendance</a></li>
        <li><a data-toggle="tab" href="#leave">Leave Sheet</a></li>
    </ul>

    <div class="tab-content">
        <div id="payroll" class="tab-pane fade in active">
            <div class="container-fluid">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr class="highlight">
                                <th>S.No.</th>
                                <th>Empl.ID</th>
                                <th>Name</th>
                                <th>Center</th>
                                <th>Date of Joining</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <th>Project</th>
                                <th>Total Day in Month</th>
                                <th>Total No of Days Present</th>
                                <th>Total No Days of Suspension</th>
                                <th>Total No Days of Absent / Unpaid Leave</th>
                                <th>Paid Leaves</th>
                                <th>Salary Per Month</th>
                                <th>Basic Per Month</th>
                                <th>Actual Salary As per Attendance</th>
                                <th>Arrears (if any)</th>
                                <th>Advances (if any)</th>
                                <th>Incentives (if any)</th>
                                <th>Gross Salary</th>
                                <th>Income Tax</th>
                                <th>EOBI</th>
                                <th>Penalty on NCNS</th>
                                <th>Other Deductions (if any)</th>
                                <th>Provident Fund</th>
                                <th>Total Deduction</th>
                                <th>Net Salary</th>
                                <th>Title of Account</th>
                                <th>Account Number</th>
                                <th>Account IBAN</th>
                                <th>Branch Address</th>
                                <th>Branch Code</th>
                                <th>CNIC #</th>
                                <th>Net Salary</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($employees as $employee):
                            $emp_sno++;
                            $deductions = 0; 
                            $attendance_salary = round($this->payroll->calculate_attendance_salary($employee, $day_range));
                            $attendance_salary_after_arrears = $attendance_salary + $employee->arrears + $employee->advances + $employee->incentives;

                            $employee->income_tax = calculate_income_tax($attendance_salary_after_arrears);
                            $income_tax = $employee->income_tax;
                            $deductions += $income_tax;
                            $deductions += round($employee->eobi);
                            $deductions += round($employee->ncns_penalty);
                            $deductions += round($employee->others);
                    
                            $provident_fund = round($employee->provident_fund);
                            $deductions += $provident_fund;
                            $net_salary = $attendance_salary_after_arrears - $deductions;
                            if($employee->under_training) {
                                $net_salary = 0;
                            }?>
                            <tr data-id="<?= $employee->employee_id ?>" class="<?= $employee->highlighted ? 'selected-row' : null ?>">
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= $employee->center ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= mb_convert_encoding($employee->project, 'UTF-8') ?></td>
                                <td><?= $day_range ?></td>
                                <td><?= $employee->actual_presents ?></td>
                                <td><?= sprintf('%g', $employee->suspensions) ?></td>
                                <td><?= sprintf('%g', $employee->actual_absents) ?></td>
                                <td><?= sprintf('%g', $employee->paid_leaves + $employee->special_leaves) ?></td>
                                <td><?= number_format($employee->actual_gross_salary)  ?></td>
                                <td><?= number_format($employee->actual_basic_salary) ?></td>
                                <td><?= number_format($attendance_salary) ?></td>
                                <td data-type="arrears"><?= number_format($employee->arrears) ?><?= $employee->arrears > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="advances"><?= number_format($employee->advances) ?><?= $employee->advances > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="incentives"><?= number_format($employee->incentives) ?><?= $employee->incentives > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= number_format($attendance_salary_after_arrears) ?></td>
                                <td><?= number_format($income_tax) ?></td>
                                <td><?= $employee->eobi ?></td>
                                <td data-type="ncns"><?= number_format($employee->ncns_penalty) ?><?= $employee->ncns_penalty > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="others"><?= number_format($employee->others) ?><?= $employee->others > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= number_format($provident_fund) ?></td>
                                <td><?= number_format($deductions); ?></td>
                                <td data-type="net-salary"><?= number_format($net_salary) ?><?= $employee->under_training ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= $employee->account_title ?></td>
                                <td><?= $employee->account_number ?></td>
                                <td><?= @$employee->account_iban ?></td>
                                <td><?= $employee->branch_address ?></td>
                                <td><?= $employee->branch_code ?></td>
                                <td><?= cnic_with_dashes($employee->cnic) ?></td>
                                <td data-type="net-salary"><?= number_format($net_salary) ?><?= $employee->under_training ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                            </tr>
                            <?php endforeach?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="attendance" class="tab-pane fade">
            <?php $emp_sno = 0 ?>
            <div class="container-fluid">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr class="highlight">
                                <th>S.No.</th>
                                <th>Name</th>
                                <th>DOJ</th>
                                <th>Empl.ID</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <?php foreach ($date_array as $date_arr) :?>
                                    <th class="rotate-90"><?= date('D-d-M', strtotime($date_arr)) ?></th>
                                <?php endforeach?>
                                <th>Present</th>
                                <th>Absent</th>
                                <th>Suspension</th>
                                <th>Late Arrivals</th>
                                <th>Unpaid Leave</th>
                                <th>Deducted Days for LA</th>
                                <th>Paid Leave</th>
                                <th>Off</th>
                                <th>Half-Day</th>
                                <th>Total Working Days</th>
                                <th>Average</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($employees as $employee):
                                $emp_sno++;?>
                            <tr>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <?php foreach ($date_array as $date_arr) :?>
                                    <td><?= strtoupper($employee_attendance['e_' . $employee->employee_id][$date_arr])?></td>
                                <?php endforeach?>
                                <td><?= sprintf('%g', $employee->presents) ?></td>
                                <td><?= sprintf('%g', $employee->ncns) ?></td>
                                <td><?= sprintf('%g', $employee->suspensions) ?></td>
                                <td><?= $employee->late_arrivals ?></td>
                                <td><?= sprintf('%g', $employee->unpaid_leaves) ?></td>
                                <td><?= floor($employee->late_arrivals / 3) ?></td>
                                <td><?= sprintf('%g', $employee->paid_leaves + $employee->special_leaves) ?></td>
                                <td><?= sprintf('%g', $employee->offs) ?></td>
                                <td><?= sprintf('%g', $employee->half_days) ?></td>
                                <td><?= $this->payroll->get_paid_days($employee) ?></td>
                                <td><?= round((($employee->presents + $employee->late_arrivals + $employee->offs + $employee->half_days + $employee->unpaid_half_days) / $day_range) * 100) ?>%</td>
                            </tr>
                            <?php endforeach?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="leave" class="tab-pane fade">
            <?php $emp_sno = 0; ?>
            <div class="container-fluid">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr class="highlight">
                                <th>S.No.</th>
                                <th>Name</th>
                                <th>DOJ</th>
                                <th>Empl.ID</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <th>Primary Project</th>
                                <?php foreach ($month_array as $month_arr) :?>
                                    <th class="rotate-90"><?= $month_arr ?></th>
                                <?php endforeach?>
                                <th>Total Leaves</th>
                                <th>Availed</th>
                                <th>Special</th>
                                <th>Remaining</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($employees as $employee):
                                $emp_sno++;
                                $availed_leaves = 0;
                                $availed_special_leaves = 0;?>
                            <tr>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= $employee->project ?></td>
                                <?php foreach ($month_array as $month_arr) :?>
                                    <?php $dleave = $employee_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $sleave = $employee_special_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $availed_special_leaves += $sleave;
                                    $availed_leaves += $dleave ?>
                                    <td><?= $dleave + $sleave ?></td>
                                <?php endforeach?>
                                <td><?= sprintf('%g', $employee->leave_quota) ?></td>
                                <td><?= $availed_leaves ?></td>
                                <td><?= sprintf('%g', $availed_special_leaves) ?></td>
                                <td><?= sprintf('%g', $employee->leave_quota - $availed_leaves) ?></td>
                            </tr>
                            <?php endforeach?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {  
        tippy('td .remarks', {
            content: 'loading...',
            interactive: true,
            arrow: true,
            onShow(instance) {
                var target = instance.reference.parentNode
                var row = $(target).parent('tr').data('id');
                var column = $(target).data('type');
                $.ajax({
                    type: "GET",
                    url: "<?= base_url() ?>payroll/payroll/remarks",
                    beforeSend: () => {},
                    data: {
                        payroll: '<?= $payroll->id ?>',
                        row: row,
                        column: column,
                    },
                    success: function (res) {
                        instance.setContent(res);return
                        if(res.success) {
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            },
        })
        function checkOffset() {
            if ($(".navbar").offset().top > 50) {
                $(".main-header").hide();
                $('.dtfc-right-top-blocker').show()
            }     
            else {
                $(".main-header").show();
                $('.dtfc-right-top-blocker').hide()
            }
        }
        checkOffset();
        $(window).scroll(function() {
            checkOffset();
        });
    });
</script>