<div class="container-fluid">
    <table width="100%" class="table table-striped table-bordered table-hover">
        <thead>
            <tr>
                <th>Year</th>
                <th>Month</th>
                <th>Division</th>
                <th>Status</th>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'year',
                },
                {
                    'data': 'month',
                },
                {
                    'data': 'division',
                },
                {
                    'data': 'status',
                    'sortable': false
                },
                {
                    'data': 'action',
                    'sortable': false
                },
            ],
            "order": [[ 0, "desc" ]]
        }))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 15000);
    })
</script>