<div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <div class="panel-title">
                </div>
            </div>
            <div class="panel-body">
                <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                    <div class="form-group">
                        <label for="selDiv">Division</label>
                        <select class="form-control" name="division" id="selDiv">
                        <option value="">Select One</option>
                            <?php foreach ($divisions as $division):?>
                                <option value="<?= $division->id ?>"><?= $division->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                    <div class="form-group">
                        <label for="selMon">Month</label>
                        <select class="form-control" name="month" id="selMon">
                            <option value="">Select One</option>
                            <?php foreach ($months as $month):?>
                                <option value="<?= $month ?>"><?= ucfirst($month) ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                    <div class="form-group">
                        <label for="selYear">Year</label>
                        <select class="form-control" name="year" id="selYear">
                            <option value="">Select One</option>
                            <?php foreach ($years as $year):?>
                                <option value="<?= $year ?>"><?= $year ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="form-group pull-right">
                        <button type="button" class="btn btn-primary">Filter</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<br>
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail"> 
            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Year</th>
                            <th>Month</th>
                            <th>Division</th>
                            <th>View</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'year',
                },
                {
                    'data': 'month',
                },
                {
                    'data': 'division',
                },
                {
                    'data': 'processed',
                    'sortable': false
                },
            ],
            "order": [[ 0, "desc" ]]
        }))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 15000);
    })
</script>