<link rel="stylesheet" href="<?= base_url('assets/css/payroll-view.css') ?>">
<?php $emp_sno = 0; ?>
<?php $this->fixedTable->left([40, 50, 80, 140], null, '#payroll') ?>
<?php $this->fixedTable->top([0], null, '#payroll') ?>

<?php $this->fixedTable->left([40, 50, 140, 80, 50], null, '#attendance') ?>
<?php $this->fixedTable->top([0], null, '#attendance') ?>

<?php $this->fixedTable->left([40, 50, 140, 80, 50], null, '#leave') ?>
<?php $this->fixedTable->top([0], null, '#leave') ?>
<?php if($payroll->cfo_status == 'pending' && $this->permission->method('approved_payroll', 'update')->access() && $this->permission->module('receive_cfo_notifications')->access()): ?>
<div class="container-fluid">
    <div class="row text-right" style="margin-right: 20px;">
        <a class="btn btn-info btn-approve" data-title="<?= sprintf('%s - %s %s', $payroll->division, ucfirst($payroll->month), $payroll->year) ?>" data-type="cfo" href="#" role="button"><i class="fa fa-thumbs-up" aria-hidden="true"></i> Approve</a>
        <a class="btn btn-info btn-amend" data-title="<?= sprintf('%s - %s %s', $payroll->division, ucfirst($payroll->month), $payroll->year) ?>" href="#" role="button"><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Request Amendments</a>
        <div class="row">
            <small>You can select and highlight rows for amendments by clicking the box in front of rows.</small>
        </div>
    </div>
</div>
<?php endif?>
<div id="main">
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#payroll">Payroll</a></li>
        <li><a data-toggle="tab" href="#attendance">Attendance</a></li>
        <li><a data-toggle="tab" href="#leave">Leave Sheet</a></li>
    </ul>

    <div class="tab-content">
        <div id="payroll" class="tab-pane fade in active">
            <div class="container-fluid">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr class="highlight">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th><i class="fa fa-check" aria-hidden="true"></i></th>
                                <?php endif?>
                                <th>S.No.</th>
                                <th>Empl.ID</th>
                                <th>Name</th>
                                <th>Center</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <th>Project</th>
                                <th>Total Day in Month</th>
                                <th>Total No of Days Present</th>
                                <th>Total No Days of Suspension</th>
                                <th>Total No Days of Absent / Unpaid Leave</th>
                                <th>Paid Leaves</th>
                                <th>Salary Per Month</th>
                                <th>Basic Per Month</th>
                                <th>Actual Salary As per Attendance</th>
                                <th>Arrears (if any)</th>
                                <th>Advances (if any)</th>
                                <th>Incentives (if any)</th>
                                <th>Gross Salary</th>
                                <th>Income Tax</th>
                                <th>EOBI</th>
                                <th>Penalty on NCNS</th>
                                <th>Other Deductions (if any)</th>
                                <th>Provident Fund</th>
                                <th>Total Deduction</th>
                                <th>Net Salary</th>
                                <th>Title of Account</th>
                                <th>Account Number</th>
                                <th>Account IBAN</th>
                                <th>Branch Address</th>
                                <th>Branch Code</th>
                                <th>CNIC #</th>
                                <th>Net Salary</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                $active_sum = [];
                            ?>
                            <?php foreach ($employees as $employee):
                            $emp_sno++;
                            $deductions = 0; 

                            $active_sum['actual_gross_salary'] += $employee->actual_gross_salary;
                            $active_sum['actual_basic_salary'] += $employee->actual_basic_salary;

                            $attendance_salary = round($this->payroll->calculate_attendance_salary($employee, $day_range));
                            $active_sum['month_salary'] += $attendance_salary;

                            $attendance_salary_after_arrears = $attendance_salary + $employee->arrears + $employee->advances + $employee->incentives;
                            $active_sum['salary_plus_additions'] += $attendance_salary_after_arrears;
                            $active_sum['arrears'] += $employee->arrears;
                            $active_sum['advances'] += $employee->advances;
                            $active_sum['incentives'] += $employee->incentives;

                            $employee->income_tax = calculate_income_tax($attendance_salary_after_arrears);
                            $income_tax = $employee->income_tax;
                            $active_sum['income_tax'] += $income_tax;
                            $deductions += $income_tax;

                            $deductions += round($employee->eobi);
                            $active_sum['eobi'] += $employee->eobi;

                            $deductions += round($employee->ncns_penalty);
                            $active_sum['ncns_penalty'] += $employee->ncns_penalty;
                            $deductions += round($employee->others);
                            $active_sum['others'] += $employee->others;
                    
                            $provident_fund = round($employee->provident_fund);
                            $deductions += $provident_fund;
                            $active_sum['provident_fund'] += $provident_fund;
                            $active_sum['deductions'] += $deductions;

                            $net_salary = $attendance_salary_after_arrears - $deductions;
                            if($employee->under_training) {
                                $net_salary = 0;
                            }
                            $active_sum['net_salary'] +=  $net_salary;?>
                            <tr data-id="<?= $employee->employee_id ?>">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= $employee->center ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= mb_convert_encoding($employee->project, 'UTF-8') ?></td>
                                <td class="text-center"><?= $day_range ?></td>
                                <td class="text-center"><?= $employee->actual_presents ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->suspensions) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->actual_absents) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->paid_leaves + $employee->special_leaves) ?></td>
                                <td><?= number_format($employee->actual_gross_salary)  ?></td>
                                <td><?= number_format($employee->actual_basic_salary) ?></td>
                                <td><?= number_format($attendance_salary) ?></td>
                                <td data-type="arrears"><?= number_format($employee->arrears) ?><?= $employee->arrears > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="advances"><?= number_format($employee->advances) ?><?= $employee->advances > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="incentives"><?= number_format($employee->incentives) ?><?= $employee->incentives > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= number_format($attendance_salary_after_arrears) ?></td>
                                <td><?= number_format($income_tax) ?></td>
                                <td class="text-center"><?= $employee->eobi ?></td>
                                <td data-type="ncns"><?= number_format($employee->ncns_penalty) ?><?= $employee->ncns_penalty > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="others"><?= number_format($employee->others) ?><?= $employee->others > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= number_format($provident_fund) ?></td>
                                <td><?= number_format($deductions); ?></td>
                                <td data-type="net-salary"><?= number_format($net_salary) ?><?= $employee->under_training ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= $employee->account_title ?></td>
                                <td><?= $employee->account_number ?></td>
                                <td><?= @$employee->account_iban ?></td>
                                <td><?= $employee->branch_address ?></td>
                                <td><?= $employee->branch_code ?></td>
                                <td><?= cnic_with_dashes($employee->cnic) ?></td>
                                <td data-type="net-salary"><?= number_format($net_salary) ?><?= $employee->under_training ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                            </tr>
                            <?php endforeach?>
                            <tr class="empty-row highlight">
                                <td colspan="4"><strong>Total</strong></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td></td>
                                <?php endif?>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong><?= number_format($active_sum['actual_gross_salary'])  ?></strong></td>
                                <td><strong><?= number_format($active_sum['actual_basic_salary']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['month_salary']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['arrears']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['advances']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['incentives']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['salary_plus_additions']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['income_tax']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['eobi']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['ncns_penalty'], ) ?></strong></td>
                                <td><strong><?=  number_format($active_sum['others']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['provident_fund'], ) ?></strong></td>
                                <td><strong><?= number_format($active_sum['deductions']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['net_salary']) ?></strong></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong><?= number_format($active_sum['net_salary']) ?></strong></td>
                            </tr>
                            <tr class="empty-row">
                                <td colspan="4"></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td></td>
                                <?php endif?>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                            </tr>
                            <tr class="empty-row highlight">
                                <th colspan="4"><strong>Resigned / Terminated</strong></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th></th>
                                <?php endif?>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                            <?php 
                                $inactive_sum = [];
                            ?>
                            <?php foreach ($inactive_employees as $employee):
                            $emp_sno++;
                            $deductions = 0; 

                            $inactive_sum['actual_gross_salary'] += $employee->actual_gross_salary;
                            $inactive_sum['actual_basic_salary'] += $employee->actual_basic_salary;

                            $attendance_salary = round($this->payroll->calculate_attendance_salary($employee, $day_range));
                            $inactive_sum['month_salary'] += $attendance_salary;
                            $inactive_sum['arrears'] += $employee->arrears;
                            $inactive_sum['advances'] += $employee->advances;
                            $inactive_sum['incentives'] += $employee->incentives;
                            $attendance_salary_after_arrears = $attendance_salary + $employee->arrears + $employee->advances + $employee->incentives;
                            $inactive_sum['salary_plus_additions'] += $attendance_salary_after_arrears;
                            
                            $employee->income_tax = calculate_income_tax($attendance_salary_after_arrears);
                            $income_tax = $employee->income_tax;
                            $inactive_sum['income_tax'] += $income_tax;
                            $deductions += $income_tax;

                            $deductions += $employee->eobi;
                            $inactive_sum['eobi'] += $employee->eobi;

                            $deductions += $employee->ncns_penalty;
                            $inactive_sum['ncns_penalty'] += $employee->ncns_penalty;
                            $deductions += $employee->others;
                            $inactive_sum['others'] += $employee->others;
                        
                            $deductions += $employee->others;
                    
                            $provident_fund = round($employee->provident_fund);
                            $deductions += $provident_fund;
                            $inactive_sum['provident_fund'] += $provident_fund;
                            $inactive_sum['deductions'] += $deductions;
                            
                            $net_salary = $attendance_salary_after_arrears - $deductions;
                            if($employee->under_training) {
                                $net_salary = 0;
                            }
                            $inactive_sum['net_salary'] += $net_salary ?>
                            <tr data-id="<?= $employee->employee_id ?>">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= $employee->center ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= mb_convert_encoding($employee->project, 'UTF-8') ?></td>
                                <td class="text-center"><?= $day_range ?></td>
                                <td class="text-center"><?= $employee->actual_presents ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->suspensions) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->actual_absents) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->paid_leaves + $employee->special_leaves) ?></td>
                                <td><?= number_format($employee->actual_gross_salary)  ?></td>
                                <td><?= number_format($employee->actual_basic_salary) ?></td>
                                <td><?= number_format($attendance_salary) ?></td>
                                <td data-type="arrears"><?= number_format($employee->arrears) ?><?= $employee->arrears > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="advances"><?= number_format($employee->advances) ?><?= $employee->advances > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="incentives"><?= number_format($employee->incentives) ?><?= $employee->incentives > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= number_format($attendance_salary_after_arrears) ?></td>
                                <td><?= number_format($income_tax) ?></td>
                                <td><?= $employee->eobi ?></td>
                                <td data-type="ncns"><?= number_format($employee->ncns_penalty) ?><?= $employee->ncns_penalty > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td data-type="others"><?= number_format($employee->others) ?><?= $employee->others > 0 ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= number_format($provident_fund) ?></td>
                                <td><?= number_format($deductions); ?></td>
                                <td data-type="net-salary"><?= number_format($net_salary) ?><?= $employee->under_training ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                                <td><?= $employee->account_title ?></td>
                                <td><?= $employee->account_number ?></td>
                                <td><?= @$employee->account_iban ?></td>
                                <td><?= $employee->branch_address ?></td>
                                <td><?= $employee->branch_code ?></td>
                                <td><?= cnic_with_dashes($employee->cnic) ?></td>
                                <td data-type="net-salary"><?= number_format($net_salary) ?><?= $employee->under_training ? '<div class="remarks"><i class="fa fa-commenting-o" aria-hidden="true"></i></div>' : null ?></td>
                            </tr>
                            <?php endforeach?>
                            <tr class="empty-row highlight">
                                <td colspan="4"><strong>Total Resigned / Terminated</strong></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td></td>
                                <?php endif?>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong><?= number_format($inactive_sum['actual_gross_salary'])  ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['actual_basic_salary']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['month_salary']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['arrears']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['advances']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['incentives']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['salary_plus_additions']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['income_tax']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['eobi']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['ncns_penalty'], ) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['others'], ) ?></strong></td>
                                <td><strong><?=  number_format($inactive_sum['provident_fund']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['deductions']) ?></strong></td>
                                <td><strong><?= number_format($inactive_sum['net_salary']) ?></strong></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong><?= number_format($inactive_sum['net_salary']) ?></strong></td>
                            </tr>
                            <tr class="empty-row">
                                <td colspan="4"><strong>Grand Total</strong></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <td style="display: none;"></td>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td></td>
                                <?php endif?>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong><?= number_format($active_sum['actual_gross_salary'] + $inactive_sum['actual_gross_salary'])  ?></strong></td>
                                <td><strong><?= number_format($active_sum['actual_basic_salary'] + $inactive_sum['actual_basic_salary']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['month_salary'] + $inactive_sum['month_salary']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['arrears'] + $inactive_sum['arrears']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['advances'] + $inactive_sum['advances']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['incentives'] + $inactive_sum['incentives']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['salary_plus_additions'] + $inactive_sum['salary_plus_additions']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['income_tax'] + $inactive_sum['income_tax']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['eobi'] + $inactive_sum['eobi']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['ncns_penalty'] + $inactive_sum['ncns_penalty']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['others'] + $inactive_sum['others']) ?></strong></td>
                                <td><strong><?=  number_format($active_sum['provident_fund'] + $inactive_sum['provident_fund']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['deductions'] + $inactive_sum['deductions']) ?></strong></td>
                                <td><strong><?= number_format($active_sum['net_salary'] + $inactive_sum['net_salary']) ?></strong></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong><?= number_format($active_sum['net_salary'] + $inactive_sum['net_salary']) ?></strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="attendance" class="tab-pane fade">
            <?php $emp_sno = 0 ?>
            <div class="container-fluid">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr class="highlight">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th><i class="fa fa-check" aria-hidden="true"></i></th>
                                <?php endif?>
                                <th>S.No.</th>
                                <th>Name</th>
                                <th>DOJ</th>
                                <th>Empl.ID</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <?php foreach ($date_array as $date_arr) :?>
                                    <th class="rotate-90"><?= date('D-d-M', strtotime($date_arr)) ?></th>
                                <?php endforeach?>
                                <th>Present</th>
                                <th>Absent</th>
                                <th>Suspension</th>
                                <th>Late Arrivals</th>
                                <th>Unpaid Leave</th>
                                <th>Deducted Days for LA</th>
                                <th>Paid Leave</th>
                                <th>Off</th>
                                <th>Half-Day</th>
                                <th>Total Working Days</th>
                                <th>Average</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($employees as $employee):
                                $emp_sno++;?>
                            <tr>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <?php foreach ($date_array as $date_arr) :?>
                                    <?php $att_value = strtoupper($employee_attendance['e_' . $employee->employee_id][$date_arr]) ?>
                                    <td class="text-center attendance_val_<?= strtolower($att_value) ?>"><?= $att_value ?></td>
                                <?php endforeach?>
                                <td class="text-center"><?= sprintf('%g', $employee->presents) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->ncns) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->suspensions) ?></td>
                                <td class="text-center"><?= $employee->late_arrivals ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->unpaid_leaves) ?></td>
                                <td class="text-center"><?= floor($employee->late_arrivals / 3) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->paid_leaves + $employee->special_leaves) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->offs) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->half_days) ?></td>
                                <td class="text-center"><?= $this->payroll->get_paid_days($employee) ?></td>
                                <td class="text-center"><?= round((($employee->presents + $employee->late_arrivals + $employee->offs + $employee->half_days + $employee->unpaid_half_days) / $day_range) * 100) ?>%</td>
                            </tr>
                            <?php endforeach?>
                            <tr class="empty-row">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td></td>
                                <?php endif?>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <?php for ($i=-11; $i < $day_range ; $i++) :?>
                                    <td></td>
                                <?php endfor?>
                            </tr>
                            <tr class="empty-row highlight">
                                <th colspan="4"><strong>Resigned / Terminated</strong></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th></th>
                                <?php endif?>
                                <th></th>
                                <th></th>
                                <?php for ($i=-11; $i < $day_range ; $i++) :?>
                                    <th></th>
                                <?php endfor?>
                            </tr>
                            <?php foreach ($inactive_employees as $employee):
                                $emp_sno++?>
                            <tr>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <?php foreach ($date_array as $date_arr) :?>
                                    <?php $att_value = strtoupper($employee_attendance['e_' . $employee->employee_id][$date_arr]) ?>
                                    <td class="text-center attendance_val_<?= strtolower($att_value) ?>"><?= $att_value ?></td>
                                <?php endforeach?>
                                <td class="text-center"><?= sprintf('%g', $employee->presents) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->ncns) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->suspensions) ?></td>
                                <td class="text-center"><?= $employee->late_arrivals ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->unpaid_leaves) ?></td>
                                <td class="text-center"><?= floor($employee->late_arrivals / 3) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->paid_leaves + $employee->special_leaves) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->offs) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->half_days) ?></td>
                                <td class="text-center"><?= $this->payroll->get_paid_days($employee) ?></td>
                                <td class="text-center"><?= round((($employee->presents + $employee->late_arrivals + $employee->offs + $employee->half_days + $employee->unpaid_half_days) / $day_range) * 100) ?>%</td>
                            </tr>
                            <?php endforeach?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div id="leave" class="tab-pane fade">
            <?php $emp_sno = 0;
            $unconfirmed_employees = []?>
            <div class="container-fluid">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr class="highlight">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th><i class="fa fa-check" aria-hidden="true"></i></th>
                                <?php endif?>
                                <th>S.No.</th>
                                <th>Name</th>
                                <th>DOJ</th>
                                <th>Empl.ID</th>
                                <th>Designation</th>
                                <th>Department</th>
                                <th>Primary Project</th>
                                <?php foreach ($month_array as $month_arr) :?>
                                    <th class="rotate-90"><?= $month_arr ?></th>
                                <?php endforeach?>
                                <th>Total Leaves</th>
                                <th>Availed</th>
                                <th>Special</th>
                                <th>Remaining</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="empty-row">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                    <td></td>
                                <?php endif ?>
                                <?php for ($i=0; $i < 23; $i++):?>
                                    <td></td>
                                <?php endfor?>
                            </tr>
                            <tr class="empty-row highlight">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th></th>
                                <?php endif?>
                                <th></th>
                                <th colspan="3"><strong>Confirmed</strong></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <?php for ($i=0; $i < 19; $i++):?>
                                    <th></th>
                                <?php endfor?>
                            </tr>
                            <?php foreach ($employees as $employee):
                                if($employee->duty_type != 1) {
                                    $unconfirmed_employees[] = $employee;
                                    continue;
                                }
                                $emp_sno++;
                                $availed_leaves = 0;
                                $availed_special_leaves = 0;?>
                            <tr>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= $employee->project ?></td>
                                <?php foreach ($month_array as $month_arr) :?>
                                    <?php $dleave = $employee_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $sleave = $employee_special_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $availed_special_leaves += $sleave;
                                    $availed_leaves += $dleave ?>
                                    <td class="text-center"><?= $dleave + $sleave ?></td>
                                <?php endforeach?>
                                <td class="text-center"><?= sprintf('%g', $employee->leave_quota) ?></td>
                                <td class="text-center"><?= $availed_leaves ?></td>
                                <td class="text-center"><?= sprintf('%g', $availed_special_leaves) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->leave_quota - $availed_leaves) ?></td>
                            </tr>
                            <?php endforeach?>
                            <tr class="empty-row">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                    <td></td>
                                <?php endif?>
                                <?php for ($i=0; $i < 23; $i++):?>
                                    <td></td>
                                <?php endfor?>
                            </tr>
                            <tr class="empty-row highlight">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th></th>
                                <?php endif?>
                                <th colspan="3"><strong>Un Confirmed</strong></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <?php for ($i=0; $i < 20; $i++):?>
                                    <th></th>
                                <?php endfor?>
                            </tr>
                            <?php foreach ($unconfirmed_employees as $employee):
                                $emp_sno++;
                                $availed_leaves = 0;
                                $availed_special_leaves = 0;?>
                            <tr>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= $employee->project ?></td>
                                <?php foreach ($month_array as $month_arr) :?>
                                    <?php $dleave = $employee_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $sleave = $employee_special_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $availed_special_leaves += $sleave;
                                    $availed_leaves += $dleave ?>
                                    <td class="text-center"><?= $dleave + $sleave ?></td>
                                <?php endforeach?>
                                <td class="text-center"><?= sprintf('%g', $employee->leave_quota) ?></td>
                                <td class="text-center"><?= $availed_leaves ?></td>
                                <td class="text-center"><?= sprintf('%g', $availed_special_leaves) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->leave_quota - $availed_leaves) ?></td>
                            </tr>
                            <?php endforeach?>
                            <tr class="empty-row">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                    <td></td>
                                <?php endif?>
                                <?php for ($i=0; $i < 23; $i++):?>
                                    <td></td>
                                <?php endfor?>
                            </tr>
                            <tr class="empty-row highlight">
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <th></th>
                                <?php endif?>
                                <th colspan="3"><strong>Resigned & Terminated</strong></th>
                                <th style="display: none;"></th>
                                <th style="display: none;"></th>
                                <?php for ($i=0; $i < 20; $i++):?>
                                    <th></th>
                                <?php endfor?>
                            </tr>
                            <?php foreach ($inactive_employees as $employee):
                                $emp_sno++;
                                $availed_leaves = 0;
                                $availed_special_leaves = 0;?>
                            <tr>
                                <?php if($payroll->cfo_status == 'pending') : ?>
                                <td><input type="checkbox" class="form-check-input select-row" value="1"></td>
                                <?php endif?>
                                <td><?= $emp_sno ?></td>
                                <td><?= $employee->name ?></td>
                                <td><?= formatted_date($employee->hire_date) ?></td>
                                <td><?= $employee->hrm_id ?></td>
                                <td><?= $employee->position ?></td>
                                <td><?= $employee->department ?></td>
                                <td><?= $employee->project ?></td>
                                <?php foreach ($month_array as $month_arr) :?>
                                    <?php $dleave = $employee_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $sleave = $employee_special_leaves['e_' . $employee->employee_id][strtolower($month_arr)];
                                    $availed_special_leaves += $sleave;
                                    $availed_leaves += $dleave ?>
                                    <td class="text-center"><?php $dleave + $sleave ?></td>
                                <?php endforeach?>
                                <td class="text-center"><?= sprintf('%g', $employee->leave_quota) ?></td>
                                <td class="text-center"><?= $availed_leaves ?></td>
                                <td class="text-center"><?= sprintf('%g', $availed_special_leaves) ?></td>
                                <td class="text-center"><?= sprintf('%g', $employee->leave_quota - $availed_leaves) ?></td>
                            </tr>
                            <?php endforeach?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modelUpdateCol" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form action="#">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update Payroll of <span class="employee_name"></span></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    var adjustment_done = false;
    $('.nav-tabs a').on('shown.bs.tab', function (e) {
    })
    $(document).ready(function () {        
        $('.currency').inputmask({
            alias: 'numeric',
            groupSeparator: ',',
            digitsOptional: true,
        })
        tippy('td .remarks', {
            content: 'loading...',
            interactive: true,
            arrow: true,
            onShow(instance) {
                var target = instance.reference.parentNode
                var row = $(target).parent('tr').data('id');
                var column = $(target).data('type');
                $.ajax({
                    type: "GET",
                    url: "<?= base_url() ?>payroll/payroll/remarks",
                    beforeSend: () => {},
                    data: {
                        payroll: '<?= $payroll->id ?>',
                        row: row,
                        column: column,
                    },
                    success: function (res) {
                        instance.setContent(res);return
                        if(res.success) {
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            },
        })
    })
    var update_row = null
    $(document).on('click', '.edit-row', function (e) {
        e.preventDefault();
        var row = $(this).closest('tr');
        var $modal = $('#modelUpdateCol');
        myajax({
            type: "GET",
            url: "<?= base_url() ?>payroll/payroll/adjust",
            data: {
                payroll: '<?= $payroll->id ?>',
                row: row.data('id'),
            },
            beforeSend: function(){
                adjustment_done = false
                update_row = null
                $modal.find('.modal-body').html('');
            },
            success: function (res) {
                if(res.success) {
                    update_row = res.success.employee_id
                    $modal.find('.modal-body').html(res.success.html)
                    $modal.find('.employee_name').html(res.success.name)
                    $modal.modal('show')
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
                if(res.reload) {
                    window.location.reload()
                }
            }
        });
    });
    $('table').on('change', '.select-row', function() {
        $(this).closest('tr').removeClass('selected-row')
        if($(this).is(':checked')) {
            $(this).closest('tr').addClass('selected-row')
        }
    })
    $('#modelUpdateCol').on('click', 'a.btn-add-adjustment', function(e) {
        e.preventDefault();
        var $this = $(this)
        var $modal = $this.closest('.modal');
        var $tab = $this.closest('.tab-pane')
        var id = $tab.data('row');
        var $row = $this.closest('fieldset');
        var data = {
                payroll: '<?= $payroll->id ?>',
                row: id,
                column: $this.data('type'),
                value: $row.find('input').val(),
                reason: $row.find('textarea').val()
            };
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/payroll/adjust",
            data: data,
            success: function (res) {
                if(res.success) {
                    adjustment_done = true
                    var html = `<tr>
                                    <td>
                                        <span class="orig reason">${data.reason}</span>
                                        <span class="edit"><textarea cols="30" class="form-control" rows="3">${data.reason}</textarea></span>
                                    </td>
                                    <td>
                                        <span class="orig val">${data.value}</span>
                                        <span class="edit"><input type="text" class="form-control" value="${data.value}"></span>
                                    </td>
                                    <td width="10" class="actions">
                                        <span class="orig">
                                            <a class="btn btn-primary btn-edit btn-sm" href="#" role="button"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                            <a class="btn btn-primary btn-delete btn-sm" data-id="${res.id}" href="#" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                        </span>
                                        <span class="edit">
                                            <a class="btn btn-primary btn-edit-save btn-sm" data-id="${res.id}" href="#" role="button">Save</a>
                                        </span>
                                    </td>
                                </tr>`;
                    $tab.find('tbody').append(html)
                    
                    $row.find('input').val('')
                    $row.find('textarea').val('')
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#modelUpdateCol').on('click', '.btn-edit', function(e) {
        e.preventDefault();
        $(this).closest('tr').addClass('enable-edit')
    })
    $('#modelUpdateCol').on('click', '.btn-edit-save', function(e) {
        e.preventDefault();
        var $this = $(this);
        var $row = $this.closest('tr')

        var data = {
            id: $this.data('id'),
            value: $row.find('input').val(),
            reason: $row.find('textarea').val()
        };
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/payroll/adjust",
            data: data,
            success: function (res) {
                if(res.success) {
                    adjustment_done = true
                    $row.find('span.reason').text(data.reason)
                    $row.find('span.val').text(data.value)
                    $row.removeClass('enable-edit')
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#modelUpdateCol').on('click', '.btn-delete', function(e) {
        e.preventDefault();
        var $this = $(this);
        var $row = $this.closest('tr')
    
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove this item<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/payroll/delete_adjustment",
                    data: {id: $this.data('id')},
                    success: function (res) {
                        if(res.success) {
                            adjustment_done = true
                            $row.remove()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
    $('#modelUpdateCol').on('hidden.bs.modal', function() {
        if(!adjustment_done) {
            return
        }
        $('.se-pre-con').show()
        location.reload()
    })
</script>
<?php require_once(APPPATH . 'modules/payroll/views/partials/view_common.php') ?>