<!-- <div class="row">
    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <div class="panel">
            <div class="panel-heading">
                <div class="panel-title">
                </div>
            </div>
            <div class="panel-body">
                <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                    <div class="form-group">
                        <label for="selDiv">Division</label>
                        <select class="form-control" name="division" id="selDiv">
                        <option value="">Select One</option>
                            <?php foreach ($divisions as $division):?>
                                <option value="<?= $division->id ?>"><?= $division->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                    <div class="form-group">
                        <label for="selMon">Month</label>
                        <select class="form-control" name="month" id="selMon">
                            <option value="">Select One</option>
                            <?php foreach ($months as $month):?>
                                <option value="<?= $month ?>"><?= ucfirst($month) ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-xs-4 col-sm-4 col-md-4 col-lg-4">
                    <div class="form-group">
                        <label for="selYear">Year</label>
                        <select class="form-control" name="year" id="selYear">
                            <option value="">Select One</option>
                            <?php foreach ($years as $year):?>
                                <option value="<?= $year ?>"><?= $year ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="form-group pull-right">
                        <button type="button" class="btn btn-primary">Filter</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<br> -->
<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail"> 
            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Year</th>
                            <th>Month</th>
                            <th>Division</th>
                            <th>View</th>
                            <th>CFO Status</th>
                            <th>Export</th>
                            <th>Generated At</th>
                            <th class="hideexport">Download</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'POST',
                beforeSend: function(){}
            },
            columns: [
                {
                    'data': 'year',
                },
                {
                    'data': 'month',
                },
                {
                    'data': 'division',
                },
                {
                    'data': 'processed',
                    'sortable': false
                },
                {
                    'data': 'cfo_status',
                },
                {
                    'data': 'export',
                    'sortable': false
                },
                {
                    'data': 'updated_at',
                },
                {
                    'data': 'download',
                    'sortable': false
                },
            ],
            "order": [[ 0, "desc" ]]
        }))
    })
    $('table.table').on('click', '.btn-approve', function(e) {
        e.preventDefault();
        var title = $(this).data('title')
        Swal.fire({
            title: `Are you sure?`,
            html: `Approve the '<strong>${title}</strong>' payroll? You won't be able to revert this action`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, approve it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/approve",
                    data: {
                        title: title,
                        id: $(this).data('id'),
                        type: $(this).data('type'),
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
</script>