<?php $emp_sno = 0; ?>
<style>
    td.editable_dt.enable {
        text-align: center;
    }
    #main i.fa.fa-pencil {
        color: #2929c9;
        padding-left: 10%;
    }
    td div.remarks {
        width: 7px;
        margin-left: 80%;
        color: #0bdd1b;
    }
    #main .nav-tabs {
        border-bottom: 0;
        position: fixed;
        bottom: 0px;
        background: #05253a;
        width: 100%;
        padding: 8px 5px;
        margin-left: -45px;
        z-index: 99;
    }
    
    #toTop {
        bottom: 55px;
    }

    #main .ui-state-default:not(.ui-state-active):not(.ui-state-highlight),
    #main .ui-widget-content .ui-state-default:not(.ui-state-active):not(.ui-state-highlight),
    #main .ui-widget-header .ui-state-default,
    #main .ui-button,
    #main  .ui-button.ui-state-disabled:hover,
    #main  .ui-button.ui-state-disabled:active,
    #main .nav.nav-tabs li:not(.active) a {
        background-color: rgb(150 166 197 / 48%) !important;
    }

    .nav-tabs li>a {
        pointer-events: auto !important;
    }
    th 
    {
        vertical-align: center;
        text-align: center;
    }

    th.rotate-90-not
    {
        -ms-writing-mode: tb-rl;
        -webkit-writing-mode: vertical-rl;
        writing-mode: vertical-rl;
        transform: rotate(180deg);
        white-space: nowrap;
        font-size: 16px !important;
    }
    td div.remarks {
        width: 4px;
    }
    td.editable_dt i.fa-pencil {
        cursor: pointer;
        display: none;
    }
    td.editable_dt.enable {
        border: 1px solid black;
    }
    td.editable_dt.enable i.fa-pencil {
        display: inline-block;
    }
    tr.empty-row td.select-checkbox::before {
        visibility: hidden !important;
    }
    table.dataTable tr.selected td.select-checkbox::after {
        font-size: 13px !important;
        margin-top: -11px !important;
        text-shadow: none !important;
        font-weight: bolder;
    }
</style>
<div class="container-fluid">
    <table class="table table-bordered table-hover">
        <thead>
            <tr>
                <th></th>
                <th>Edit</th>
                <th>S.No.</th>
                <th>Empl.ID</th>
                <th>Name</th>
                <th>Center</th>
                <th>Date of Joining</th>
                <th>Department</th>
                <th>Title of Account</th>
                <th>CNIC</th>
                <th>Net Salary</th>
                <th>Payorder Fee</th>
                <th>Net Payable</th>
                <th>Comments</th>
            </tr>
        </thead>
        <tbody>
            <?php $sum = 0?>
            <?php foreach ($payorders as $payorder) :?>
                <?php $emp_sno++;
                $deductions = 0; 

                $attendance_salary = round($this->payroll->calculate_attendance_salary($payorder, $day_range));

                $attendance_salary_after_arrears = $attendance_salary + $payorder->arrears + $payorder->advances + $payorder->incentives;

                $payorder->income_tax = calculate_income_tax($attendance_salary_after_arrears);
                $deductions += $payorder->income_tax;
                $deductions += $payorder->eobi;
                $deductions += round($payorder->provident_fund);
                $deductions += round($payorder->ncns_penalty);
                $deductions += round($payorder->others);
                $net_salary = $attendance_salary_after_arrears - $deductions;
                
                $payorder_minus_net = $net_salary + 290;
                $sum += $net_salary;
                ?>
                <tr>
                    <td><?= $payorder->employee_id ?></td>
                    <?php if($this->permission->method('payorders', 'update')->access()):?>
                    <td><a href="#" class="edit-row"><i class="fa fa-pencil" aria-hidden="true"></i></a></td>
                    <?php endif?>
                    <td><?= $emp_sno ?></td>
                    <td><?= $payorder->hrm_id ?></td>
                    <td><?= $payorder->name ?></td>
                    <td><?= $payorder->center ?></td>
                    <td><?= formatted_date($payorder->hire_date) ?></td>
                    <td><?= $payorder->department ?></td>
                    <td><?= $payorder->account_title ?></td>
                    <td><?= cnic_with_dashes($payorder->cnic) ?></td>
                    <td><?= number_format($payorder_minus_net) ?></td>
                    <td>290</td>
                    <td><?= number_format($net_salary) ?></td>
                    <td><?= $payorder->comments ?></td>
                </tr>
                <?php endforeach?>
                <tr>
                    <?php for ($i=0; $i < 14; $i++) :?>
                        <td></td>
                    <?php endfor?>
                </tr>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td><strong>Total</strong></td>
                    <td><?= number_format($sum) ?></td>
                    <td></td>
                </tr>
        </tbody>
    </table>
</div>
<!-- Modal -->
<div class="modal fade" id="modelUpdateCol" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form action="#">
            <div class="modal-content">
                <form action="#" method="post">
                <div class="modal-header">
                    <h5 class="modal-title">Update Payorder of <span class="employee_name"></span></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="row" id="content">

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    var adjustment_done = false;
    var dt_opts = function(hash) {
        let dt = {
            paging: false,
            info: false,
            ordering: false,
            scrollY: true,
            scrollX: true,
            scrollCollapse: true,
            fixedHeader: true,
            fixedColumns:   {
                left: 4,
                right: 0
            },
            rowId: function(a) {
                return a[0]
            },
            stateSave: true,
        }
        dt.columnDefs = [
            { visible: false, targets: [0]},
        ]
        return dt
    }
    $(document).ready(function () {
        window.dtable = $('table').on('init.dt', function() {
            setTimeout(() => {
                window.dtable && window.dtable.columns.adjust()
            }, 1000);
        }).DataTable(dt_opts('payroll'));
        function checkOffset() {
            if ($(".navbar").offset().top > 50) {
                $(".main-header").hide();
                $('.dtfc-right-top-blocker').show()
            }     
            else {
                $(".main-header").show();
                $('.dtfc-right-top-blocker').hide()
            }
        }
        checkOffset();
        $(window).scroll(function() {
            checkOffset();
        });
    })
    var update_row = null
    $(document).on('click', '.edit-row', function (e) {
        e.preventDefault();
        var row = window.dtable.row(this.parentNode.parentNode);
        var $modal = $('#modelUpdateCol');
        myajax({
            type: "GET",
            url: "<?= base_url() ?>payroll/payorder/edit",
            data: {
                payroll: '<?= $payroll->id ?>',
                row: row.data()[0],
            },
            beforeSend: function(){
                adjustment_done = false
                update_row = null
                $modal.find('.modal-body #content').html('');
                $modal.find('.employee_name').html('');
            },
            success: function (res) {
                if(res.success) {
                    update_row = res.success.employee_id
                    $modal.find('.modal-body #content').html(res.success.html)
                    $modal.find('.employee_name').html(res.success.name)
                    $modal.modal('show')
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    });
    $('#modelUpdateCol form').on('submit', function(e) {
        e.preventDefault();
        $form = $(this)
        myajax({
            type: "POST",
            url: "<?= base_url() ?>payroll/payorder/edit",
            data: {
                payroll: <?= $payroll->id ?>,
                row: update_row,
                account_title: $form.find('[name=account_title]').val(),
                comments: $form.find('[name=comments]').val()
            },
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
                if(res.reload) {
                    location.reload()
                }
            }
        });
    })
</script>