<script>
    $(document).ready(function () {
        function checkOffset() {
            if ($(".navbar").offset().top > 50) {
                $(".main-header").hide();
                $('.dtfc-right-top-blocker').show()
            }     
            else {
                $(".main-header").show();
                $('.dtfc-right-top-blocker').hide()
            }
        }
        checkOffset();
        $(window).scroll(function() {
            checkOffset();
        });
    });
    $('.btn-approve').on('click', function(e) {
        e.preventDefault();
        var $this = $(this)
        var title = $(this).data('title')
        Swal.fire({
            title: `Are you sure?`,
            html: `Approve the '<strong>${title}</strong>' payroll? You won't be able to revert this action`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, approve it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/approve",
                    data: {
                        id: '<?= $payroll->id ?>',
                        type: $this.data('type'),
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                            if($this.data('type') == 'hr') {
                                location.href = '<?= base_url('payroll/pending') ?>'
                            } else {
                                location.href = '<?= base_url('payroll/approved') ?>'
                            }
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
    $('.btn-amend').on('click', function(e) {
        e.preventDefault();
        var $this = $(this)
        var title = $(this).data('title')
        var rows = $('.selected-row').map(function(){
            return $(this).data('id')
        }).toArray();
        if(!rows.length) {
            Swal.fire(
                '<?= display('error') ?>!',
                'Please select at least one record for requesting amendment',
                'error'
            );
            return;
        }
        Swal.fire({
            title: `Request amendments`,
            html: `Send '<strong>${title}</strong>' payroll back to HR?`,
            input: 'textarea',
            inputLabel: 'Enter reason for amendment request',
            showCancelButton: true,
            inputValidator: (value) => {
                if (!value) {
                return 'You need to write something!'
                }
            },
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, mark it for amendments!'
        }).then((result) => {
            if (result.value) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>payroll/amend",
                    data: {
                        id: '<?= $payroll->id ?>',
                        rows: rows,
                        reason: result.value
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                            if($this.data('type') == 'hr') {
                                location.href = '<?= base_url('payroll/pending') ?>'
                            } else {
                                location.href = '<?= base_url('payroll/approved') ?>'
                            }
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
</script>