<style>
    .items-table .edit {
        display: none;
    }
    .items-table tr.enable-edit .orig {
        display: none;
    }
    .items-table tr.enable-edit .edit {
        display: block;
    }
    .orig a.btn {
        display: flex;
        flex-direction: row;
    }
    td.actions span {
        display: flex;
        flex-direction: row;
    }
    .actions a.btn {
        margin-right: 5px;
    }
</style>
<div>
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#arrears">Arrears</a></li>
        <li><a data-toggle="tab" href="#advances">Advances</a></li>
        <li><a data-toggle="tab" href="#incentives">Incentives</a></li>
        <li class="pull-right"><a data-toggle="tab" href="#ncns">Penalty on NCNS</a></li>
        <li class="pull-right"><a data-toggle="tab" href="#others">Other Deductions</a></li>
    </ul>

    <div class="tab-content">
        <?php foreach ($adjustments as $key => $sub_adjustments) :?>
            <div id="<?= $key ?>" data-row="<?= $row ?>" class="tab-pane fade <?= $key == 'arrears' ? 'in active' : null ?>">
                <table class="table table-bordered table-hover items-table">
                    <thead>
                        <tr>
                            <th>Reason</th>
                            <th>Amount</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($sub_adjustments as $adjustment) :?>
                            <?php if($adjustment->type == 'user') :?>
                            <tr>
                                <td>
                                    <span class="orig reason"><?= $adjustment->reason ?></span>
                                    <span class="edit"><textarea cols="30" class="form-control" rows="3"><?= htmlspecialchars($adjustment->reason) ?></textarea></span>
                                </td>
                                <td>
                                    <span class="orig val"><?= $adjustment->value ?></span>
                                    <span class="edit"><input type="text" class="form-control" value="<?= $adjustment->value ?>"></span>
                                </td>
                                <td width="10" class="actions">
                                    <span class="orig">
                                        <a class="btn btn-primary btn-edit btn-sm" href="#" role="button"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                        <a class="btn btn-primary btn-delete btn-sm" data-id="<?= $adjustment->id ?>" href="#" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                    </span>
                                    <span class="edit">
                                        <a class="btn btn-primary btn-edit-save btn-sm" data-type="<?= $key ?>" data-id="<?= $adjustment->id ?>" href="#" role="button">Save</a>
                                    </span>
                                </td>
                            </tr>
                            <?php else : ?>
                            <tr>
                                <td><?= $adjustment->reason ?></td>
                                <td><?= $adjustment->value ?></td>
                                <td width="10">SYSTEM GENERATED</td>
                            </tr>
                            <?php endif?>
                        <?php endforeach?>
                    </tbody>
                </table>
                <hr>
                <div class="container-fluid">
                    <div class="row" style="padding-top: 10px;">
                        <fieldset>
                            <div class="row">
                                <div class="col-sm-10">
                                    <label for="" class="col-sm-2">Amount:</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" placeholder="Enter amount">
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <a name="" id="" class="btn btn-primary btn-sm btn-add-adjustment" data-type="<?= $key ?>" href="#" role="button"><i class="fa fa-plus" aria-hidden="true"></i> Add</a>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                <label for="">Reason</label>
                                <textarea class="form-control" name="" id="" rows="3"></textarea>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        <?php endforeach ?>
    </div>
</div>