<?php
class Tax_model extends CI_Model
{
    public function get_slab($min, $max, $ignore_id = 0)
    {
        $result = $this->db->query(
            'CALL get_slab(?, ?, ?);',
            [$min, $max, $ignore_id]
        )->row();
        $this->db->next_result();
        return $result;
    }
    public function get_slab_by_salary($salary)
    {
        $result = $this->db->query(
            'CALL get_slab_by_salary(?);',
            [$salary]
        )->row();
        $this->db->next_result();
        return $result;
    }
    public function get($id = null)
    {
        $this->db->from('payroll_tax_slabs');
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->result();
    }
    public function add($data)
    {
        $this->db->trans_start();
        $this->db->insert('payroll_tax_slabs', [
            'min' => $data['min'],
            'max' => $data['max'],
            'fixed' => $data['fixed'],
            'rate' => $data['rate'],
        ]);
        $this->activity->log([
            'taxslab_added',
            $data['rate'],
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function update($data)
    {
        $this->db->trans_start();
        $this->db->where('id', $data['id'])->update('payroll_tax_slabs', [
            'min' => $data['min'],
            'max' => $data['max'],
            'fixed' => $data['fixed'],
            'rate' => $data['rate'],
        ]);
        $this->activity->log([
            'taxslab_updated',
            $data['rate'],
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function delete($id)
    {
        $this->db->trans_start();
        $rec = $this->get($id);
        $this->db->where('id', $id)->delete('payroll_tax_slabs');
        $this->activity->log([
            'taxslab_deleted',
            $rec->rate,
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function calculate_monthly_income_tax($salary)
    {
        if (empty(trim($salary))) {
            return 0;
        }
        $bracket = $this->get_slab_by_salary($salary);
        if (!$bracket) {
            throw new Exception('Tax bracket not found for salary ' . $salary);
        }
        $tax = 0;
        if ($bracket->fixed) {
            $tax = $bracket->fixed;
        }
        if ($bracket->rate) {
            $last_bracket = $bracket->min - 1;
            if ($last_bracket > 0) {
                $salary = ($salary * 12) - $last_bracket;
            }
            $tax += ($salary * ($bracket->rate / 100));
        }
        return $tax / 12;
    }
    /**
     * Datatable functions
     */
    private function query($orWhere = [])
    {
        $this->db->from('payroll_tax_slabs');

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
    }
    public function countAllRows()
    {
        return $this->db->count_all_results('payroll_tax_slabs');
    }
    public function countDatatable($orWhere = [])
    {
        $this->query($orWhere);
        return $this->db->count_all_results();
    }
    public function getDatatable($post, $orWhere = [])
    {
        $this->query($orWhere);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        $this->db->order_by('rate', 'desc');
        return $this->db->get()->result_array();
    }
}
