<?php

class Preview_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'payroll/payroll_model' => 'payroll',
        ]);
    }
    public function check($month, $year, $division_id, $status = 'pending', $department = [], $employees = [])
    {
        $this->db
            ->select('payroll.id')
            ->join('payroll', 'payroll_employee.payroll_id=payroll.id', 'left')
            ->where([
                'payroll.type' => 'payroll',
                'payroll.month' => $month,
                'payroll.year' => $year,
                'payroll.division_id' => $division_id,
                'payroll.cfo_status' => $status,
            ]);
        if ($department || $employees) {
            $this->db->group_start();
            if ($department) {
                $this->db->or_where_in('payroll_employee.department', $department);
            }
            if ($employees) {
                $this->db->or_where_in('payroll_employee.employee_id', $employees);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results('payroll_employee');
    }
    public function get_employees($month, $year, $division_id, $status = 'pending', $department = [], $employees = [])
    {
        if (!is_array($department)) {
            $department = [];
        }
        if (!is_array($employees)) {
            $employees = [];
        }
        $sql = [];
        if ($department) {
            $sql[] = ' `payroll_employee`.`department` IN (\'' . implode('\', \'', $department) . '\')';
        }
        if ($employees) {
            $sql[] = ' `payroll_employee`.`employee_id` IN (\'' . implode('\', \'', $employees) . '\')';
        }
        $department = array_filter($department, 'trim');
        $employees = array_filter($employees, 'trim');
        $query = "SELECT
        `payroll_employee`.*,
        `arrears`.`arrears`,
        `advances`.`advances`,
        `incentives`.`incentives`,
        `ncns`.`ncns` as `ncns_penalty`,
        `others`.`others`
      FROM
        `payroll_employee`
        LEFT JOIN `payroll` ON `payroll_employee`.`payroll_id` = `payroll`.`id`
        LEFT JOIN(
          SELECT
            `employee_id`,
            `payroll_id`,
            SUM(`value`) AS `arrears`
          FROM
            `payroll_adjustments`
          WHERE
            `column` = 'arrears'
          GROUP BY
            `payroll_id`, `employee_id`
        ) AS `arrears` ON `payroll_employee`.`employee_id` = `arrears`.`employee_id` AND `arrears`.`payroll_id` = `payroll_employee`.`payroll_id`
        LEFT JOIN(
          SELECT
            `employee_id`,
            `payroll_id`,
            SUM(`value`) AS `advances`
          FROM
            `payroll_adjustments`
          WHERE
            `column` = 'advances'
          GROUP BY
            `payroll_id`, `employee_id`
        ) AS `advances` ON `payroll_employee`.`employee_id` = `advances`.`employee_id` AND `advances`.`payroll_id` = `payroll_employee`.`payroll_id`
        LEFT JOIN(
          SELECT
            `employee_id`,
            `payroll_id`,
            SUM(`value`) AS `incentives`
          FROM
            `payroll_adjustments`
          WHERE
            `column` = 'incentives'
          GROUP BY
            `payroll_id`, `employee_id`
        ) AS `incentives` ON `payroll_employee`.`employee_id` = `incentives`.`employee_id` AND `incentives`.`payroll_id` = `payroll_employee`.`payroll_id`
        LEFT JOIN(
          SELECT
            `employee_id`,
            `payroll_id`,
            SUM(`value`) AS `ncns`
          FROM
            `payroll_adjustments`
          WHERE
            `column` = 'ncns'
          GROUP BY
            `payroll_id`, `employee_id`
        ) AS `ncns` ON `payroll_employee`.`employee_id` = `ncns`.`employee_id` AND `ncns`.`payroll_id` = `payroll_employee`.`payroll_id`
        LEFT JOIN(
          SELECT
            `employee_id`,
            `payroll_id`,
            SUM(`value`) AS `others`
          FROM
            `payroll_adjustments`
          WHERE
            `column` = 'others'
          GROUP BY
            `payroll_id`, `employee_id`
        ) AS `others` ON `payroll_employee`.`employee_id` = `others`.`employee_id` AND `others`.`payroll_id` = `payroll_employee`.`payroll_id`
      WHERE
      `payroll`.`type` = 'payroll'
      AND `payroll`.`month` = '{$month}'
      AND `payroll`.`year` = '{$year}'
      AND `payroll`.`division_id` = '{$division_id}'
      AND `payroll`.`cfo_status` = '{$status}'";
        if ($sql) {
            $query .= " AND (" . implode(' OR ', $sql) . ")";
        }
        $query .= " ORDER BY
        `payroll_employee`.`employee_id` ASC";
        $res = $this->db->query($query)->result();
        return array_map(function ($employee) {
            $employee = decrypt_employee_data($employee, [], false, 'payroll_employee');
            $employee->actual_presents = $this->payroll->get_paid_days($employee);
            $employee->actual_absents = $employee->ncns + $employee->unpaid_leaves;
            $employee->arrears = $employee->arrears ?? 0;
            $employee->advances = $employee->advances ?? 0;
            $employee->incentives = $employee->incentives ?? 0;
            $employee->ncns_penalty = $employee->ncns_penalty ?? 0;
            $employee->others = $employee->others ?? 0;
            $employee->income_tax = 0;
            return $employee;
        }, $res);
    }
}
