<?php
class Payroll_employee_model extends CI_Model
{
    public function get_remarks_by_column($payroll_id, $employee_id, $column_name)
    {
        if ($column_name == 'net-salary') {
            return [
                (object) [
                    'user_name' => 'HRM PAYROLL SYSTEM',
                    'reason' => display('employee_is_under_training'),
                ],
            ];
        }
        $this->db
            ->where(['payroll_id' => $payroll_id, 'employee_id' => $employee_id])
            ->order_by('updated_at', 'desc');
        if ($column_name == 'all_arrears') {
            $this->db->where_in('column', ['arrears', 'advances', 'incentives']);
        } else {
            $this->db->where('column', $column_name);
        }
        return $this->db->get('payroll_adjustments')->result();
    }
    public function get_with_column($payroll_id, $employee_id, $column)
    {
        $query = $this->db->select('name, hrm_id, ' . $column)->where(['employee_id' => $employee_id, 'payroll_id' => $payroll_id])->get('payroll_employee');
        if (!$query) {
            return false;
        }
        $query = $query->row_array();
        if (!$query) {
            return false;
        }
        return $query;
    }
    public function update_with_column($payroll_id, $employee_id, $column, $column_name, $value, $reason, $old_value = 0)
    {
        $this->db->trans_start();
        $this->db->insert('payroll_update_history', [
            'payroll_id' => $payroll_id,
            'employee_id' => $employee_id,
            'column' => $column_name,
            'old_value' => $old_value,
            'value' => $value,
            'reason' => $reason,
            'user_id' => $this->session->userdata('id'),
            'user_name' => sprintf('%s (%s)', $this->session->userdata('fullname'), $this->session->userdata('hrm_id')),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function get($id, $employee_id = null)
    {
        $this->db->where('payroll_id', $id)->from('payroll_employee');
        if ($employee_id) {
            $this->db->where('employee_id', $employee_id);
            return $this->db->get()->row();
        }
        return $this->db->get()->result();
    }
}
