<?php
class Payroll_adjustment_model extends CI_Model
{
    public function get_employee_adjustments($payroll_id, $employee_id)
    {
        $recs = $this->db->where([
            'payroll_id' => $payroll_id,
            'employee_id' => $employee_id,
        ])->get('payroll_adjustments')->result();

        $data = [
            'arrears' => [],
            'advances' => [],
            'incentives' => [],
            'ncns' => [],
            'others' => [],
        ];
        foreach ($recs as $rec) {
            if (!isset($data[$rec->column])) {
                $data[$rec->column] = [];
            }
            $data[$rec->column][] = $rec;
        }
        return $data;
    }
    public function save($data)
    {
        $this->db->trans_start();
        $id = null;
        $save = [
            'payroll_id' => $data['payroll_id'],
            'employee_id' => $data['employee_id'],
            'column' => $data['column'],
            'value' => $data['value'],
            'reason' => htmlspecialchars($data['reason']),
            'type' => 'user',
            'user_id' => $this->session->userdata('id'),
            'user_name' => $this->session->userdata('fullname'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];
        $save = array_filter($save, function ($va) {
            return !empty($va);
        });
        if (empty(trim($data['id']))) {
            $this->db->insert('payroll_adjustments', $save);
            $id = $this->db->insert_id();
            $this->activity
                ->set_employee($data['employee_id'])
                ->set_payroll($data['payroll_id'])
                ->log([
                    'adjustment_added',
                    $data['value'],
                    $data['column'],
                    htmlspecialchars($data['reason']),
                ]);
        } else {
            $id = $data['id'];
            $this->db->where(['id' => $id, 'type' => 'user'])->update('payroll_adjustments', $save);
            $adjust_rec = $this->db->where('id', $id)->get('payroll_adjustments')->row();
            $this->activity
                ->set_employee($adjust_rec->employee_id)
                ->set_payroll($adjust_rec->payroll_id)
                ->log([
                    'adjustment_updated',
                    $data['value'],
                    $adjust_rec->column,
                    htmlspecialchars($data['reason']),
                ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status() ? $id : null;
    }
    public function delete($id)
    {
        $this->db->trans_start();
        $adjust_rec = $this->db->select('column, value, payroll_id, employee_id')->where('id', $id)->get('payroll_adjustments')->row();
        $this->db->where(['id' => $id, 'type' => 'user'])->delete('payroll_adjustments');
        $this->activity
            ->set_employee($adjust_rec->employee_id)
            ->set_payroll($adjust_rec->employee_id)
            ->log([
                'adjustment_deleted',
                $adjust_rec->value,
                $adjust_rec->column,
            ]);
        $this->db->trans_complete();
        return $this->db->trans_status() ? $id : null;
    }
}
