<?php
class Preview extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'preview_model' => 'preview',
            'payroll_model' => 'payroll',
        ]);
    }
    function as () {
        $this->permission->method('viewas_payroll', 'read')->redirect();
        $data['employees'] = get_all_employees();
        $data['departments'] = get_all_departments();
        $data['divisions'] = get_all_divisions();
        $data['months'] = [
            'january',
            'february',
            'march',
            'april',
            'may',
            'june',
            'july',
            'august',
            'september',
            'october',
            'november',
            'december',
        ];
        $year = date('Y');
        $data['years'] = range($year - 10, $year + 10);
        $data['title'] = display('viewas_payroll');
        $data['module'] = "payroll";
        $data['page'] = "preview/as";
        echo Modules::run('template/layout', $data);
    }
    public function view($slug)
    {
        $this->permission->method('viewas_payroll', 'read')->redirect();
        $slug = json_decode(base64_decode($slug), true);
        $employees = $this->preview->get_employees(
            @$slug['month'],
            @$slug['year'],
            @$slug['division'],
            @$slug['status'],
            @$slug['department'],
            @$slug['employee'],
        );

        $payroll = $this->payroll->get($employees[0]->payroll_id);
        if (!$payroll) {
            show_404();
        }
        $data['payroll'] = $payroll;
        $data['employees'] = $employees;
        $data['employee_attendance'] = $this->payroll->get_payroll_attendance($payroll->id, array_column($employees, 'employee_id'));
        $data['employee_leaves'] = $this->payroll->get_payroll_leaves($payroll->id, array_column($employees, 'employee_id'));
        $data['employee_special_leaves'] = $this->payroll->get_payroll_special_leaves($payroll->id, array_column($employees, 'employee_id'));

        $data['month_info'] = month_first_last_day(date('m', strtotime($payroll->month)), $payroll->year);
        $data['date_array'] = date_range($payroll->start, $payroll->end, '+1 day', 'Y-m-d');
        $data['month_array'] = date_range($payroll->year . '-01-01', $payroll->year . '-12-31', '+1 month', 'M-Y');
        $data['day_range'] = count($data['date_array']);

        $data['title'] = sprintf('%s - %s, %s', $payroll->division, ucfirst($payroll->month), $payroll->year);
        $data['module'] = "payroll";
        $data['page'] = 'preview/view';
        echo Modules::run('template/layout', $data);
    }
    public function check()
    {
        $this->permission->method('viewas_payroll', 'read')->redirect();
        $rules_config = array(
            array(
                'field' => 'division',
                'label' => 'Employee',
                'rules' => 'trim|required|is_natural',
            ),
            array(
                'field' => 'month',
                'label' => 'Month',
                'rules' => 'trim|required|in_list[january,february,march,april,may,june,july,august,september,october,november,december]',
            ),
            array(
                'field' => 'year',
                'label' => 'Year',
                'rules' => 'trim|required',
            ),
            array(
                'field' => 'status',
                'label' => 'Type',
                'rules' => 'trim|required|in_list[pending,approved]',
            ),
        );
        if (!$this->input->post('employee') && !$this->input->post('department')) {
            sendJson(['error' => 'Employee or Department, please select at least one of the filter']);
        }
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            sendJson(['error' => validation_errors()]);
        }
        if ($this->preview->check(
            $this->input->post('month'),
            $this->input->post('year'),
            $this->input->post('division'),
            $this->input->post('status'),
            $this->input->post('department'),
            $this->input->post('employee'),
        )) {
            sendJson(['success' => base_url('payroll/preview/view/') . trim(base64_encode(json_encode($this->input->post())), '=')]);
        } else {
            sendJson(['error' => 'No payroll record found for the selected filters']);
        }
        sendJson(['error' => 'Unable to perform this request, try again later']);
    }
}
