<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Payroll extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'payroll_model' => 'payroll',
            'payroll_ajax_model' => 'payroll_ajax',
            'Payroll_employee_model' => 'payroll_employee',
            'Payroll_adjustment_model' => 'payroll_adjustments',
        ]);
    }
    public function pending()
    {
        $this->permission->method('pending_payroll', 'read')->redirect();
        if ($this->input->post()) {
            $this->get_pending_datatable();return;
        }
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['months'] = [
            'january',
            'february',
            'march',
            'april',
            'may',
            'june',
            'july',
            'august',
            'september',
            'october',
            'november',
            'december',
        ];
        $year = date('Y');
        $data['years'] = range($year - 10, $year + 10);
        $data['title'] = display('pending_payroll');
        $data['module'] = "payroll";
        $data['page'] = "payroll/list";
        echo Modules::run('template/layout', $data);
    }
    public function approved()
    {
        $this->permission->method('approved_payroll', 'read')->redirect();
        if ($this->input->post()) {
            $this->get_approved_datatable();return;
        }
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['months'] = [
            'january',
            'february',
            'march',
            'april',
            'may',
            'june',
            'july',
            'august',
            'september',
            'october',
            'november',
            'december',
        ];
        $year = date('Y');
        $data['years'] = range($year - 10, $year + 10);
        $data['title'] = display('approved_payroll');
        $data['module'] = "payroll";
        $data['page'] = "payroll/approved_list";
        echo Modules::run('template/layout', $data);
    }
    public function view($id)
    {
        $payroll = $this->payroll->get($id);
        if (!$payroll) {
            show_404();
        }
        if ($payroll->hr_status != 'approved' && !$this->permission->method('pending_payroll', 'read')->access()) {
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($payroll->hr_status == 'approved' && !$this->permission->method('approved_payroll', 'read')->access()) {
            redirect($_SERVER['HTTP_REFERER']);
        }

        if ($payroll->processed != 'done') {
            redirect('payroll/pending');
        }
        $data['payroll'] = $payroll;
        $data['employees'] = $this->payroll->get_payroll_employees($id);
        $data['inactive_employees'] = $this->payroll->get_payroll_employees($id, false);
        $data['employee_attendance'] = $this->payroll->get_payroll_attendance($id);
        $data['employee_leaves'] = $this->payroll->get_payroll_leaves($id);
        $data['employee_special_leaves'] = $this->payroll->get_payroll_special_leaves($id);
        if ($payroll->cfo_status == 'amendments-required') {
            $data['cfo_comments'] = $this->db->where('payroll_id', $id)->order_by('added_at', 'desc')->get('payroll_comments')->row();
        }
        $data['month_info'] = month_first_last_day(date('m', strtotime($payroll->month)), $payroll->year);
        $data['date_array'] = date_range($payroll->start, $payroll->end, '+1 day', 'Y-m-d');
        $data['month_array'] = date_range($payroll->year . '-01-01', $payroll->year . '-12-31', '+1 month', 'M-Y');
        $data['day_range'] = count($data['date_array']);

        $data['title'] = sprintf('%s - %s, %s', $payroll->division, ucfirst($payroll->month), $payroll->year);
        $data['module'] = "payroll";
        $data['page'] = $payroll->hr_status == 'pending' ? 'payroll/view' : 'payroll/approved_view';
        echo Modules::run('template/layout', $data);
    }
    public function generate()
    {
        $this->permission->method('pending_payroll', 'create')->redirect();
        if (!$this->session->userdata('isAdmin')) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'month',
                    'label' => 'Month',
                    'rules' => 'trim|required|alpha',
                ),
                array(
                    'field' => 'year',
                    'label' => 'Year',
                    'rules' => 'trim|required|is_natural_no_zero',
                ),
                array(
                    'field' => 'division',
                    'label' => 'Division',
                    'rules' => 'trim|required|is_natural_no_zero',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                foreach ($rules_config as $rule) {
                    $has_error = form_error($rule['field']);
                    if ($has_error) {
                        sendJson(['error' => $has_error]);
                    }
                }
            }
            if ($this->payroll->exists($this->input->post('month'), $this->input->post('year'), $this->input->post('division'))) {
                sendJson(['error' => 'Payroll already exists for this division, month and year']);
            }
            if ($this->payroll->queue_payroll($this->input->post('month'), $this->input->post('year'), $this->input->post('division'))) {
                sendJson(['success' => 'Payroll added']);
            }
        }
        sendJson(['error' => 'Invalid Request']);
    }
    public function regenerate()
    {
        if (!$this->permission->method('pending_payroll', 'update')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('id')) {
            if ($this->payroll->regenerate($this->input->post('id'))) {
                sendJson(['success' => 'Payroll queued for processing']);
            }
        }
        sendJson(['error' => 'Unable to queue payroll for processing, try again']);
    }
    public function adjust()
    {
        if (!($this->permission->method('pending_payroll', 'update')->access() || $this->permission->method('budget_payroll', 'update')->access())) {
            log_message('error', 'Permission denied - pending_payroll = update');
            sendJson(['error' => 'Invalid request', 'reload' => true]);
        }
        if ($this->input->is_ajax_request() && $this->input->get('payroll') && $this->input->get('row')) {
            $adjustments = $this->payroll_adjustments->get_employee_adjustments($this->input->get('payroll'), $this->input->get('row'));
            $employee = $this->payroll_employee->get($this->input->get('payroll'), $this->input->get('row'));
            sendJson(['success' => [
                'name' => sprintf('%s (%s)', $employee->name, $employee->hrm_id),
                'employee_id' => $employee->employee_id,
                'html' => preg_replace('#>[\s\n\r\t]+?<#', '><', $this->load->view('payroll/partials/adjustments', ['adjustments' => $adjustments, 'row' => $this->input->get('row')], true)),
            ]]);
        }
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'value',
                    'label' => 'Amount',
                    'rules' => 'trim|required|greater_than_equal_to[0]',
                ),
                array(
                    'field' => 'reason',
                    'label' => 'Reason',
                    'rules' => 'trim|required|min_length[5]|max_length[150]',
                ),
            );
            $_POST['value'] = preg_replace('#\,#is', '', $_POST['value']);
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                sendJson(['error' => validation_errors()]);
            }
            if ($id = $this->payroll_adjustments->save([
                'id' => $this->input->post('id'),
                'payroll_id' => $this->input->post('payroll'),
                'employee_id' => $this->input->post('row'),
                'column' => $this->input->post('column'),
                'value' => $this->input->post('value'),
                'reason' => $this->input->post('reason'),
            ])) {
                sendJson(['success' => 'Payroll item saved successfully', 'id' => $id]);
            } else {
                sendJson(['error' => 'Unable to save item, try again later']);
            }
        }
    }
    public function delete_adjustment()
    {
        if (!($this->permission->method('pending_payroll', 'delete')->access() || $this->permission->method('budget_payroll', 'delete')->access())) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('id')) {
            if ($this->payroll_adjustments->delete($this->input->post('id'))) {
                sendJson(['success' => 'Item deleted successfully']);
            } else {
                sendJson(['error' => 'Unable to delete this item, try again later']);
            }
        }
        sendJson(['error' => 'Invalid request']);
    }
    public function remarks()
    {
        if (!($this->permission->method('pending_payroll', 'read')->access() || $this->permission->method('approved_payroll', 'read')->access() || $this->permission->method('budget_payroll', 'read')->access())) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->is_ajax_request()) {
            $remarks = $this->payroll_employee->get_remarks_by_column(
                $this->input->get('payroll'),
                $this->input->get('row'),
                $this->input->get('column'),
            );
            echo $this->load->view('payroll/partials/remarks', ['remarks' => $remarks], true);
        }
    }
    private function get_pending_datatable()
    {
        $search_arr = [];
        $search_columns = [
            'payroll.id',
            'payroll.month',
            'payroll.year',
            'payroll.hr_status',
            'payroll.cfo_status',
            'payroll.processed',
            'payroll.created_at',
            'divisions.name',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->payroll_ajax->countAllRows();
        $out_arr["recordsFiltered"] = $this->payroll_ajax->countDatatable($search_arr);
        $rows = $this->payroll_ajax->getDatatable($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'month':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'processed':{
                            if ($rec[$col['data']] == 'done') {
                                $tdData = '<a class="btn btn-info btn-sm" href="' . base_url('payroll/view/' . $rec['id']) . '" role="button"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                                break;
                            }
                            $tdData = '<div class="text-center" style="width: 300px"><div class="progress" style="width:100%"><div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%"><span class="sr-only"></span></div></div>
                            <div>Status: ' . ucfirst(slug_to_readable($rec[$col['data']])) . '</div></div>';
                            break;
                        }
                    case 'hr_status':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'cfo_status':{
                            $tdData = ucfirst(slug_to_readable($rec[$col['data']]));
                            break;
                        }
                    case 'created_at':
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'export':{
                            if ($rec['processed'] == 'done') {
                                $tdData = '<a class="btn btn-info btn-sm" href="' . base_url('payroll/download/' . $rec['id'] . '/payroll') . '" role="button"><i class="fa fa-download" aria-hidden="true"></i></a>';
                            }
                            break;
                        }
                    case 'regenerate':{
                            if ($rec['processed'] != 'queued') {
                                $tdData = '<a class="btn btn-info btn-sm btn-regenerate" href="#" data-id="' . $rec['id'] . '" role="button"><i class="fa fa-recycle" aria-hidden="true"></i></a>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    private function get_approved_datatable()
    {
        $search_arr = [];
        $search_columns = [
            'payroll.id',
            'payroll.month',
            'payroll.year',
            'payroll.hr_status',
            'payroll.cfo_status',
            'payroll.processed',
            'payroll.created_at',
            'divisions.name',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->payroll_ajax->countAllRows('approved');
        $out_arr["recordsFiltered"] = $this->payroll_ajax->countDatatable($search_arr, 'approved');
        $rows = $this->payroll_ajax->getDatatable($this->input->post(), $search_arr, 'approved');
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'month':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'processed':{
                            if ($rec[$col['data']] == 'done') {
                                $tdData = '<a class="btn btn-info btn-sm" href="' . base_url('payroll/view/' . $rec['id']) . '" role="button"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                                break;
                            }
                            $tdData = '<div class="text-center" style="width: 300px"><div class="progress" style="width:100%"><div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%"><span class="sr-only"></span></div></div>
                            <div>Status: ' . ucfirst(slug_to_readable($rec[$col['data']])) . '</div></div>';
                            break;
                        }
                    case 'cfo_status':{
                            $tdData = ucfirst(slug_to_readable($rec[$col['data']]));
                            break;
                        }
                    case 'created_at':
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'export': {
                        if ($rec['processed'] == 'done') {
                            $tdData = '<a class="btn btn-info btn-sm" href="' . base_url('payroll/download/' . $rec['id'] . '/payroll') . '" role="button"><i class="fa fa-download" aria-hidden="true"></i></a>';
                        }
                        break;
                    }
                    case 'download':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Export <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];
                            if ($rec['cfo_status'] == 'approved') {
                                if ($this->permission->method('approved_payroll', 'update')->access()) {
                                    $btns[] = '<li><a href="' . base_url('payroll/download/') . $rec['id'] . '/letter" >Letter Template</a></li>';
                                }
                            }
                            if (!$btns) {
                                $tdData = '';
                                break;
                            }
                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function approve()
    {
        if ($this->input->post()) {
            if ($this->input->post('type') == 'hr' && $this->permission->method('pending_payroll', 'update')->access()) {
                if ($this->payroll->approve($this->input->post('id'), 'hr')) {
                    sendJson(['success' => 'Payroll approved successfully']);
                }
            } else if ($this->input->post('type') == 'cfo' && $this->permission->module('receive_cfo_notifications')->access()) {
                if ($this->payroll->approve($this->input->post('id'), 'cfo')) {
                    sendJson(['success' => 'Payroll approved successfully']);
                }
            } else {
                sendJson(['error' => 'Permission to approve payroll is denied']);
            }
        }
        sendJson(['error' => 'Unable to perform this action, try again later']);
    }
    public function amend()
    {
        if ($this->input->post('id') && $this->input->post('reason') && $this->permission->module('receive_cfo_notifications')->access()) {
            if ($this->payroll->amend($this->input->post('id'), $this->input->post('reason'), $this->input->post('rows'))) {
                sendJson(['success' => 'Payroll successfully updated']);
            }
        }
        sendJson(['error' => 'Unable to perform this action, try again later']);
    }
    public function download($id, $type)
    {
        if (!($this->permission->method('pending_payroll', 'read')->access() || $this->permission->method('approved_payroll', 'read')->access())) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        $payroll = $this->payroll->get($id, true);
        if (!$payroll) {
            show_404();
        }
        if ($payroll->processed != 'done' && $payroll->cfo_status != 'approved') {
            show_404();
        }
        $payroll;
        $employees = $this->payroll->get_payroll_employees($id);
        $employees = array_merge($employees, $this->payroll->get_payroll_employees($id, false));

        $data['month_info'] = month_first_last_day(date('m', strtotime($payroll->month)), $payroll->year);
        $data['date_array'] = date_range($payroll->start, $payroll->end, '+1 day', 'Y-m-d');
        $day_range = count($data['date_array']);
        if ($type == 'letter') {
            $this->payroll->generate_letter_template(sprintf('%s -Payroll-%s, %s.docx', $payroll->division, ucfirst($payroll->month), $payroll->year), $employees, $day_range);
        } else if ($type == 'payroll') {
            $this->payroll->download_excel($id, sprintf('%s -Payroll-%s, %s.docx', $payroll->division, ucfirst($payroll->month), $payroll->year));
        }
    }
}
