<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Payorder extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'payroll_ajax_model' => 'payroll_ajax',
            'payorder_model' => 'payorder',
            'payroll_model' => 'payroll',
        ]);
    }
    public function payorders($id)
    {
        $this->permission->method('payorders', 'read')->redirect();

        $payroll = $this->payroll->get($id);
        if (!$payroll) {
            show_404();
        }
        if ($payroll->cfo_status != 'approved') {
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['payroll'] = $payroll;
        $data['month_info'] = month_first_last_day(date('m', strtotime($payroll->month)), $payroll->year);
        $data['date_array'] = date_range($payroll->start, $payroll->end, '+1 day', 'Y-m-d');
        $data['month_array'] = date_range($payroll->year . '-01-01', $payroll->year . '-12-31', '+1 month', 'M-Y');
        $data['day_range'] = count($data['date_array']);

        $data['payorders'] = $this->payorder->get($id);

        $data['title'] = sprintf('Payorders: %s - %s, %s', $payroll->division, ucfirst($payroll->month), $payroll->year);
        $data['module'] = "payroll";
        $data['page'] = "payorder/payorders";
        echo Modules::run('template/layout', $data);
    }
    function list() {
        $this->permission->method('payorders', 'read')->redirect();
        if ($this->input->post()) {
            $this->get_approved_datatable();return;
        }
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['months'] = [
            'january',
            'february',
            'march',
            'april',
            'may',
            'june',
            'july',
            'august',
            'september',
            'october',
            'november',
            'december',
        ];
        $year = date('Y');
        $data['years'] = range($year - 10, $year + 10);
        $data['title'] = display('payorders');
        $data['module'] = "payroll";
        $data['page'] = "payorder/list";
        echo Modules::run('template/layout', $data);
    }
    private function get_approved_datatable()
    {
        $search_arr = [];
        $search_columns = [
            'payroll.id',
            'payroll.month',
            'payroll.year',
            'divisions.name',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        }
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->payroll_ajax->countAllRows('approved', true);
        $out_arr["recordsFiltered"] = $this->payroll_ajax->countDatatable($search_arr, 'approved', true);
        $rows = $this->payroll_ajax->getDatatable($this->input->post(), $search_arr, 'approved', true);
        foreach ($rows as $index => $rec) {
            $payorder_count = $this->db->where('payroll_id', $rec['id'])->count_all_results('payroll_payorders');
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'month':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'action':{
                            if($payorder_count > 0) {
                                $tdData = '<a class="btn btn-primary" href="' . base_url('payroll/payorder/payorders/') . $rec['id'] . '" role="button"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                            } else {
                                $tdData = '0 Payorders';
                            }
                            break;
                        }
                    case 'export':{
                        if($payorder_count > 0) {
                                $tdData = '<a class="btn btn-primary" href="' . base_url('payroll/payorder/download/') . $rec['id'] . '" role="button"><i class="fa fa-download" aria-hidden="true"></i> Download</a>';
                            } else {
                                $tdData = '0 Payorders';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function edit()
    {
        $this->permission->method('payorders', 'update')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'account_title',
                    'label' => 'Title of Account',
                    'rules' => 'strip_tags|trim|required|min_length[3]',
                ),
                array(
                    'field' => 'comments',
                    'label' => 'Comments',
                    'rules' => 'strip_tags|trim|required|min_length[3]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                sendJson(['error' => validation_errors()]);
            }
            if ($this->payorder->update(
                $this->input->post('payroll'),
                $this->input->post('row'),
                $this->input->post('account_title'),
                $this->input->post('comments'),
            )) {
                sendJson(['success' => 'Payorder updated successfully', 'reload' => true]);
            }
            sendJson(['error' => 'Unable to update payorder, try again later']);
        } else {
            $employee = $this->payorder->get_employee($this->input->get('payroll'), $this->input->get('row'));
            if ($employee) {
                sendJson(['success' => [
                    'employee_id' => $employee->employee_id,
                    'name' => $employee->name,
                    'html' => $this->load->view('payroll/partials/payorder_edit', ['employee' => $employee], true),
                ]]);
            }
        }
        sendJson(['error' => 'Unable to perform this action, try again']);
    }
    public function download($id)
    {
        $this->payorder->download($id);
    }
}
