<?php
class Budget extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'Budget_model' => 'budget',
            'payroll_ajax_model' => 'payroll_ajax',
            'payroll_model' => 'payroll',
        ]);
    }

    function list() {
        $this->permission->method('budget_payroll', 'read')->redirect();
        if ($this->input->post()) {
            $this->get_datatable();return;
        }
        $data['departments'] = $this->db->select('dept_id as id, department_name as name')->order_by('department_name')->get('department')->result();
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['employees'] = $this->db->select('employee_id as id, first_name, last_name, hrm_id')->order_by('first_name')->get('employee_history')->result();
        $data['title'] = display('budget_payroll');
        $data['module'] = "payroll";
        $data['page'] = "budget/list";
        echo Modules::run('template/layout', $data);
    }

    public function view($id)
    {
        $this->permission->method('budget_payroll', 'read')->redirect();
        $payroll = $this->budget->get($id);
        if (!$payroll) {
            show_404();
        }

        if ($payroll->processed != 'done') {
            redirect('budget/list');
        }

        $data['payroll'] = $payroll;

        $data['title'] = sprintf('%s - %s, %s', $payroll->division, ucfirst($payroll->month), $payroll->year);
        $data['page'] = 'budget/view';

        $data['employees'] = $this->payroll->get_payroll_employees($id);
        $data['inactive_employees'] = $this->payroll->get_payroll_employees($id, false);
        $data['employee_attendance'] = $this->payroll->get_payroll_attendance($id);
        $data['employee_leaves'] = $this->payroll->get_payroll_leaves($id);
        $data['employee_special_leaves'] = $this->payroll->get_payroll_special_leaves($id);
        $data['month_info'] = month_first_last_day(date('m', strtotime($payroll->month)), $payroll->year);
        $data['date_array'] = date_range($payroll->start, $payroll->end, '+1 day', 'Y-m-d');
        $years_list = interval_into_years($payroll->start, $payroll->end);
        $month_array = [];
        foreach ($years_list as $yr) {
            $mnths = date_range($yr . '-01-01', $yr . '-12-31', '+1 month', 'M-Y');
            $month_array = array_merge($month_array, $mnths);
        }
        $data['month_array'] = $month_array;
        $data['day_range'] = count($data['date_array']);
        $data['module'] = "payroll";
        echo Modules::run('template/layout', $data);
    }
    public function generate()
    {
        $this->permission->method('budget_payroll', 'create')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'start',
                    'label' => 'Start',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'end',
                    'label' => 'End',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'division',
                    'label' => 'Division',
                    'rules' => 'trim|required|is_natural_no_zero',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                foreach ($rules_config as $rule) {
                    $has_error = form_error($rule['field']);
                    if ($has_error) {
                        sendJson(['error' => $has_error]);
                    }
                }
            }
            if ($this->budget->queue(
                $this->input->post('division'),
                $this->input->post('start'),
                $this->input->post('end'),
                $this->input->post('employee'),
                $this->input->post('department'),
            )) {
                sendJson(['success' => 'Budget is being processed, please wait']);
            }
        }
        sendJson(['error' => 'Invalid Request']);
    }
    public function download($id)
    {
        $this->budget->download($id);
    }
    public function delete()
    {
        $this->permission->method('budget_payroll', 'delete')->redirect();
        if ($this->input->post('id')) {
            if ($this->budget->delete($this->input->post('id'))) {
                sendJson(['success' => 'Budget successfully removed']);
            }
        }
        sendJson(['error' => 'Unable to perform this action, try again later!']);
    }
    private function get_datatable()
    {
        $search_arr = [];
        $search_columns = [
            'payroll.id',
            'payroll.month',
            'payroll.year',
            'payroll.hr_status',
            'payroll.cfo_status',
            'payroll.processed',
            'payroll.created_at',
            'divisions.name',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->payroll_ajax->countAllRows('pending', false, 'budget');
        $out_arr["recordsFiltered"] = $this->payroll_ajax->countDatatable($search_arr, 'pending', false, 'budget');
        $rows = $this->payroll_ajax->getDatatable($this->input->post(), $search_arr, 'pending', false, 'budget');
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'month':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'processed':{
                            if ($rec[$col['data']] == 'done') {
                                $tdData = '<a class="btn btn-info btn-sm" href="' . base_url('payroll/budget/view/' . $rec['id']) . '" role="button"><i class="fa fa-eye" aria-hidden="true"></i> View</a>';
                                break;
                            }
                            $tdData = '<div class="text-center" style="width: 300px"><div class="progress" style="width:100%"><div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%"><span class="sr-only"></span></div></div>
                            <div>Status: ' . ucfirst(slug_to_readable($rec[$col['data']])) . '</div></div>';
                            break;
                        }
                    case 'start':
                    case 'end':{
                            $tdData = formatted_date($rec[$col['data']]);
                            break;
                        }
                    case 'created_at':
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'regenerate':{
                            if ($rec['processed'] != 'queued') {
                                $tdData = '<a class="btn btn-info btn-sm btn-regenerate" href="#" data-id="' . $rec['id'] . '" role="button"><i class="fa fa-recycle" aria-hidden="true"></i></a>';
                            }
                            break;
                        }
                    case 'export':{
                            if ($rec['processed'] == 'done') {
                                $tdData = '<a class="btn btn-info btn-sm" href="' . base_url('payroll/download/' . $rec['id'] . '/payroll') . '" role="button"><i class="fa fa-download" aria-hidden="true"></i> Download</a>';
                            }
                            break;
                        }
                    case 'action':{
                            $tdData = '<a class="btn btn-info btn-sm btn-delete" href="#" data-id="' . $rec['id'] . '" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
