<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Notice_model extends CI_Model
{
    public function notice_view($id = null)
    {
        $this->db->select('notice_board.*, IFNULL(rel_noticeboard_user.viewed, 0) as viewed')->from('notice_board');
        if ($this->permission->method('noticeboard', 'create')->access()) {
            $this->db->select('user.firstname');
            $this->db->join('user', 'user.id=notice_board.created_by');
        } else {
            $this->db->where('notice_board.status', 1);
        }
        if (isset($id)) {
            $this->db->where('notice_board.notice_id', $id);
        }
        if ($this->session->userdata('id')) {
            $this->db->join('rel_noticeboard_user', sprintf('notice_board.notice_id = rel_noticeboard_user.notice_id AND user_id = \'%s\'', $this->session->userdata('id')), 'left');
        }
        $result = $this->db->order_by('notice_board.notice_id', 'desc')->get()->result();
        return $result;
    }
    public function notice_create($data = array())
    {
        $res = $this->db->insert('notice_board', $data);
        if ($res) {
            $res = $this->db->insert_id();
            $this->activity->log([
                $data['status'] == 1 ? 'notice_inserted_published' : 'notice_inserted',
                $data['notice_type'],
            ]);
            return $res;
        }
        return $res;
    }
    public function notice_delete($id = null)
    {
        $notice_rec = $this->db->where('notice_id', $id)->get('notice_board')->row();
        $this->activity->log([
            $notice_rec->status ? 'notice_deleted_noticeboard' : 'notice_deleted',
            $notice_rec->notice_type,
            $id,
        ]);
        $this->db->where('notice_id', $id)
            ->delete('notice_board');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_notice($data = array())
    {
        $notice_rec = $this->db->where('notice_id', $data['notice_id'])->get('notice_board')->row();
        if ($notice_rec->status == 0 && @$data['status'] == 1) {
            $this->activity->log([
                'notice_updated_published',
                $notice_rec->notice_type,
                $notice_rec->notice_id,
            ]);
        } else {
            $this->activity->log([
                'notice_updated',
                $notice_rec->notice_type,
                $notice_rec->notice_id,
            ]);
        }
        return $this->db->where('notice_id', $data["notice_id"])
            ->update("notice_board", $data);
    }
    public function notice_updateForm($id)
    {
        $this->db->where('notice_id', $id);
        $query = $this->db->get('notice_board');
        return $query->row();
    }
    public function details($id)
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->where('notice_id', $id)
            ->get()
            ->result();
    }
    public function email($id)
    {
        $notice = @$this->details($id)[0];

        if (!$notice) {
            return false;
        }
        $attachments = null;
        if ($notice->notice_attachment) {
            $attachments = [preg_replace('#[^\w\d]+#', ' ', $notice->notice_type) . '.' . pathinfo($notice->notice_attachment, PATHINFO_EXTENSION) => FCPATH . ltrim($notice->notice_attachment, '.\\\/')];
        }
        return $this->template_mail->send_everyone(
            null,
            $notice->notice_type,
            $notice->notice_descriptiion,
            $attachments,
        );
    }
    public function get_unread($id = null, $type = 'rows')
    {
        if (!$id) {
            $id = $this->session->userdata('id');
        }
        $query = $this->db->query("SELECT * FROM (SELECT notice_board.notice_id, notice_board.status, IFNULL(viewed, 0) as viewed FROM notice_board
        LEFT JOIN rel_noticeboard_user ON notice_board.notice_id = rel_noticeboard_user.notice_id AND rel_noticeboard_user.user_id = ?
        UNION
        SELECT notice_board.notice_id, notice_board.status, IFNULL(viewed, 0) as viewed FROM notice_board
        RIGHT JOIN rel_noticeboard_user ON notice_board.notice_id = rel_noticeboard_user.notice_id AND rel_noticeboard_user.user_id = ?) as t
        WHERE viewed <> 1 AND status = 1;", [$id, $id]);

        switch ($type) {
            case 'count':
                return $query->num_rows();
                break;
            default:
                return $query->result();
                break;
        }
    }
    public function mark_read($notice_id, $user_id)
    {
        $this->db->trans_start();
        $exists = $this->db->select('viewed')->where([
            'notice_id' => $notice_id,
            'user_id' => $user_id,
        ])->get('rel_noticeboard_user')->row();
        if ($exists) {
            $this->db->where([
                'notice_id' => $notice_id,
                'user_id' => $user_id,
            ])->update('rel_noticeboard_user', [
                'viewed' => 1,
            ]);
        } else {
            $this->db->insert('rel_noticeboard_user', [
                'notice_id' => $notice_id,
                'user_id' => $user_id,
                'viewed' => 1,
            ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function get($page, $limit = 10, $user_id = null, $type = 'rows')
    {
        if (!$user_id) {
            $user_id = $this->session->userdata('id');
        }
        $page *= $limit;
        $query = $this->db
            ->select('notice_board.notice_id as id, notice_board.notice_type as title, IFNULL(rel_noticeboard_user.viewed, 0) as viewed')
            ->where([
                'notice_board.status' => 1,
            ])
            ->join('rel_noticeboard_user', sprintf('notice_board.notice_id=rel_noticeboard_user.notice_id AND rel_noticeboard_user.user_id = \'%s\'', $user_id), 'left')
            ->order_by('notice_board.notice_date', 'desc')
            ->limit($limit, $page)
            ->from('notice_board');
        if($type == 'count') {
            return $query->count_all_results();
        } else {
            return $query->get()->result();
        }
    }
}
