<?php defined('BASEPATH') or exit('No direct script access allowed');
class Myupload
{
    private $_messages = array(
        UPLOAD_ERR_INI_SIZE => 'upload_file_exceeds_limit',
        UPLOAD_ERR_FORM_SIZE => 'upload_file_exceeds_form_limit',
        UPLOAD_ERR_PARTIAL => 'upload_file_partial',
        UPLOAD_ERR_NO_TMP_DIR => 'upload_no_temp_directory',
        UPLOAD_ERR_CANT_WRITE => 'upload_unable_to_write_file',
        UPLOAD_ERR_EXTENSION => 'upload_stopped_by_extension',
    );
    // To load this model
    // $this->fileupload->do_upload($upload_path = 'assets/images/profile/', $field_name = 'userfile');
    public function do_upload($upload_path = null, $field_name = null, $any_file = false)
    {
        $ci = &get_instance();
        $ci->lang->load('upload');
        if ($_FILES[$field_name]['error'] == UPLOAD_ERR_NO_FILE) {
            return [
                'status' => 'empty',
            ];
        } elseif (in_array($_FILES[$field_name]['error'], array_keys($this->_messages))) {
            return [
                'status' => 'error',
                'messaged' => $ci->lang->line($this->_messages[$_FILES[$field_name]['error']]),
            ];
        } elseif ($_FILES[$field_name]['error'] == UPLOAD_ERR_OK) {
            $ci->load->helper('url');
            //folder upload
            $file_path = $upload_path . date('Y-m-d') . "/";
            if (!is_dir($file_path)) {
                mkdir($file_path, 0755, true);
            }
            //ends of folder upload
            //set config
            $config = [
                'upload_path' => $file_path,
                'allowed_types' => $any_file ? '*' : 'pdf|docx|rtf|jpg|png|jpeg|gif',
                'overwrite' => false,
                'max_size' => $this->get_ini_limit() / 1000,
                'encrypt_name' => false,
                'remove_spaces' => true,
                'file_ext_tolower' => true,
            ];
            $ci->load->library('upload', $config);
            if (!$ci->upload->do_upload($field_name)) {
                log_message('error', json_encode($ci->upload->display_errors()));
                return [
                    'status' => 'error',
                    'message' => $ci->upload->display_errors(),
                ];
            } else {
                $file = $ci->upload->data();
                if (in_array(pathinfo(strtolower($file['file_name']), PATHINFO_EXTENSION), ['php', 'exe'])) {
                    @file_put_contents(APPPATH . 'logs/upload.log', date('Ymd-H:i:s') . '| PHP,EXE File is not allowed' . "\n", FILE_APPEND);
                    @unlink($file_path . $file['file_name']);
                    return [
                        'status' => 'error',
                        'message' => $ci->lang->line('upload_invalid_filetype'),
                    ];
                }
                return [
                    'status' => 'success',
                    'file' => $file_path . $file['file_name'],
                ];
            }
        } else {
            return [
                'status' => 'error',
                'message' => $ci->lang->line('upload_unable_to_write_file'),
            ];
        }
    }
    public function do_resize($file_path = null, $width = null, $height = null)
    {
        $ci = &get_instance();
        $ci->load->library('image_lib');
        $config = [
            'image_library' => 'gd2',
            'source_image' => $file_path,
            'create_thumb' => false,
            'maintain_ratio' => false,
            'width' => $width,
            'height' => $height,
        ];
        $ci->image_lib->initialize($config);
        $ci->image_lib->resize();
    }
    public function get_ini_limit()
    {
        $upload_limits = [ini_get('post_max_size'), ini_get('upload_max_filesize'), ini_get('memory_limit')];
        $upload_limits = array_filter($upload_limits);
        $upload_limits = array_map(function ($str) {
            $unit = strtoupper(substr($str, -1));
            if (in_array($unit, ['K', 'M', 'G'])) {
                $str = intval(str_replace($unit, '', $str));
                $loop = [
                    'K' => 1,
                    'M' => 2,
                    'G' => 3,
                ];
                for ($i = 1; $i <= $loop[$unit]; $i++) {
                    $str *= 1000;
                }
            }
            return $str;
        }, $upload_limits);
        return min($upload_limits);
    }
}
