<?php
$readonly = true;
if ($data['hr_status'] != 'pending') {
    $readonly = true;
} elseif(in_array($data['employee_id'], $subordinates) && $data['supervisor_status'] == 'pending'){
    $readonly = false;
    
} elseif ($this->permission->method('leave_application', 'update')->access() && $data['supervisor_id'] != $this->session->userdata('employee_id')){
    $readonly = false;
}
$is_half_day = reset($applied_details) == 'half_day';
?>
<script>
    window.leave_pattern = []
</script>
<div class="row">
     <div class="col-sm-12 col-md-12">
         <div class="panel">
             <div class="panel-heading">
                 <div class="panel-title">
                 </div>
             </div>
             <div class="panel-body">
                 <?= form_open_multipart('#') ?>
                 <div class="form-group row">
                     <label for="employee_id"
                         class="col-sm-2 col-form-label"><?php echo display('employee_name') ?></label>
                     <div class="col-sm-4">
                         <input type="text" name="employee_name" class="form-control"
                             value="<?= $data['employee_fullname']?>" readonly>
                        <input type="hidden" name="employee_id" value="<?= $data['employee_id'] ?>">
                     </div> <label for="leave_type"
                         class="col-sm-2 col-form-label"><?php echo display('leave_type') ?></label>
                     <div class="col-sm-4">
                         <input type="text" class="form-control" value="<?= $data['leave_name']?>" readonly>
                     </div>
                 </div>
                 <div>&nbsp;</div>
                 <div class="form-group row">
                     <!-- for leave leave type -->
                     <label for="apply_strt_date" class="col-sm-2 col-form-label">
                         <?php echo display('apply_strt_date') ?> </label>
                     <div class="col-sm-4">
                         <input type="text" name="apply_strt_date" class="form-control apply_start" id="apply_start"
                             placeholder="<?php echo display('apply_strt_date') ?>"
                             value="<?= formatted_date($data['apply_strt_date']) ?>" disabled>
                     </div>
                     <?php if(!$is_half_day): ?>
                     <label for="apply_end_date" class="col-sm-2 col-form-label">
                         <?php echo display('apply_end_date') ?></label>
                     <div class="col-sm-4">
                         <input type="text" name="apply_end_date" class="form-control apply_end" id="apply_end"
                             value="<?= formatted_date($data['apply_end_date']) ?>"
                             placeholder="<?php echo display('apply_end_date') ?>" disabled>
                     </div>
                     <?php endif?>
                 </div>
                 <?php if(!$is_half_day): ?>
                 <div class="form-group row">
                     <label for="apply_day" class="col-sm-2 col-form-label">
                         <?php echo display('apply_day') ?> </label>
                     <div class="col-sm-4">
                         <input type="text" name="apply_day" class="form-control apply_day" id="apply_day"
                             value="<?php echo $data['apply_day'] ?>" placeholder="<?php echo display('apply_day') ?>"
                             readonly>
                     </div>
                 </div>
                 <?php endif?>
                 <div class="row">
                    <div class="col-md-3"></div>
                    <div class="col-md-6">
                        <table class="table">
                            <caption>Application Detail</caption>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Day</th>
                                    <th>Half / Full Day</th>
                                </tr>
                            </thead>
                            <tbody id="apply_table">
                                <?php foreach ($applied_days['days'] as $day) :?>
                                    <tr>
                                        <td scope="row"><?= $day['num'] ?></td>
                                        <td><?= $day['day'] ?></td>
                                        <td><?= slug_to_readable($applied_details[$day['day']] ?? $day['label'] ?? 'full_day') ?></td>
                                    </tr>
                                    <script>window.leave_pattern.push('<?= $applied_details[$day['day']] ?? 'full_day' ?>')</script>
                                <?php endforeach ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                 <div class="form-group row">
                     <label for="reason" class="col-sm-2 col-form-label"><?php echo display('reason') ?></label>
                     <div class="col-sm-10">
                         <textarea name="reason" class="form-control" placeholder="<?php echo display('reason') ?>"
                             disabled="disabled"><?php echo $data['reason'];?></textarea>
                     </div>
                 </div>
                 <?php  if($this->permission->method('leave_application','update')->access() || $this->session->userdata('supervisor')==1){?>
                 <div class="form-group row">
                     <label for="leave_aprv_strt_date" class="col-sm-2 col-form-label required">
                         <?php echo display('leave_aprv_strt_date') ?></label>
                     <div class="col-sm-4">
                         <input type="text" name="leave_aprv_strt_date"
                             class="datepicker form-control leave_aprv_strt_date"
                             value="<?= $data['leave_aprv_strt_date'] ? formatted_date($data['leave_aprv_strt_date']) : formatted_date($data['apply_strt_date']) ?>"
                             id="leave_aprv_strt_date" placeholder="<?php echo display('leave_aprv_strt_date') ?>" <?= $readonly ? 'readonly' : null ?>>
                     </div>
                     <?php if(!$is_half_day) :?>
                     <label for="leave_aprv_end_date" class="col-sm-2 col-form-label required">
                         <?php echo display('leave_aprv_end_date') ?></label>
                     <div class="col-sm-4">
                         <input type="text" name="leave_aprv_end_date"
                             class="datepicker form-control leave_aprv_end_date"
                             value="<?= $data['leave_aprv_end_date'] ? formatted_date($data['leave_aprv_end_date']) : formatted_date($data['apply_end_date']) ?>"
                             id="leave_aprv_end_date" placeholder="<?php echo display('leave_aprv_end_date') ?>" <?= $readonly ? 'readonly' : null ?>>
                     </div>
                     <?php endif ?>
                 </div>
                 <div class="form-group row">
                     <?php if(!$is_half_day) : ?>
                     <label for="num_aprv_day" class="col-sm-2 col-form-label required">
                         <?php echo display('num_aprv_day') ?></label>
                     <div class="col-sm-4">
                         <input type="text" name="num_aprv_day" class="form-control num_aprv_day" id="num_aprv_day"
                             placeholder="<?php echo display('num_aprv_day') ?>"
                             value="<?php echo $data['num_aprv_day'] ?>" readonly>
                     </div>
                     <?php endif?>
                     <?php  if($this->session->userdata('isAdmin')==1){?>
                     <label for="approved_by" class="col-sm-2 col-form-label">
                         <?php echo display('approved_by') ?></label>
                     <div class="col-sm-4">     
                     <?php $supervisor = null;
                     foreach ($supr as $value) {
                         if($value->employee_id == $data['supervisor_id']){
                             $supervisor = $value;
                         }
                     } ?>                   
                        <input type="hidden" name="approved_by" class="form-control" value="<?= $supervisor->employee_id ?? 0;?>">
                        <input type="text" class="form-control" value="<?php echo $supervisor->first_name.' '.$supervisor->last_name;?>" disabled>
                     </div>
                    <?php } ?>
                 </div>
                 <div class="row" <?= isset($approved_days) ? null : 'style="display: none;"' ?>>
                    <div class="col-md-3"></div>
                    <div class="col-md-6">
                        <table class="table">
                            <thead>
                                <caption>Select Leave Type</caption>
                                <tr>
                                    <th>#</th>
                                    <th>Day</th>
                                    <th>Half / Full Day</th>
                                </tr>
                            </thead>
                            <tbody id="approve_table">
                                <?php if(isset($approved_days)) :?>
                                    <?php foreach ($approved_days['days'] as $day) :?>
                                        <tr>
                                            <td scope="row"><?= $day['num'] ?></td>
                                            <td><?= $day['day'] ?></td>
                                            <td>
                                                <?php if($day['num']) :?>
                                                    -
                                                <?php else: ?>
                                                    <?= $day['label'] ?? 'Full Day' ?>
                                                <?php endif ?>
                                            </td>
                                        </tr>
                                    <?php endforeach ?>
                                <?php endif?>
                            </tbody>
                        </table>
                    </div>
                </div>
                 <?php } ?>
                 <?php if($data['apply_hard_copy']):
                    $data['apply_hard_copy'] = json_decode($data['apply_hard_copy']);
                    ?>
                    <div class="form-group row">
                        <label for="" class="col-sm-2 col-form-label"><?php echo display('attachments') ?></label>
                        <div class="col-sm-10">
                            <ol>
                    <?php foreach ($data['apply_hard_copy'] as $hard_copy):?>
                        <li><a href="<?= base_url(writepath_uri() . $hard_copy->path) ?>"><?= $hard_copy->name ?></a></li>
                    <?php endforeach ?>
                            </ol>
                        </div>
                    </div>
                 <?php endif?>
                 <?php if(!$readonly): ?>
                    <div class="form-group text-right">
                        <button type="button" name="action" value="approve" class="btn btn-success w-md m-b-5"><?= ($this->permission->method('leave_application','update')->access() || $this->session->userdata('supervisor')==1) ? 'Approve' : display('update') ?></button>
                        <button type="button" name="action" class="btn btn-danger w-md m-b-5" style="background-color: #d04f58;" value="reject">Reject</button>
                    </div>
                <?php endif ?>
                 <?php echo form_close() ?>
             </div>
         </div>
     </div>
 </div>
<script>
    <?php if ($data['hr_status'] == 'pending'): ?>
    $(document).ready(function () {
        $('.leave_aprv_strt_date, .leave_aprv_end_date').trigger('change')
    });
    <?php endif ?>
    window.leaves_available = <?= $leaves_stats['quota'] - $leaves_stats['availed'] ?>;
    var leave_day_type = "<?= $is_half_day ? 'half_day' : 'full_day' ?>";
    $('.leave_aprv_strt_date, .leave_aprv_end_date').on('change', function() {
        let start = $('[name=leave_aprv_strt_date]').val();
        let end = $('[name=leave_aprv_end_date]').val();
        let emp = $('[name=employee_id]').val();
        let leave_type = $('[name=leave_type_id]').val();
        var $this = $(this)
        if(start && (leave_day_type == 'half_day' || end)) {
            myajax({
                type: 'POST',
                url: "<?= base_url('leave/leave/calculate') ?>",
                data: {
                    start: start,
                    end: leave_day_type == 'half_day' ? start : end,
                    employee_id: '<?= $data['employee_id'] ?>',
                    type: '<?= $data['leave_type_id'] ?>',
                    leave_day_type: leave_day_type
                },
                beforeSend: function() {
                    $('#approve_table').html('')
                },
                success: function(res) {
                    if(res.success) {
                        var $tbl = $('#approve_table');
                        $tbl.closest('.row').css('display', 'block');
                        let select_count = 0
                        let html = '';
                        res.success.days.forEach(day => {
                            html += `<tr><td scope="row">${day.num}</td><td>${day.day}</td><td>`;
                            if(day.label) {
                                html += day.label
                            } else {
                                let selected_val = ''
                                if(window.leave_pattern) {
                                    selected_val = window.leave_pattern[select_count]
                                }
                                html += `${leave_day_type == 'half_day' ? 'Half Day' : 'Full Day'}`
                            }
                            select_count++
                            html += '</td></tr>';
                        });
                        $tbl.html(html)
                        $('[name=num_aprv_day]').val(res.success.count)
                        $tbl.find('select').last().trigger('change')
                    }  else if (res.error) {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            res.error,
                            'error'
                        )
                        $this.val('')
                    } else {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            'Invalid response from server, please check your internet connection',
                            'error'
                        )
                    }
                }
            })
        }
    });
    $('.leave_aprv_strt_date').on('change', function() {
        $('.leave_aprv_end_date').datepicker( "option", "minDate", $(this).datepicker("getDate"));
    })
    $('form').on('change', 'select', function(e) {
        e.preventDefault()
        let $table = $(this).closest('tbody')
        let $field = $('[name=num_aprv_day]');
        let sum = 0;
        $table.find('select').each((i, elem) => {
            if(elem.value == 'full_day') {
                sum += 1
            }
            if(elem.value == 'half_day') {
                sum += 0.5
            }
        })
        $field.val(sum)
        if(sum > window.leaves_available) {
            $(this).val('half_day').trigger('change')
            if(!e.isTrigger) {
                Swal.fire(
                    '<?= display('error') ?>!',
                    'Leave selection exceeds available leaves, changing it to Half-Day',
                    'error'
                )
            }
        }
    })
    $('button[name=action]').on('click', function(e) {
        e.preventDefault()
        var $form = $(this).closest('form')
        myajax({
            type: "POST",
            data: $form.serialize() + '&action=' + this.value + '&leave_day_type=' + leave_day_type,
            beforeSend: function() {
                $form.find('span.error').remove()
            },
            success: function (res) {
                if(res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else if(res.errors) {
                    res.errors.forEach(err => {
                        let elem = $form.find(`[name=${err[0]}]`)
                        elem.parent().append(`<span class="error">${err[1]}</span>`)
                        elem.one('change', function() {
                            $(this).parent().find('span.error').remove()
                        })
                    });
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Invalid response from server, please check your internet connection',
                        'error'
                    )
                }
                if(res.reload) {
                    location.reload()
                }
                if(res.redirect) {
                    location.href = res.redirect
                }
            }
        });
    })
</script>