<?php $this->load->view('dashboard/partials/angular') ?>
<script src="<?=base_url('assets/js/app/app.js')?>"></script>
<script>
hrmApp.controller('leave_application_ctrl', function($scope) {
    <?php if(!($this->session->userdata('isAdmin')==1 || $this->session->userdata('supervisor')==1 || $this->permission->full('leave')->access())): ?>
        $scope.employee_id = '<?= $this->session->userdata('employee_id') ?>';
    <?php endif ?>
    $scope.leaves_available = 0;
    $scope.leave_day_type = 'full_day';
    $scope.leavetypechange = function() {
        let $modal = $('#add.modal');
        if($scope.employee_id && $scope.leave_type) {
            myajax({
                url: "<?php echo base_url('leave/Leave/free_leave') ?>",
                method: 'post',
                dataType: 'json',
                data: {
                    'employee_id': $scope.employee_id,
                    'leave_type': $scope.leave_type
                },
                beforeSend: function() {
                    $('#apply_table').html('');
                    $('#approve_table').html('');
                },
                success: (data) => {
                    $scope.apply_start = '';
                    $scope.leave_aprv_strt_date = '';
                    $scope.leaves_available = data.due - data.enjoy;
                    $scope.leaves_consumed = data.enjoy;
                    $scope.$digest();
                }
            });
        }
    }
    $scope.form_state = function(field_name) {
        switch (field_name) {
            case 'employee_id':{
                $scope.leave_type = null;
                setTimeout(() => {
                    $('[name=leave_type_id]').parent('div').find('.select2-selection__rendered').text('Select One...')
                }, 200);
            }
            case 'leave_type': {
                $scope.leaves_available = 0
            }
            case 'leave_day_type': {
                $scope.half_day_hide = $scope.leave_day_type == 'half_day';
                $scope.apply_start = null;
                $scope.leave_aprv_strt_date = null;
            }
            case 'apply_start': {
                if($scope.apply_start) {
                    break;
                }
                $scope.apply_end = null;
            }
            case 'apply_end': {
                $scope.show_apply_table = false;
                $scope.apply_day = 0;
            }
            case 'leave_aprv_strt_date': {
                $scope.leave_aprv_end_date = null;
            }
            case 'leave_aprv_end_date': {
                $scope.show_approve_table = false;
                $scope.num_aprv_day = 0;
            }
        }
    }
    $scope.applied_days = function(field_name) {
        if($scope.apply_start && ($scope.leave_day_type == 'half_day' || $scope.apply_end) && $scope.employee_id && $scope.leave_type) {
            myajax({
                type: 'POST',
                url: "<?= base_url('leave/leave/calculate') ?>",
                data: {
                    start: $scope.apply_start,
                    end: $scope.leave_day_type == 'full_day' ? $scope.apply_end : $scope.apply_start,
                    employee_id: $scope.employee_id,
                    type: $scope.leave_type
                },
                beforeSend: function() {
                    $('#apply_table').parent('.row').hide();
                    $('#apply_table').html('');
                },
                success: function(res) {
                    if(res.success) {
                        var $tbl = $('#apply_table');
                        $tbl.parent('.row').show();
                        var html = '';
                        var count = 0;
                        res.success.days.forEach(day => {
                            let class_name = '';
                            if(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'].includes(day.label)) {
                                class_name = 'weekend'
                            } else if(day.label) {
                                class_name = 'holiday'
                            } else {
                                class_name = 'vacant';
                                count++;
                            }

                            html += `<div class="col-sm-2 leave_pill"><span>${day.day}</span><span class="${class_name}">${day.label ? day.label : 'Day ' + count}</span></div>`
                        });
                        $tbl.append(html)
                        $scope.apply_day = res.success.count;
                        $scope.show_apply_table = true;
                        $scope.$digest()
                    }  else if (res.error) {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            res.error,
                            'error'
                        )
                        if(field_name == 'apply_start') {
                            $scope.apply_start = null;
                        } else {
                            $scope.apply_end = null
                        }
                    } else {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            'Invalid response from server, please check your internet connection',
                            'error'
                        )
                    }
                    $scope.$digest()
                }
            })
        }
    }
    $scope.approved_days = function(field_name) {
        $scope.show_approve_table = false;
        if($scope.leave_aprv_strt_date && ($scope.leave_day_type == 'half_day' || $scope.leave_aprv_end_date) && $scope.employee_id && $scope.leave_type) {
            myajax({
                type: 'POST',
                url: "<?= base_url('leave/leave/calculate') ?>",
                data: {
                    start: $scope.leave_aprv_strt_date,
                    end: $scope.leave_day_type == 'full_day' ? $scope.leave_aprv_end_date : $scope.leave_aprv_strt_date,
                    employee_id: $scope.employee_id,
                    type: $scope.leave_type
                },
                beforeSend: function() {
                    $('#approve_table').parent('.row').hide();
                    $('#approve_table').html('')
                },
                success: function(res) {
                    if(res.success) {
                        var $tbl = $('#approve_table');
                        $tbl.parent('.row').show();
                        var html = '';
                        var count = 0;
                        res.success.days.forEach(day => {
                            let class_name = '';
                            if(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'].includes(day.label)) {
                                class_name = 'weekend'
                            } else if(day.label) {
                                class_name = 'holiday'
                            } else {
                                class_name = 'vacant';
                                count++;
                            }

                            html += `<div class="col-sm-2 leave_pill"><span>${day.day}</span><span class="${class_name}">${day.label ? day.label : 'Day ' + count}</span></div>`
                        });
                        $tbl.append(html)
                        $scope.show_approve_table = true;
                        $scope.num_aprv_day = res.success.count
                    }  else if (res.error) {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            res.error,
                            'error'
                        )
                        if(field_name == 'leave_aprv_strt_date') {
                            $scope.leave_aprv_strt_date = null;
                        } else {
                            $scope.leave_aprv_end_date = null
                        }
                    } else {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            'Invalid response from server, please check your internet connection',
                            'error'
                        )
                    }
                    $scope.$digest()
                }
            })
        }
    }
    $scope.reset = function() {
        $scope.leaves_available = 0;
        $scope.leave_type = '';
        <?php if($this->session->userdata('isAdmin')==1 || $this->session->userdata('supervisor')==1 || $this->permission->full('leave')->access()): ?>
            $scope.employee_id = '';
        <?php endif ?>
        $scope.leave_day_type = 'full_day';
        $('#attachments').val('')
        $('#reason').val('')
        $('.dont-select-me').parent('div').find('.select2-selection__rendered').text('Select One...')
        $scope.form_state('leave_day_type')
    }
})
</script>