<div class="container-fluid">
    <?php 
    foreach ($inputs as $input) :
      $input['name'] = preg_replace('#[^\w\d\_]+#is', '_', $input['name']);
    ?>
    <?php $is_required = 'required="required"';
    if(isset($input['required'])){
      if($input['required'] == false){
        $is_required = '';
      }
    }
    ?>
      <?php if($input['base'] == 'input'): ?>
          <?php if($input['type'] == 'select'): ?>
              <div class="form-group">
                <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
                <select class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" <?= $is_required ?> style="width: 100%;">
                  <option value="">Select One</option>
                  <?php if(isset($input['options'])): ?>
                    <?php foreach ($input['options'] as $opt_key => $opt_value) :?>
                        <option value="<?= $opt_key ?>"><?= $opt_value ?></option>
                    <?php endforeach?>
                  <?php endif?>
                  <?php if($input['options_range']): ?>
                    <?php for ($i=$input['options_range']['from']; $i <= $input['options_range']['to'] ; $i++) :?>
                      <option value="<?= $i ?>"><?= $i ?></option>
                    <?php endfor?>
                  <?php endif?>
                </select>
              </div>
          <?php elseif($input['type'] == 'date'): ?>
            <div class="form-group">
              <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
              <input type="date" class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" placeholder="<?= $input['title'] ?>" <?= $is_required ?>>
            </div>
          <?php elseif($input['type'] == 'multiple_dates'): ?>
            <div class="form-group">
              <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
              <input type="date" class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" placeholder="<?= $input['title'] ?>" <?= $is_required ?>>
            </div>
            <script>
              $('#dd<?= $input['name'] ?>').flatpickr({
                  mode: "multiple",
                  dateFormat: "d-m-Y",
              })
            </script>
          <?php elseif($input['type'] == 'text'): ?>
            <div class="form-group">
              <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
              <input type="text" class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" placeholder="<?= $input['title'] ?>" <?= $is_required ?>>
            </div>
          <?php elseif($input['type'] == 'textarea'): ?>
            <div class="form-group">
              <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
              <textarea class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" rows="3" placeholder="<?= $input['title'] ?>" <?= empty($is_required) ? null : 'data-required="tiny"' ?>></textarea>
            </div>
            <script>
              tinymce.init({
                selector: 'textarea#dd<?= $input['name'] ?>',
                menubar: false,
                statusbar: false,
                toolbar: false,
                height: 100,
                paste_remove_styles: true,
                plugins: 'paste',
                paste_as_text: true
              });
            </script>
          <?php elseif($input['type'] == 'number'): ?>
            <div class="form-group">
              <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
              <input type="text" class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" placeholder="<?= $input['title'] ?>" pattern="^[0-9,\.]+$" <?= $is_required ?>>
            </div>
          <?php elseif($input['type'] == 'currency'): ?>
            <div class="form-group">
              <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
              <input type="text" class="form-control inputmaskcurr" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>" placeholder="<?= $input['title'] ?>" pattern="^[0-9,\.]+$" <?= $is_required ?>>
            </div>
            <script>
              $('#dd<?= $input['name'] ?>').inputmask({
                alias: 'numeric',
                groupSeparator: ',',
                digitsOptional: true,
                placeholder: '0'
              })
            </script>
          <?php endif ?>
      <?php elseif($input['base'] == 'db'): ?>
          <?php if($input['type'] == 'select'): ?>
              <div class="form-group">
                <label for="dd<?= $input['name'] ?>"><?= $input['title'] ?> <?= empty($is_required) ? null : '*' ?></label>
                <?php $options = getByWhereAsArray($input['db_data']['table'], implode(',', [$input['db_data']['key'], $input['db_data']['title']]), [], [$input['db_data']['title'], 'ASC']);
                if($input['db_data']['table'] == 'employee_history'){
                  $options = array_map('decrypt_employee_data', $options);
                }?>
                <select class="form-control" name="<?= $input['name'] ?>" id="dd<?= $input['name'] ?>"  <?= $is_required ?> style="width: 100%;">
                  <option value="">Select One</option>
                  <?php foreach ($options as $opt_value) :?>
                      <option value="<?= $opt_value[$input['db_data']['key']] ?>"><?= $opt_value[$input['db_data']['title']] ?></option>
                  <?php endforeach?>
                </select>
              </div>
          <?php endif ?>
      <?php endif?>
    <?php endforeach;?>
    <small>Fields marked with * are required</small>
</div>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/js.php') ?>