<style>
    .ck-editor__editable {
        min-height: 500px;
    }

    .mce-tinymce.mce-fullscreen {
        z-index: 9999;
    }

    .mce-tinymce button {
        background-color: #fff;
        color: #000;
    }

    .mce-btn.mce-active button,
    .mce-btn.mce-active:hover button,
    .mce-btn.mce-active i,
    .mce-btn.mce-active:hover i {
        color: #000;
    }
    ul#sortable{
        list-style: none;
    }
    ul#sortable .del-item{
        position: absolute;
        right: 25px;
    }
    ul#sortable .fa-arrows{
        cursor: pointer;
        margin-right: 10px;
    }
</style>
<div class="container-fluid">
    <form method="post">
        <div class="form-group">
            <label for="txtTitle">Title</label>
            <input type="text" name="title" id="txtTitle" class="form-control" placeholder="Letter title"
                value="<?= first_or_second($after_submit, set_value('title'), $letter->title) ?>">
        </div>
        <div class="form-group">
            <label for="selAuthor">Author Type</label>
            <select class="form-control dont-select-me" name="author_type" id="selAuthor" required>
                <option
                    <?= strtolower(first_or_second($after_submit, set_value('author_type'), $letter->author_type)) == 'hr' ? 'selected' : null ?>>
                    HR</option>
                <option
                    <?= strtolower(first_or_second($after_submit, set_value('author_type'), $letter->author_type)) == 'manager' ? 'selected' : null ?>>
                    Manager</option>
            </select>
        </div>
        <div class="form-group">
            <label for="txtFooterNote">Footer Note</label>
            <input type="text" class="form-control" name="footer_note" id="txtFooterNote" placeholder="Footer note" maxlength="145" value="<?= first_or_second($after_submit, set_value('footer_note'), $letter->footer_note) ?>">
            <small id="helpId" class="form-text text-muted">Leave empty to hide footer note</small>
        </div>
        <fieldset class="letter_radios">
            <div class="form-group row">
                <div class="col-md-3">
                    <label class="check-label"><?= display('hr_manager_approval_required') ?>:</label>
                </div>
                <div class="col-md-3">
                    <div class="radio icheck-danger">
                        <input type="radio" id="requires_admin_approvaly" name="requires_admin_approval" value="yes" <?= $letter->requires_admin_approval == 1 ? 'checked' : null ?>>
                        <label for="requires_admin_approvaly"><?= display('yes') ?></label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="radio icheck-danger">
                        <input type="radio" id="requires_admin_approvaln" name="requires_admin_approval" value="no" <?= $letter->requires_admin_approval == 0 ? 'checked' : null ?>>
                        <label for="requires_admin_approvaln"><?= display('no') ?></label>
                    </div>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-md-3">
                    <label class="check-label"><?= display('has_penalty') ?>:</label>
                </div>
                <div class="col-md-3">
                    <div class="radio icheck-danger">
                        <input type="radio" id="has_penaltyy" name="has_penalty" value="yes" <?= empty($penalties) ? null : 'checked' ?>>
                        <label for="has_penaltyy"><?= display('yes') ?></label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="radio icheck-danger">
                        <input type="radio" id="has_penaltyn" name="has_penalty" value="no" <?= empty($penalties) ? 'checked' : null ?>>
                        <label for="has_penaltyn"><?= display('no') ?></label>
                    </div>
                </div>
                <br>
                <br>
                <div class="row" id="penalty_block" style="margin-top:20px; display:none">
                    <div class="col-md-6">
                        <label class="col-md-6"><?= display('salary_penalty') ?>:</label>
                        <div class="col-md-6">
                            <input type="text" name="penalty[salary]" class="form-control currency" value="<?= $penalties['salary'] ?? 0 ?>">
                            <small><?= display('leave_empty_ignore') ?></small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="col-md-6"><?= display('leave_penalty') ?>:</label>
                        <div class="col-md-6">
                            <input type="number" min="-20" max="20" step="0.5" name="penalty[leave]" class="form-control" value="<?= $penalties['leave'] ?? 0 ?>">
                            <small><?= display('leave_empty_ignore') ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>
        <div class="row"></div>
        <div class="form-group">
            <label>Questions</label> <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modelQuestions" style="margin: 10px"><i class="fa fa-plus" aria-hidden="true"></i> Add Question</button>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Tag</th>
                        <th>Treat As Suspension</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="questions-body">
                    <?php foreach (@$letter->input_structure as $question) :
                        $question['id'] = $question['id'] ?? random_string();
                        ?>
                        <script>
                            $(document).ready(function () {
                                question.set('<?= $question['id'] ?>', JSON.parse('<?= addslashes(json_encode($question)) ?>'))
                            });
                        </script>
                        <tr id="<?= $question['id'] ?>">
                            <td class="title">
                                <?= $question['title'] ?>
                            </td>
                            <td class="slug" data-slug="<?= $question['name'] ?>">
                                {{input:<?= $question['name'] ?>}}
                            </td>
                            <td>
                                <?php if(in_array($question['type'], ['date', 'multiple_dates'])) : ?>
                                    <div class="pretty p-default p-curve p-toggle"><input class="is_suspension" type="checkbox" <?= $question['is_suspension'] ? 'checked' : null ?>/><div class="state p-success p-on"><label>Yes</label></div><div class="state p-off"><label>No</label></div></div>
                                <?php endif?>
                            </td>
                            <td>
                                <button type="button" class="btn btn-primary btn-edit"><i class="fa fa-pencil" aria-hidden="true"></i></button>
                                <button type="button" class="btn btn-danger btn-remove"><i class="fa fa-trash" aria-hidden="true"></i></button>
                            </td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
            </table>
        </div>
        <div class="form-group">
            <label for="txtBody">Letter Body</label>
            <textarea class="form-control editor" name="body" id="txtBody"
                rows="15"><?= first_or_second($after_submit, set_value('body'), $letter->body) ?></textarea>
        </div>
        <div class="row pull-right">
            <div class="form-group">
                <button type="submit" class="btn btn-primary" style="margin-right: 15px;">Update</button>
            </div>
        </div>
    </form>
</div>
<script>
    $(document).ready(function () {
        $("select:not(.no-seletize)").selectize({
            plugins: ["remove_button"]
        });
    });
</script>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/tinymce.php') ?>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/questions-modal.php') ?>