<script src="<?= base_url() ?>application/modules/incident/assets/js/question.js"></script>
<script>
    var question = new Question();
    var tagsToReplace = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;'
    };

    function replaceTag(tag) {
        return tagsToReplace[tag] || tag;
    }

    function safe_tags_replace(str) {
        return str.replace(/[&<>]/g, replaceTag);
    }
    $(document).ready(function () {
        $('select#seldbTable').selectize({
            plugins: ["remove_button"],
            onChange: function(val){
                $.ajax({
                    type: "POST",
                    url: "<?= base_url() ?>incident/letter/get_columns",
                    data: {
                        table_name: val
                    },
                    success: function (res) {
                        if(res.success){
                            var colSelect = $('select#seldbcol')[0].selectize;
                            colSelect.clear()
                            colSelect.clearOptions(true)
                            colSelect.addOption(res.success)
                            colSelect.refreshOptions(false)
                            colSelect.trigger('change')
                        }
                    }
                });
            }
        })
        $('select#selQtype').on('change', function(){
            $('div#db_fields').hide()
            $('div#input_fields').hide()
            if(this.value == 'input'){
                $('div#input_fields').show()
            }else{
                $('div#db_fields').show()
            }
        })
        $('[name=has_penalty]').on('change', function(){
            if($(this).is(':checked')) {
                $('#penalty_block').fadeOut()
                if($(this).val() == 'yes') {
                    $('#penalty_block').fadeIn()
                }
            }
        })
        $('input[name=penalty\\[leave\\]]').on('change', function(){
            if(this.value % 0.5 != 0) {
                this.value = 0;
                Swal.fire(
                    '<?= display('error') ?>!',
                    'Invalid fraction! Leave penalty can only be sum of half-day or full-day leaves.',
                    'error'
                )
            }
        })
        $('select#selInputType').on('change', function(){
            $('div#option_builder').hide();
            if(this.value == 'select'){
                $('div#option_builder').show();
            }
        })
        $('input#txtqTitle, input#txtSlug').on('keyup', function(){
            $('input#txtSlug').val(this.value.toLowerCase().replace(/[^\d\w]+/g, '_'))
        })
        $('input#txtqTitle, input#txtSlug').on('change', function(){
            $('input#txtSlug').val(this.value.toLowerCase().replace(/[^\d\w]+/g, '_'))
        })
        $('#inputaddopts').on('keypress',function(e) {
            if(e.which == 13) {
                if(this.value && this.value.replace(/\s+/g).length > 0){
                    $('ul#sortable').append('<li data-id="'+ safe_tags_replace(this.value) +'"><i class="fa fa-arrows" aria-hidden="true"></i> <span>' + safe_tags_replace(this.value) + '</span><a href="#"><i class="fa fa-trash del-item" aria-hidden="true"></i></a></li>')
                    this.value = ''
                }
            }
        });
        $('ul#sortable').sortable({axis: "y"})
        $('.add-field').on('click', function(){
            var $modal = $('#modelQuestions')
            if(!validate_modal($modal.find('[name=id]').val())){
                return
            }
            var obj = {};
            obj.title = $modal.find('[name=title]').val()
            obj.name = $modal.find('[name=slug]').val()
            obj.required = $modal.find('[name=required]').val() == 'true'

            if($modal.find('[name=q_type]').val() == 'input'){
                obj.base = 'input'
                obj.type = $modal.find('[name=type]').val()
                if($modal.find('[name=type]').val() == 'select'){
                    var opts = $('ul#sortable').sortable('toArray', {attribute: 'data-id'});
                    obj.options = {}
                    opts.forEach(opt => {
                        obj.options[opt] = opt
                    });
                }
            }
            if($modal.find('[name=q_type]').val() == 'db'){
                obj.base = 'db'
                obj.type = 'select'
                obj.db_data = {
                    table: $modal.find('[name=db_table]').val(),
                    key: $modal.find('[name=db_column]').val(),
                    title: $modal.find('[name=db_column]').val()
                }
            }
            if($modal.find('[name=id]').val().length > 0){
                var row = $('#questions-body').find('tr#'+$modal.find('[name=id]').val());
                row.find('td.title').text($modal.find('[name=title]').val())
                row.find('td.slug').text(`{{input:${$modal.find('[name=slug]').val()}}}`)
                
                question.update($modal.find('[name=id]').val(), obj)
            }else{
                let id_str = `rr${new Date().getTime()}`;
                $('#questions-body').append(
                    `<tr id="${id_str}">
                        <td class="title">
                            ${$modal.find('[name=title]').val()}
                        </td>
                        <td class="slug" data-slug="${$modal.find('[name=slug]').val()}">
                            {{input:${$modal.find('[name=slug]').val()}}}
                        </td>
                        <td>
                            ${['date', 'multiple_dates'].includes(obj.type) ? '<div class="pretty p-default p-curve p-toggle"><input class="is_suspension" type="checkbox" /><div class="state p-success p-on"><label>Yes</label></div><div class="state p-off"><label>No</label></div></div>' : ''}
                        </td>
                        <td>
                            <button type="button" class="btn btn-primary btn-edit"><i class="fa fa-pencil" aria-hidden="true"></i></button>
                            <button type="button" class="btn btn-danger btn-remove"><i class="fa fa-trash" aria-hidden="true"></i></button>
                        </td>
                    </tr>`
                )
                question.set(`${id_str}`, obj)
            }
            $modal.modal('hide')
        })
        $('#questions-body').on('click', '.btn-edit', function(){
            var row = $(this).closest('tr');
            var obj = question.get_by_id(row.attr('id'))
            var $modal = $('#modelQuestions')
            $modal.find('.modal-title-create').hide()
            $modal.find('.modal-title-update').show()
            $modal.find('[name=id]').val($(this).closest('tr').attr('id'))
            $modal.find('[name=title]').val(obj.title)
            $modal.find('[name=slug]').val(obj.name)
            $modal.find('[name=required]')[0].selectize.setValue(obj.required ? 'true' : 'false')
            $modal.find('[name=required]')[0].selectize.trigger('change')
            $modal.find('[name=q_type]')[0].selectize.setValue(obj.base)
            $modal.find('[name=q_type]')[0].selectize.trigger('change')
            if(obj.base == 'db'){
                $modal.find('[name=db_table]')[0].selectize.setValue(obj.db_data.table)
                $modal.find('[name=db_table]')[0].selectize.trigger('change')
                $modal.find('[name=db_column]').one('change', () => {
                    $modal.find('[name=db_column]')[0].selectize.setValue(obj.db_data.key)
                    $modal.find('[name=db_column]')[0].selectize.trigger('change')
                })
            }
            if(obj.base == 'input') {
                $modal.find('[name=type]')[0].selectize.setValue(obj.type)
                $modal.find('[name=type]')[0].selectize.trigger('change')
                if(obj.type == 'select'){
                    for (const key in obj.options) {
                        $('ul#sortable').append('<li data-id="'+ key +'"><i class="fa fa-arrows" aria-hidden="true"></i> <span>' + key + '</span><a href="#"><i class="fa fa-trash del-item" aria-hidden="true"></i></a></li>')
                    }
                }
            }
            $modal.modal('show')
        })
        $('#questions-body').on('click', '.btn-remove', function(){
            if(confirm('Are you sure you want to remove this question?')){
                var row = $(this).closest('tr');
                var sel_slug = row.find('.slug').data('slug')
                question.delete(sel_slug)
                $(this).closest('tr').remove()
            }
        })
        $('ul#sortable').on('click', '.del-item', function(e){
            e.preventDefault();
            $(this).closest('li').remove()
        })
        $('#questions-body').on('change', '.is_suspension', function() {
            var row = $(this).closest('tr');
            var obj = question.get_by_id(row.attr('id'))
            obj.is_suspension = $(this).is(':checked');
        })
        function validate_modal(id) {
            var $modal = $('#modelQuestions')
            if(!$modal.find('[name=title]').val()){
                alert('Title of question is required')
                return false;
            }
            var slug_val = $modal.find('[name=slug]').val();
            if(!slug_val){
                alert('Slug of question is required')
                return false
            }
            if(question.get(slug_val, id)){
                alert(`Tag '${slug_val}' already exists`)
                return false;
            }
            if(!$modal.find('[name=q_type]').val()){
                alert('Type of question is required')
                return false
            }
            if($modal.find('[name=q_type]').val() == 'input'){
                if($modal.find('[name=type]').val() == 'select' && !$('ul#sortable').sortable('toArray', {attribute: 'data-id'}).length){
                    alert('Options of question are required')
                    return false
                }
            }
            if($modal.find('[name=q_type]').val() == 'db'){
                if(!$modal.find('[name=db_table]').val()){
                    alert('Database table name is required')
                    return false
                }
                if(!$modal.find('[name=db_column]').val()){
                    alert('Database column name is required')
                    return false
                }
            }
            return true;
        }
        function reset_questions_modal() {
            $modal = $('#modelQuestions')
            $modal.find('.modal-title-create').show()
            $modal.find('.modal-title-update').hide()
            $modal.find('[name=id]').val('')
            $modal.find('[name=title]').val('')
            $modal.find('[name=slug]').val('')
            $modal.find('[name=required]')[0].selectize.setValue('true')
            $modal.find('[name=q_type]')[0].selectize.setValue('')
            $modal.find('[name=type]')[0].selectize.setValue('text')
            $modal.find('#inputaddopts').val('')
            $modal.find('[name=type]')[0].selectize.setValue('text')
            $modal.find('#sortable').html('')
            $modal.find('[name=db_table]')[0].selectize.setValue('')
            $modal.find('[name=db_column]')[0].selectize.setValue('')
            $modal.find('#input_fields').hide()
            $modal.find('#db_fields').hide()
        }
        $('#modelQuestions').on('hidden.bs.modal', reset_questions_modal)
        $('input.currency').inputmask({
            alias: 'numeric',
            groupSeparator: ',',
            digitsOptional: true,
            placeholder: '0',
            rightAlign: false
        })
        $('form').on('submit', function(e) {
            e.preventDefault()
            let formdata = $(this).serialize().split('&')
            formdata.push('body=' + encodeURIComponent(tinymce.editors[0].getContent()))
            formdata.push('question=' + btoa(JSON.stringify(question.get())))
            myajax({
                type: 'POST',
                data: formdata.join('&'),
                success: function(res) {
                    if(res.success) {
                        Swal.fire({
                            title: '<?= display('success') ?>!',
                            html: res.success,
                            timer: 2500,
                            allowOutsideClick: false,
                            allowEscapeKey: false,
                            timerProgressBar: true,
                            didOpen: () => {
                                Swal.showLoading()
                            },
                        })
                    } else if (res.error) {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            res.error,
                            'error'
                        )
                    } else if (res.errors) {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            res.errors.map((err) => {return err[1]}).join("\n"),
                            'error'
                        )
                    } else {
                        Swal.fire(
                            '<?= display('error') ?>!',
                            'Invalid response from server, check your internet connection',
                            'error'
                        )
                    }
                    if(res.redirect) {
                        location.href = res.redirect;
                    }
                }
            })
        })
        
        $('[name=has_penalty]').trigger('change')
    });
</script>
<div class="modal fade" id="modelQuestions" tabindex="-1" role="dialog" data-controls-modal="your_div_id" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title modal-title-create">Create Question</h5>
                <h5 class="modal-title modal-title-update" style="display: none;">Update Question</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="id">
                <div class="form-group">
                  <label for="txtqTitle">Title *</label>
                  <input type="text" class="form-control" name="title" id="txtqTitle" placeholder="Title for input" required>
                </div>
                <div class="form-group">
                  <label for="txtSlug">Identifier *</label>
                  <input type="text" class="form-control" name="slug" id="txtSlug" placeholder="Unique identifier for input" required>
                </div>
                <div class="form-group">
                  <label for="selRequ">Required *</label>
                  <select class="form-control dont-select-me" name="required" id="selRequ" required>
                    <option value="true">Yes</option>
                    <option value="false">No</option>
                  </select>
                </div>
                <div class="form-group">
                  <label for="selQtype">Question Type *</label>
                  <select class="form-control dont-select-me" name="q_type" id="selQtype" required>
                    <option value="">Select One</option>
                    <option value="input">Input Based</option>
                    <option value="db">Database Column Based</option>
                  </select>
                </div>
                <div id="input_fields" style="display: none;">
                    <div class="form-group">
                      <label for="selInputType">Field Type *</label>
                      <select class="form-control dont-select-me" name="type" id="selInputType">
                        <option value="text">Text Field</option>
                        <option value="textarea">Text Box</option>
                        <option value="number">Numeric Field</option>
                        <option value="currency">Currency Field</option>
                        <option value="select">Options Field</option>
                        <option value="date">Date Field</option>
                        <option value="multiple_dates">Multiple Days Selection</option>
                      </select>
                    </div>
                    <div id="option_builder" style="display: none;">
                        <input type="text" id="inputaddopts" class="form-control" placeholder="Type here and press enter to add options">
                        <small>Write option value and press enter to add</small>
                        <h4>Options:</h4>
                        <ul id="sortable"></ul>
                    </div>
                </div>
                <div id="db_fields" style="display: none;">
                    <div class="form-group">
                        <label for="seldbTable">Select Table *</label>
                        <select class="form-control dont-select-me no-seletize" name="db_table" id="seldbTable">
                            <option value="">Select One</option>
                            <?php foreach ($tables as $table) :?>
                                <option value="<?= $table['key'] ?>"><?= $table['value'] ?></option>
                                <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                      <label for="seldbcol">Select Column *</label>
                      <select class="form-control dont-select-me" name="db_column" id="seldbcol">
                      </select>
                    </div>
                </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary add-field">Save</button>
            </div>
        </div>
    </div>
</div>