<div class="container-fluid">
    <table class="table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>Employee</th>
                <th>Type</th>
                <th>Title</th>
                <th>Details/Reason</th>
                <th>Remarks</th>
                <th>Requested By</th>
                <th>Updated</th>
                <th>Status</th>
                <?php if($this->permission->method('incident_rejected', 'update')->access()): ?>
                <th>Letter</th>
                <?php endif?>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    beforeSend: function(){},
                    complete: function(){
                        $('.readmore-block').readmore()
                    }
                },
                columns: [{
                        'data': 'id',
                    }, {
                        'data': 'employee_name',
                    }, {
                        'data': 'type',
                    }, {
                        'data': 'incident_type',
                    },
                    {
                        'data': 'details',
                    },
                    {
                        'data': 'remarks',
                        'sortable': false
                    },
                    {
                        'data': 'adder',
                    }, {
                        'data': 'updated_at',
                    },
                    {
                        'data': 'status'
                    },
                    <?php if($this->permission->method('incident_rejected', 'update')->access()): ?>
                    {
                        'data': 'file_path',
                    },
                    <?php endif ?>
                    {
                        'data': 'action',
                        'sortable': false
                    },
                ],
                order: [
                    [7, 'desc']
                ]
            }
        ))
        $('#modal-contest').on('submit', 'form', function (e) {
            e.preventDefault()
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/contest",
                data: $(this).serialize(),
                success: function (res) {
                    if (res.success) {
                        $modal.modal('hide')
                        window.dtable.ajax.reload()
                        toastr.success(res.success)
                    } else if (res.error) {
                        alert(res.error)
                    } else {
                        console.log(res);
                        alert('Unknown error, try again')
                    }
                }
            });
        })
    });
    $('table.table').on('click', '.btn-contest', function (e) {
        e.preventDefault();
        $modal = $('#modal-contest')
        $modal.find('[name=id]').val($(this).data('id'))
        $modal.modal('show')
    })
    $('table.table').on('click', '.btn-contest-p', function (e) {
        e.preventDefault();
        if (confirm('Are you sure you want to ' + $(this).data('type') + ' this contestation?')) {
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/contest_update",
                data: {
                    id: $(this).data('id'),
                    status: $(this).data('type')
                },
                success: function (res) {
                    if (res.success) {
                        window.dtable.ajax.reload()
                        toastr.success(res.success)
                    } else if (res.error) {
                        alert(res.error)
                    } else {
                        console.log(res);
                        alert('Unknown error, try again');
                    }
                }
            });
        }
    })
</script>
<?php require_once(APPPATH . 'modules/incident/views/incident/scripts/save_print.php') ?>
<?php require_once(APPPATH . 'modules/incident/views/incident/scripts/logs.php') ?>
<div class="modal fade" id="modal-contest" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <form method="post">
            <div class="modal-content">
                <input type="hidden" name="id">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Remarks</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <textarea class="form-control" name="remarks" id="txtRemarks" rows="5"></textarea>
                    </div>
                    <div class="text-right">
                        <button type="submit" class="btn btn-success">Submit</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>