<div class="container-fluid">
    <table class="table table-hover">
        <thead>
            <tr>
                <th>#</th>
                <th>Employee</th>
                <th>Type</th>
                <th>Title</th>
                <th>Details/Reason</th>
                <th>Requested By</th>
                <th>Updated</th>
                <th>Status</th>
                <?php if($this->permission->method('incident_pending', 'update')->access()): ?>
                <th>Letter</th>
                <?php endif ?>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    beforeSend: function(){},
                    complete: function(){
                        $('.readmore-block').readmore()
                    }
                },
                columns: [{
                        'data': 'id',
                    }, {
                        'data': 'employee_name',
                    }, {
                        'data': 'type',
                    }, {
                        'data': 'incident_type',
                    }, {
                        'data': 'details',
                    },
                    {
                        'data': 'adder',
                    }, {
                        'data': 'updated_at',
                    },
                    {
                        'data': 'status'
                    },
                    <?php if($this->permission->method('incident_pending', 'update')->access()): ?>
                    {
                        'data': 'file_path',
                    },
                    <?php endif ?>
                    {
                        'data': 'action',
                        'sortable': false
                    },
                ],
                order: [
                    [6, 'desc']
                ]
            }
        ))
        $('#modal-remarks').on('submit', 'form', function (e) {
            e.preventDefault()
            var $form = $(this)
            var is_err = false
            $form.find('input, textarea').each(function(){
                if(!is_err && !$(this).val().replace(/[^\d\w]+/g, '').length){
                    is_err = true
                    alert('Remarks field cannot be empty');
                }
            })
            if(is_err){
                return
            }
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>incident/reject",
                data: $form.serialize(),
                success: function (res) {
                    if (res.success) {
                        $modal.modal('hide')
                        $form.trigger('reset')
                        window.dtable.ajax.reload()
                        toastr.success(res.success)
                    } else if (res.error) {
                        alert(res.error)
                    } else {
                        console.log(res);
                        alert('Unknown error, try again')
                    }
                }
            });
        })
    });
    $('table.table').on('click', '.btn-approve', function (e) {
        e.preventDefault();
        var type = 'incident';
        if($(this).data('type') == 'letter'){
            type = 'letter'
        }
        if(!confirm(`Are you sure you want to approve this ${type}?`)){
            return
        }
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>incident/approve",
            data: {
                id: $(this).data('id')
            },
            success: function (res) {
                if (res.success) {
                    window.dtable.ajax.reload()
                    toastr.success(res.success)
                } else if (res.error) {
                    alert(res.error)
                } else {
                    console.log(res);
                    alert('Unknown error, try again')
                }
            }
        });
    })
    $('table.table').on('click', '.btn-reject', function (e) {
        e.preventDefault();
        $modal = $('#modal-remarks')
        $modal.find('[name=id]').val($(this).data('id'))
        $modal.modal('show')
    })
</script>
<?php require_once(APPPATH . 'modules/incident/views/incident/scripts/logs.php') ?>
<div class="modal fade" id="modal-remarks" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <form method="post">
            <div class="modal-content">
                <input type="hidden" name="id">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Remarks</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <textarea class="form-control" name="remarks" id="txtRemarks" rows="5"></textarea>
                    </div>
                    <div class="text-right">
                        <button type="submit" class="btn btn-success">Submit</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>