<div class="container-fluid">
    <form class="letter-form" method="post">
        <div class="row">
            <div class="col-md-2"></div>
            <div class="col-md-8">
                <div class="row">
                    <div class="form-group">
                        <label for="selIncidentType">Employee *</label>
                        <select class="form-control dont-select-me" name="employee_id[]" id="selEmployee" required <?= $this->permission->module('generate_hr_letters')->access()  ? 'multiple' : null ?>>
                            <option value="">Select Employee</option>
                            <?php foreach ($employees as $employee) :?>
                                <option value="<?= $employee->employee_id ?>"><?= sprintf('%s %s (%s)', $employee->first_name, $employee->last_name, $employee->hrm_id) ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="selLetter">Letter *</label>
                        <select class="form-control dont-select-me" name="letter_id" id="selLetter" required>
                            <option value="">Select Letter</option>
                            <?php foreach ($letters as $letter) :?>
                                <option value="<?= $letter->id ?>"><?= $letter->title ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                    <div class="form-group">
                      <label for="txtReason">Reason For Letter Issuance *</label>
                      <textarea class="form-control" name="reason" id="txtReason" rows="3"></textarea>
                    </div>
                    <div class="text-right">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script src="<?= base_url() ?>assets/plugins/tinymce/tinymce.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/tinymce/jquery.tinymce.min.js"></script>
<script>
    $(document).ready(function () {
        $("select:not(#selEmployee)").selectize({
            plugins: ["remove_button"]
        });
        tinymce.init({
            selector: 'textarea#txtReason',
            menubar: false,
            statusbar: false,
            toolbar: false,
            height: 100,
            paste_remove_styles: true,
            plugins: 'paste',
            paste_as_text: true
        });
        <?php if($this->permission->module('generate_hr_letters')->access()): ?>
            $("select#selEmployee").selectize({
                plugins: ["remove_button"],
                create: function(input){
                    return {
                        value: input,
                        text: input
                    }
                }
            });
        <?php else: ?>
            $("select#selEmployee").selectize({
                plugins: ["remove_button"]
            });
        <?php endif ?>
    });
</script>
<?php
require_once(array_to_path([APPPATH, 'modules', 'incident', 'views', 'incident', 'scripts', 'letter_input.php']));
?>